/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

public class ExcelWorksheet {
    private XMLEventFactory eventFactory;
    private SharedStringMap stringTable;
    private Set<String> excludedColumns;
    private Set<String> excludedColors;
    private ExcelStyles styles;
    private boolean excludeHiddenRowsAndColumns;
    private boolean isSheetHidden;
    private Relationships worksheetRels;
    private Map<String, Boolean> tableVisibilityMap;
    static final QName ROW = Namespaces.SpreadsheetML.getQName("row");
    static final QName COL = Namespaces.SpreadsheetML.getQName("col");
    static final QName CELL = Namespaces.SpreadsheetML.getQName("c");
    static final QName VALUE = Namespaces.SpreadsheetML.getQName("v");
    static final QName TABLE = Namespaces.SpreadsheetML.getQName("tablePart");
    static final QName CELL_LOCATION = new QName("r");
    static final QName CELL_TYPE = new QName("t");
    static final QName CELL_STYLE = new QName("s");
    static final QName HIDDEN = new QName("hidden");
    static final QName MIN = new QName("min");
    static final QName MAX = new QName("max");

    public ExcelWorksheet(XMLEventFactory eventFactory, SharedStringMap stringTable, ExcelStyles styles, Relationships worksheetRels, Map<String, Boolean> tableVisibilityMap, boolean isSheetHidden, Set<String> excludedColumns, Set<String> excludedColors, boolean excludeHiddenRowsAndColumns) {
        this.eventFactory = eventFactory;
        this.stringTable = stringTable;
        this.styles = styles;
        this.worksheetRels = worksheetRels;
        this.tableVisibilityMap = tableVisibilityMap;
        this.isSheetHidden = isSheetHidden;
        this.excludedColumns = new HashSet<String>(excludedColumns);
        this.excludedColors = excludedColors;
        this.excludeHiddenRowsAndColumns = excludeHiddenRowsAndColumns;
    }

    void parse(XMLEventReader reader, XMLEventWriter writer) throws IOException, XMLStreamException {
        boolean excluded = false;
        boolean inValue = false;
        boolean isSharedString = false;
        boolean inHiddenRow = false;
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            if (e.isStartElement()) {
                StartElement el = e.asStartElement();
                if (el.getName().equals(CELL)) {
                    Attribute styleAttr;
                    Attribute typeAttr = el.getAttributeByName(CELL_TYPE);
                    if (typeAttr != null && typeAttr.getValue().equals("s")) {
                        String currentColumn = ExcelWorksheet.getLocationColumn(el.getAttributeByName(CELL_LOCATION).getValue());
                        excluded = this.excludedColumns.contains(currentColumn) || inHiddenRow;
                        isSharedString = true;
                    }
                    if ((styleAttr = el.getAttributeByName(CELL_STYLE)) != null) {
                        int styleIndex = Integer.valueOf(styleAttr.getValue());
                        ExcelStyles.CellStyle style = this.styles.getCellStyle(styleIndex);
                        for (String excludedColor : this.excludedColors) {
                            if (!style.fill.matchesColor(excludedColor)) continue;
                            excluded = true;
                            break;
                        }
                    }
                } else if (el.getName().equals(VALUE)) {
                    inValue = true;
                } else if (el.getName().equals(ROW)) {
                    inHiddenRow = this.isHidden(el);
                } else if (el.getName().equals(COL)) {
                    if (this.isHidden(el)) {
                        this.excludedColumns.addAll(this.extractColumnNames(el));
                    }
                } else if (el.getName().equals(TABLE)) {
                    String relId = XMLEventHelpers.getAttributeValue(el, Relationships.ATTR_REL_ID);
                    Relationships.Rel tableRel = this.worksheetRels.getRelById(relId);
                    this.tableVisibilityMap.put(tableRel.target, !this.isSheetHidden);
                }
            } else if (e.isEndElement()) {
                EndElement el = e.asEndElement();
                if (el.getName().equals(CELL)) {
                    excluded = false;
                    isSharedString = false;
                } else if (el.getName().equals(VALUE)) {
                    inValue = false;
                }
            } else if (e.isCharacters() && inValue && isSharedString) {
                int origIndex = ExcelWorksheet.getSharedStringIndex(e.asCharacters().getData());
                int newIndex = this.stringTable.createEntryForString(origIndex, excluded).getNewIndex();
                e = this.eventFactory.createCharacters(String.valueOf(newIndex));
            }
            writer.add(e);
        }
    }

    private boolean isHidden(StartElement el) {
        return this.excludeHiddenRowsAndColumns && (this.isSheetHidden || this.parseOptionalBooleanAttribute(el, HIDDEN, false));
    }

    private boolean parseOptionalBooleanAttribute(StartElement el, QName attrName, boolean defaultValue) {
        Attribute a = el.getAttributeByName(attrName);
        if (a == null) {
            return defaultValue;
        }
        String v = a.getValue();
        if ("true".equals(v) || "1".equals(v)) {
            return true;
        }
        if ("false".equals(v) || "0".equals(v)) {
            return false;
        }
        return defaultValue;
    }

    List<String> extractColumnNames(StartElement el) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            int min = Integer.valueOf(el.getAttributeByName(MIN).getValue());
            int max = Integer.valueOf(el.getAttributeByName(MAX).getValue());
            for (int i = min; i <= max; ++i) {
                names.add(ExcelWorksheet.indexToColumnName(i));
            }
            return names;
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new OkapiBadFilterInputException("Invalid <col> element", e);
        }
    }

    static String indexToColumnName(int index) {
        StringBuilder sb = new StringBuilder();
        while (index > 0) {
            int modulo = (index - 1) % 26;
            sb.insert(0, (char)(65 + modulo));
            index = (index - modulo) / 26;
        }
        return sb.toString();
    }

    private static int getSharedStringIndex(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Unexpected shared string index '" + value + "'");
        }
    }

    private static String getLocationColumn(String location) {
        char[] buf = location.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (!Character.isDigit(buf[i])) continue;
            return location.substring(0, i);
        }
        throw new IllegalStateException("Unexpected worksheet cell location '" + location + "'");
    }
}

