/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockPropertiesFactory;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.BlockPropertyFactory;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class MarkupComponentParser {
    MarkupComponentParser() {
    }

    static MarkupComponent parseEmptyElementMarkupComponent(XMLEventReader eventReader, XMLEventFactory eventFactory, StartElement startElement) throws XMLStreamException {
        if (!eventReader.hasNext()) {
            throw new IllegalStateException("Unexpected structure");
        }
        XMLEvent nextEvent = eventReader.nextEvent();
        if (!XMLEventHelpers.isEndElement(nextEvent, startElement)) {
            throw new IllegalStateException("Unexpected structure");
        }
        return MarkupComponentFactory.createEmptyElementMarkupComponent(eventFactory, startElement, nextEvent.asEndElement());
    }

    static BlockProperties parseBlockProperties(StartElementContext startElementContext, ElementSkipper elementSkipper) throws XMLStreamException {
        ArrayList<BlockProperty> properties = new ArrayList<BlockProperty>();
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent event = startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isEndElement(event, startElementContext.getStartElement())) {
                return BlockPropertiesFactory.createBlockProperties(startElementContext.getEventFactory(), startElementContext.getStartElement(), event.asEndElement(), properties);
            }
            if (!event.isStartElement()) continue;
            if (elementSkipper.canBeSkipped(event.asStartElement())) {
                elementSkipper.skipElement(StartElementContextFactory.createStartElementContext(event.asStartElement(), startElementContext));
                continue;
            }
            BlockProperty property = BlockPropertyFactory.createBlockProperty(MarkupComponentParser.gatherEventsWithRevisionPropertiesSkipper(StartElementContextFactory.createStartElementContext(event.asStartElement(), startElementContext), elementSkipper));
            if (MarkupComponentParser.isEmptyBlockRunPropertiesElement(property)) continue;
            properties.add(property);
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private static boolean isEmptyBlockRunPropertiesElement(BlockProperty blockProperty) {
        return "rPr".equals(blockProperty.getName().getLocalPart()) && 2 == blockProperty.getEvents().size() && !blockProperty.getEvents().get(0).asStartElement().getAttributes().hasNext();
    }

    private static List<XMLEvent> gatherEventsWithRevisionPropertiesSkipper(StartElementContext startElementContext, ElementSkipper elementSkipper) throws XMLStreamException {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(startElementContext.getStartElement());
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent event = startElementContext.getEventReader().nextEvent();
            if (event.isStartElement() && elementSkipper.canBeSkipped(event.asStartElement())) {
                elementSkipper.skipElement(StartElementContextFactory.createStartElementContext(event.asStartElement(), startElementContext));
                continue;
            }
            events.add(event);
            if (!XMLEventHelpers.isEndElement(event, startElementContext.getStartElement())) continue;
            return events;
        }
        throw new IllegalStateException("Unexpected structure");
    }
}

