/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphSimplifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParagraphSimplifier.class);
    private XMLEventReader xmlReader;
    private XMLEventWriter xmlWriter;
    private XMLEventFactory eventFactory;
    private ConditionalParameters params;
    private StyleDefinitions styleDefinitions;

    public ParagraphSimplifier(XMLEventReader xmlReader, XMLEventWriter xmlWriter, XMLEventFactory eventFactory, ConditionalParameters params, StyleDefinitions styleDefinitions) {
        this.xmlReader = xmlReader;
        this.xmlWriter = xmlWriter;
        this.eventFactory = eventFactory;
        this.params = params;
        this.styleDefinitions = styleDefinitions;
    }

    public void process() throws XMLStreamException {
        while (this.xmlReader.hasNext()) {
            XMLEvent e = this.xmlReader.nextEvent();
            if (XMLEventHelpers.isParagraphStartEvent(e)) {
                Block block = new BlockParser(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.xmlReader, this.eventFactory, this.params), new IdGenerator(null), this.styleDefinitions).parse();
                this.flushEvents(block.getEvents());
                continue;
            }
            if (XMLEventHelpers.isSectionPropertiesStartEvent(e)) {
                e = AttributeStripper.RevisionAttributeStripper.stripSectionPropertiesRevisionAttributes(StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventFactory, this.params));
            } else if (XMLEventHelpers.isTableRowStartEvent(e)) {
                e = AttributeStripper.RevisionAttributeStripper.stripTableRowRevisionAttributes(StartElementContextFactory.createStartElementContext(e.asStartElement(), null, this.eventFactory, this.params));
            }
            this.xmlWriter.add(e);
        }
    }

    private void flushEvents(List<XMLEvent> events) throws XMLStreamException {
        for (XMLEvent e : events) {
            try {
                this.xmlWriter.add(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

