/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunMerger {
    private String paragraphStyle;
    private RunBuilder previousRunBuilder;
    private List<Block.BlockChunk> completedRuns = new ArrayList<Block.BlockChunk>();

    RunMerger() {
    }

    void setParagraphStyle(String paragraphStyle) {
        this.paragraphStyle = paragraphStyle;
    }

    List<Block.BlockChunk> getRuns() throws XMLStreamException {
        if (this.previousRunBuilder != null) {
            this.completedRuns.add(this.previousRunBuilder.build());
            this.previousRunBuilder = null;
        }
        return this.completedRuns;
    }

    void add(RunBuilder runBuilder) throws XMLStreamException {
        if (null == this.previousRunBuilder) {
            runBuilder.resetCombinedRunProperties(this.paragraphStyle);
            this.previousRunBuilder = runBuilder;
            return;
        }
        if (this.canMerge(this.previousRunBuilder, runBuilder)) {
            this.merge(this.previousRunBuilder, runBuilder);
        } else {
            this.completedRuns.add(this.previousRunBuilder.build());
            this.previousRunBuilder = runBuilder;
        }
    }

    private boolean canMerge(RunBuilder runBuilder, RunBuilder otherRunBuilder) {
        RunProperties combinedRunProperties = runBuilder.getCombinedRunProperties(this.paragraphStyle);
        RunProperties combinedOtherRunProperties = otherRunBuilder.getCombinedRunProperties(this.paragraphStyle);
        if (Namespaces.Math.containsName(runBuilder.getStartElementContext().getStartElement().getName())) {
            return false;
        }
        if (runBuilder.containsNestedItems() || otherRunBuilder.containsNestedItems()) {
            return false;
        }
        if (runBuilder.hasComplexCodes() || otherRunBuilder.hasComplexCodes()) {
            return false;
        }
        return this.canRunPropertiesBeMerged(combinedRunProperties, combinedOtherRunProperties);
    }

    private boolean canRunPropertiesBeMerged(RunProperties currentProperties, RunProperties otherProperties) {
        if (currentProperties.count() != otherProperties.count()) {
            return false;
        }
        int numberOfMatchedProperties = 0;
        block0: for (RunProperty currentProperty : currentProperties.getProperties()) {
            QName currentPropertyStartElementName = currentProperty.getName();
            for (RunProperty otherProperty : otherProperties.getProperties()) {
                QName otherPropertyStartElementName = otherProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                if (currentProperty instanceof MergeableRunProperty && otherProperty instanceof MergeableRunProperty ? !((MergeableRunProperty)((Object)currentProperty)).canBeMerged((MergeableRunProperty)((Object)otherProperty)) : !currentProperty.canBeReplaced(otherProperty)) {
                    return false;
                }
                ++numberOfMatchedProperties;
                continue block0;
            }
        }
        return numberOfMatchedProperties >= currentProperties.count();
    }

    void merge(RunBuilder runBuilder, RunBuilder otherRunBuilder) throws XMLStreamException {
        runBuilder.setRunProperties(this.mergeRunProperties(runBuilder.getRunProperties(), otherRunBuilder.getRunProperties()));
        runBuilder.resetCombinedRunProperties(this.paragraphStyle);
        ArrayList<XMLEvent> newBodyEvents = new ArrayList<XMLEvent>();
        XMLEventHelpers.addChunksToList(newBodyEvents, runBuilder.getRunBodyChunks());
        runBuilder.setTextPreservingWhitespace(runBuilder.isTextPreservingWhitespace() || otherRunBuilder.isTextPreservingWhitespace());
        XMLEventHelpers.addChunksToList(newBodyEvents, otherRunBuilder.getRunBodyChunks());
        runBuilder.getRunBodyChunks().clear();
        XMLListEventReader events = new XMLListEventReader(newBodyEvents);
        while (events.hasNext()) {
            runBuilder.addRunBody(events.nextEvent(), events);
        }
        runBuilder.flushText();
        runBuilder.flushMarkupChunk();
    }

    private RunProperties mergeRunProperties(RunProperties runProperties, RunProperties otherRunProperties) {
        if (0 == runProperties.count() && 0 == otherRunProperties.count()) {
            return runProperties;
        }
        List<RunProperty> mergeableRunProperties = runProperties.getMergeableRunProperties();
        if (mergeableRunProperties.isEmpty()) {
            return otherRunProperties;
        }
        List<RunProperty> otherMergeableRunProperties = otherRunProperties.getMergeableRunProperties();
        if (otherMergeableRunProperties.isEmpty()) {
            return runProperties;
        }
        if (mergeableRunProperties.size() >= otherMergeableRunProperties.size()) {
            List<RunProperty> remainedOtherMergeableRunProperties = this.mergeMergeableRunProperties(mergeableRunProperties, otherMergeableRunProperties);
            runProperties.getProperties().addAll(remainedOtherMergeableRunProperties);
            return runProperties;
        }
        List<RunProperty> remainedMergeableRunProperties = this.mergeMergeableRunProperties(otherMergeableRunProperties, mergeableRunProperties);
        otherRunProperties.getProperties().addAll(remainedMergeableRunProperties);
        return otherRunProperties;
    }

    private List<RunProperty> mergeMergeableRunProperties(List<RunProperty> mergeableRunProperties, List<RunProperty> otherMergeableRunProperties) {
        ArrayList<RunProperty> remainedOtherMergeableRunProperties = new ArrayList<RunProperty>(otherMergeableRunProperties);
        block0: for (RunProperty runProperty : mergeableRunProperties) {
            QName currentPropertyStartElementName = runProperty.getName();
            Iterator remainedOtherMergeableRunPropertyIterator = remainedOtherMergeableRunProperties.iterator();
            while (remainedOtherMergeableRunPropertyIterator.hasNext()) {
                RunProperty otherRunProperty = (RunProperty)remainedOtherMergeableRunPropertyIterator.next();
                QName otherPropertyStartElementName = otherRunProperty.getName();
                if (!currentPropertyStartElementName.equals(otherPropertyStartElementName)) continue;
                ((MergeableRunProperty)((Object)runProperty)).merge((MergeableRunProperty)((Object)otherRunProperty));
                remainedOtherMergeableRunPropertyIterator.remove();
                continue block0;
            }
        }
        return remainedOtherMergeableRunProperties;
    }

    void reset() {
        this.completedRuns.clear();
        this.previousRunBuilder = null;
    }

    class XMLListEventReader
    implements XMLEventReader {
        private Iterator<XMLEvent> events;

        XMLListEventReader(Iterable<XMLEvent> events) {
            this.events = events.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.events.hasNext();
        }

        @Override
        public XMLEvent nextEvent() {
            return this.events.next();
        }

        @Override
        public void remove() {
            this.events.remove();
        }

        @Override
        public XMLEvent nextTag() throws XMLStreamException {
            XMLEvent e = this.nextEvent();
            while (e != null) {
                if (e.isStartElement() || e.isEndElement()) {
                    return e;
                }
                if (!XMLEventHelpers.isWhitespace(e)) {
                    throw new IllegalStateException("Unexpected event: " + e);
                }
                e = this.nextEvent();
            }
            return null;
        }

        @Override
        public XMLEvent peek() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getElementText() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws XMLStreamException {
        }

        @Override
        public Object next() {
            return this.events.next();
        }
    }
}

