/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.UnstyledText;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunParser
implements Parser<RunBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunParser.class);
    private static final EnumSet<FieldDefinition> FIELD_DEFINITIONS_WITH_PERSISTENT_CONTENT = EnumSet.of(FieldDefinition.HYPERLINK);
    private RunBuilder runBuilder;
    private IdGenerator nestedTextualIds;
    private Deque<ComplexCodeProcessingState> nestedComplexCodeProcessingStates = new LinkedList<ComplexCodeProcessingState>();

    RunParser(StartElementContext startElementContext, IdGenerator nestedTextualIds, StyleDefinitions styleDefinitions) {
        this.runBuilder = new RunBuilder(StartElementContextFactory.createStartElementContext(AttributeStripper.RevisionAttributeStripper.stripRunRevisionAttributes(startElementContext), startElementContext), styleDefinitions);
        this.nestedTextualIds = nestedTextualIds;
    }

    @Override
    public RunBuilder parse() throws XMLStreamException {
        this.log("startRun: " + this.runBuilder.getStartElementContext().getStartElement());
        XMLEvent firstChild = this.runBuilder.getStartElementContext().getEventReader().nextTag();
        if (XMLEventHelpers.isRunPropsStartEvent(firstChild)) {
            this.processRunProperties(firstChild.asStartElement());
        } else {
            if (XMLEventHelpers.isEndElement(firstChild, this.runBuilder.getStartElementContext().getStartElement())) {
                return this.endRun(firstChild.asEndElement());
            }
            this.processRunBody(firstChild, this.runBuilder.getStartElementContext().getEventReader());
        }
        while (this.runBuilder.getStartElementContext().getEventReader().hasNext()) {
            XMLEvent e = this.runBuilder.getStartElementContext().getEventReader().nextEvent();
            this.log("processRun: " + e);
            if (XMLEventHelpers.isEndElement(e, this.runBuilder.getStartElementContext().getStartElement())) {
                return this.endRun(e.asEndElement());
            }
            this.processRunBody(e, this.runBuilder.getStartElementContext().getEventReader());
        }
        throw new IllegalStateException("Invalid content? Unterminated run");
    }

    private void processRunProperties(StartElement startElement) throws XMLStreamException {
        StartElementContext runPropertiesElementContext = StartElementContextFactory.createStartElementContext(startElement, this.runBuilder.getStartElementContext());
        this.runBuilder.setRunProperties(new RunPropertiesParser(runPropertiesElementContext).parse());
        RunProperty.RunStyleProperty runStyleProperty = this.runBuilder.getRunProperties().getRunStyleProperty();
        this.runBuilder.setRunStyle(null == runStyleProperty ? null : runStyleProperty.getValue());
    }

    private RunBuilder endRun(EndElement e) throws XMLStreamException {
        this.runBuilder.flushText();
        this.runBuilder.flushMarkupChunk();
        this.runBuilder.setEndEvent(e);
        if (!this.runBuilder.hasNonWhitespaceText() && this.runBuilder.getStartElementContext().getConditionalParameters().getCleanupAggressively()) {
            this.runBuilder.setRunProperties(RunProperties.copiedRunProperties(this.runBuilder.getRunProperties(), true, false, false));
        }
        return this.runBuilder;
    }

    private void processRunBody(XMLEvent e, XMLEventReader events) throws XMLStreamException {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            this.log("Nested block start event: " + e);
            this.runBuilder.flushText();
            StartElementContext blockElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.runBuilder.getStartElementContext());
            BlockParser nestedBlockParser = new BlockParser(blockElementContext, this.nestedTextualIds, this.runBuilder.getStyleDefinitions());
            Block nested = nestedBlockParser.parse();
            this.runBuilder.setContainsNestedItems(true);
            if (nested.hasVisibleRunContent()) {
                this.runBuilder.addToMarkupChunk(this.runBuilder.getStartElementContext().getEventFactory().createCharacters(TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
                this.runBuilder.getNestedTextualItems().add(nested);
            } else {
                for (XMLEvent nestedEvent : nested.getEvents()) {
                    this.runBuilder.addToMarkupChunk(nestedEvent);
                }
                for (Chunk chunk : nested.getChunks()) {
                    if (chunk instanceof Run) {
                        this.runBuilder.getNestedTextualItems().addAll(((Run)chunk).getNestedTextualItems());
                        continue;
                    }
                    if (!(chunk instanceof RunContainer)) continue;
                    for (Block.BlockChunk nestedChunk : ((RunContainer)chunk).getChunks()) {
                        if (!(nestedChunk instanceof Run)) continue;
                        this.runBuilder.getNestedTextualItems().addAll(((Run)nestedChunk).getNestedTextualItems());
                    }
                }
            }
        } else if (XMLEventHelpers.isComplexCodeStart(e)) {
            this.processComplexCodes(e, events);
        } else {
            this.runBuilder.addRunBody(this.processTranslatableAttributes(e), events);
        }
    }

    private void processComplexCodes(XMLEvent e, XMLEventReader events) throws XMLStreamException {
        boolean isFieldCodeValue = false;
        this.nestedComplexCodeProcessingStates.add(new ComplexCodeProcessingState());
        this.runBuilder.setHasComplexCodes(true);
        this.runBuilder.addToMarkupChunk(e);
        while (events.hasNext()) {
            e = (XMLEvent)events.next();
            if (this.nestedComplexCodeProcessingStates.peek().isAfterSeparate().booleanValue() && this.nestedComplexCodeProcessingStates.peek().containsPersistentContent().booleanValue() && !XMLEventHelpers.isComplexCodeEnd(e) && !XMLEventHelpers.isComplexCodeStart(e)) {
                this.runBuilder.addRunBody(this.processTranslatableAttributes(e), events);
                continue;
            }
            this.runBuilder.addToMarkupChunk(e);
            if (XMLEventHelpers.isComplexCodeStart(e)) {
                this.nestedComplexCodeProcessingStates.add(new ComplexCodeProcessingState());
                continue;
            }
            if (XMLEventHelpers.isComplexCodeSeparate(e)) {
                this.nestedComplexCodeProcessingStates.peekLast().setAfterSeparate(true);
                continue;
            }
            if (XMLEventHelpers.isComplexCodeEnd(e)) {
                this.nestedComplexCodeProcessingStates.pollLast();
                if (this.nestedComplexCodeProcessingStates.peekLast() != null) continue;
                break;
            }
            if (this.nestedComplexCodeProcessingStates.peek().isAfterSeparate().booleanValue()) continue;
            if (XMLEventHelpers.isFieldCodeStartEvent(e)) {
                isFieldCodeValue = true;
                continue;
            }
            if (isFieldCodeValue && this.isFieldCodeWithPersistentContent(e)) {
                this.nestedComplexCodeProcessingStates.peek().setContainsPersistentContent(true);
                continue;
            }
            if (!XMLEventHelpers.isFieldCodeEndEvent(e)) continue;
            isFieldCodeValue = false;
        }
    }

    private boolean isFieldCodeWithPersistentContent(XMLEvent e) {
        if (e.isCharacters()) {
            String data = e.asCharacters().getData().trim();
            int fieldCodeNameLength = data.indexOf(" ");
            String fieldCodeName = fieldCodeNameLength > 0 ? data.substring(0, fieldCodeNameLength) : data;
            return FIELD_DEFINITIONS_WITH_PERSISTENT_CONTENT.contains((Object)FieldDefinition.fromValue(fieldCodeName));
        }
        return false;
    }

    private XMLEvent processTranslatableAttributes(XMLEvent e) {
        if (!e.isStartElement()) {
            return e;
        }
        StartElement startEl = e.asStartElement();
        if (XMLEventHelpers.isGraphicsProperty(startEl) && !this.runBuilder.getStartElementContext().getConditionalParameters().getTranslateWordExcludeGraphicMetaData()) {
            startEl = this.processTranslatableAttribute(startEl, "name");
        } else if (XMLEventHelpers.isTextPath(startEl)) {
            startEl = this.processTranslatableAttribute(startEl, "string");
        }
        return startEl;
    }

    private StartElement processTranslatableAttribute(StartElement startEl, String attrName) {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = startEl.getAttributes();
        boolean dirty = false;
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.getName().getLocalPart().equals(attrName)) {
                this.runBuilder.setContainsNestedItems(true);
                this.runBuilder.getNestedTextualItems().add(new UnstyledText(a.getValue()));
                newAttrs.add(this.runBuilder.getStartElementContext().getEventFactory().createAttribute(a.getName(), TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
                dirty = true;
                continue;
            }
            newAttrs.add(a);
        }
        return dirty ? this.runBuilder.getStartElementContext().getEventFactory().createStartElement(startEl.getName(), newAttrs.iterator(), startEl.getNamespaces()) : startEl;
    }

    private void log(String s) {
        LOGGER.debug(s);
    }

    private static enum FieldDefinition {
        UNSUPPORTED(""),
        HYPERLINK("HYPERLINK");

        String value;

        private FieldDefinition(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }

        static FieldDefinition fromValue(String value) {
            if (null == value) {
                return UNSUPPORTED;
            }
            for (FieldDefinition fieldDefinition : FieldDefinition.values()) {
                if (!fieldDefinition.getValue().equals(value)) continue;
                return fieldDefinition;
            }
            return UNSUPPORTED;
        }
    }

    private class ComplexCodeProcessingState {
        private Boolean containsPersistentContent = false;
        private Boolean afterSeparate = false;

        private ComplexCodeProcessingState() {
        }

        Boolean containsPersistentContent() {
            return this.containsPersistentContent;
        }

        void setContainsPersistentContent(Boolean containsPersistentContent) {
            this.containsPersistentContent = containsPersistentContent;
        }

        Boolean isAfterSeparate() {
            return this.afterSeparate;
        }

        void setAfterSeparate(Boolean afterSeparate) {
            this.afterSeparate = afterSeparate;
        }
    }
}

