/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunPropertiesParser
implements Parser<RunProperties> {
    protected StartElementContext startElementContext;
    private EndElement runPropsEndElement;
    private List<RunProperty> runProperties = new ArrayList<RunProperty>();
    private ElementSkipper generalElementSkipper;

    RunPropertiesParser(StartElementContext startElementContext) {
        this.startElementContext = StartElementContextFactory.createStartElementContext(AttributeStripper.GeneralAttributeStripper.stripGeneralAttributes(StartElementContextFactory.createStartElementContext(AttributeStripper.RevisionAttributeStripper.stripRunRevisionAttributes(startElementContext), startElementContext)), startElementContext);
        this.generalElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTIES_CHANGE, ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_LANGUAGE, ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_NO_SPELLING_OR_GRAMMAR);
    }

    @Override
    public RunProperties parse() throws XMLStreamException {
        if (Namespaces.DrawingML.containsName(this.startElementContext.getStartElement().getName())) {
            Iterator<Attribute> attrs = this.startElementContext.getStartElement().getAttributes();
            while (attrs.hasNext()) {
                this.runProperties.add(RunPropertyFactory.createRunProperty(attrs.next()));
            }
        }
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isEndElement(e, this.startElementContext.getStartElement())) {
                this.endRunProperties(e.asEndElement());
                return this.buildRunProperties();
            }
            if (e.isStartElement()) {
                if (this.generalElementSkipper.canBeSkipped(e.asStartElement())) {
                    this.generalElementSkipper.skipElement(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
                    continue;
                }
                this.addRunProperty(e.asStartElement());
                continue;
            }
            if (!e.isCharacters() || XMLEventHelpers.isWhitespace(e)) continue;
            throw new IllegalStateException("Discarding non-whitespace rPr characters " + e.asCharacters().getData());
        }
        throw new IllegalStateException("Invalid content? Unterminated run properties");
    }

    private void addRunProperty(StartElement startElement) throws XMLStreamException {
        StartElementContext runPropertiesElementContext = StartElementContextFactory.createStartElementContext(startElement, this.startElementContext);
        this.runProperties.add(RunPropertyFactory.createRunProperty(runPropertiesElementContext));
    }

    private void endRunProperties(EndElement e) {
        this.runPropsEndElement = e;
    }

    private RunProperties buildRunProperties() {
        StartElement startElement = this.startElementContext.getStartElement();
        if (startElement == null) {
            return RunProperties.emptyRunProperties();
        }
        if (this.runPropsEndElement == null) {
            throw new IllegalStateException("Incomplete run property markup: " + startElement.getName());
        }
        return new RunProperties.DefaultRunProperties(startElement, this.runPropsEndElement, this.runProperties);
    }
}

