/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsDenormalizer;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemParser;
import net.sf.okapi.filters.openxml.StringItemTextUnitMapper;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class SharedStringsPartHandler
extends GenericPartHandler {
    private SharedStringMap sharedStringMap;
    private XMLEventFactory eventFactory;
    private StyleDefinitions styleDefinitions;
    private IdGenerator textUnitId;
    private IdGenerator nestedBlockId;
    private XMLEventReader xmlReader;
    private Iterator<Event> filterEventIterator;
    private String docId;
    private String subDocId;
    private File rewrittenStringsTable;
    private int sharedStringIndex = 0;

    SharedStringsPartHandler(ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, StyleDefinitions styleDefinitions, SharedStringMap sharedStringMap) {
        this(cparams, zipFile.getEventFactory(), entry.getName(), styleDefinitions);
        this.zipFile = zipFile;
        this.entry = entry;
        this.sharedStringMap = sharedStringMap;
    }

    SharedStringsPartHandler(ConditionalParameters cparams, XMLEventFactory eventFactory, String partName, StyleDefinitions styleDefinitions) {
        super(cparams);
        this.eventFactory = eventFactory;
        this.partName = partName;
        this.styleDefinitions = styleDefinitions;
        this.documentPartIdGenerator = new IdGenerator(partName, "dp");
        this.textUnitId = new IdGenerator(partName, "tu");
        this.nestedBlockId = new IdGenerator(null);
        this.markup = new Block.BlockMarkup();
    }

    @Override
    public Event open(String docId, String subDocId, LocaleId srcLang) throws IOException, XMLStreamException {
        this.docId = docId;
        this.subDocId = subDocId;
        this.xmlReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        return this.open(docId, subDocId, this.xmlReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event open(String docId, String subDocId, XMLEventReader xmlReader) throws XMLStreamException, IOException {
        SharedStringsDenormalizer deno = new SharedStringsDenormalizer(this.zipFile.getEventFactory(), this.sharedStringMap);
        XMLEventReader reader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8));
        this.rewrittenStringsTable = File.createTempFile("sharedStrings", ".xml");
        XMLEventWriter writer = this.zipFile.getOutputFactory().createXMLEventWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rewrittenStringsTable), StandardCharsets.UTF_8));
        deno.process(reader, writer);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.rewrittenStringsTable));
        this.xmlReader = XMLInputFactory.newInstance().createXMLEventReader(is);
        try {
            this.process();
        }
        finally {
            if (xmlReader != null) {
                xmlReader.close();
            }
        }
        return this.createStartSubDocumentEvent(docId, subDocId);
    }

    private void process() throws XMLStreamException {
        XMLEvent e = null;
        while (this.xmlReader.hasNext()) {
            e = this.xmlReader.nextEvent();
            if (XMLEventHelpers.isStringItemStartEvent(e) && this.sharedStringMap.isStringVisible(this.sharedStringIndex++)) {
                this.flushDocumentPart();
                StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.xmlReader, this.eventFactory, this.params);
                StringItem stringItem = new StringItemParser(startElementContext, this.nestedBlockId, this.styleDefinitions).parse();
                StringItemTextUnitMapper mapper = new StringItemTextUnitMapper(stringItem, this.textUnitId);
                if (mapper.getTextUnits().isEmpty()) {
                    this.addBlockChunksToDocumentPart(stringItem.getChunks());
                    continue;
                }
                for (ITextUnit tu : mapper.getTextUnits()) {
                    this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
                }
                continue;
            }
            this.addEventToDocumentPart(e);
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void addMarkupComponentToDocumentPart(MarkupComponent markupComponent) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        this.markup.addComponent(markupComponent);
    }

    private void addBlockChunksToDocumentPart(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk instanceof Markup) {
                for (MarkupComponent markupComponent : ((Markup)chunk).getComponents()) {
                    this.addMarkupComponentToDocumentPart(markupComponent);
                }
                continue;
            }
            this.documentPartEvents.addAll(chunk.getEvents());
        }
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

