/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.layerprovider.ILayerProvider;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openxml.BidirectionalityClarifier;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.BlockTextUnitWriter;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemSkeleton;
import net.sf.okapi.filters.openxml.StringItemTextUnitWriter;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

public class StyledTextSkeletonWriter
implements ISkeletonWriter {
    private XMLEventFactory eventFactory;
    private LocaleId targetLocale;
    private IdGenerator nestedBlockIds = new IdGenerator(null);
    private Map<String, String> processedReferents = new HashMap<String, String>();
    private String partName;

    public StyledTextSkeletonWriter(XMLEventFactory eventFactory, String partName) {
        this.eventFactory = eventFactory;
        this.partName = partName;
    }

    void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public void close() {
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        this.targetLocale = outputLocale;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    @Override
    public String processEndDocument(Ending resource) {
        return "";
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    @Override
    public String processEndSubDocument(Ending resource) {
        return "";
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        return "";
    }

    @Override
    public String processEndGroup(Ending resource) {
        return "";
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        TextContainer target = this.getTargetForOutput(tu);
        String serialized = null;
        List<Chunk> chunks = null;
        if (tu.getSkeleton() != null) {
            XMLEventSerializer xmlWriter = new XMLEventSerializer();
            if (tu.getSkeleton() instanceof BlockSkeleton) {
                BlockSkeleton skel = (BlockSkeleton)tu.getSkeleton();
                Block block = skel.getBlock();
                Map<Integer, XMLEvents> codeMap = skel.getCodeMap();
                chunks = block.getChunks();
                Nameable nameableMarkupComponent = ((Markup)chunks.get(0)).getNameableMarkupComponent();
                BidirectionalityClarifier bidirectionalityClarifier = new BidirectionalityClarifier(new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI()), new ClarificationParameters(LocaleId.isBidirectional(this.targetLocale), LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale), this.targetLocale.toString()));
                bidirectionalityClarifier.clarifyMarkup((Markup)chunks.get(0));
                xmlWriter.add(chunks.get(0));
                new BlockTextUnitWriter(this.eventFactory, block.getRunName(), block.getTextName(), codeMap, xmlWriter, bidirectionalityClarifier).write(target);
            } else if (tu.getSkeleton() instanceof StringItemSkeleton) {
                StringItemSkeleton skel = (StringItemSkeleton)tu.getSkeleton();
                StringItem stringItem = skel.getStringItem();
                chunks = stringItem.getChunks();
                xmlWriter.add(chunks.get(0));
                new StringItemTextUnitWriter(this.eventFactory, stringItem, xmlWriter).write(target);
            } else {
                throw new IllegalArgumentException("TextUnit " + tu.getId() + " has no associated block content");
            }
            xmlWriter.add(chunks.get(chunks.size() - 1));
            serialized = xmlWriter.toString();
        } else {
            serialized = target.toString();
        }
        if (tu.isReferent()) {
            this.processedReferents.put(this.nestedBlockIds.createId(), serialized);
            return "";
        }
        if (!this.processedReferents.isEmpty()) {
            serialized = this.resolveReferences(serialized);
        }
        return serialized;
    }

    private String resolveReferences(String original) {
        StringBuilder sb = new StringBuilder(original);
        Object[] markerInfo = TextFragment.getRefMarker(sb);
        while (markerInfo != null) {
            String processedReferent = this.processedReferents.get(markerInfo[0]);
            sb.replace((Integer)markerInfo[1], (Integer)markerInfo[2], processedReferent);
            markerInfo = TextFragment.getRefMarker(sb);
        }
        return sb.toString();
    }

    private TextContainer getTargetForOutput(ITextUnit tu) {
        if (this.targetLocale == null) {
            return tu.getSource();
        }
        TextContainer trgCont = tu.getTarget(this.targetLocale);
        if (trgCont == null || trgCont.isEmpty()) {
            return tu.getSource();
        }
        return trgCont;
    }

    @Override
    public String processDocumentPart(DocumentPart documentPart) {
        MarkupSkeleton markupSkeleton = (MarkupSkeleton)documentPart.getSkeleton();
        Markup markup = markupSkeleton.getMarkup();
        Nameable nameableMarkupComponent = markup.getNameableMarkupComponent();
        if (null != nameableMarkupComponent) {
            BidirectionalityClarifier bidirectionalityClarifier = new BidirectionalityClarifier(new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI()), new ClarificationParameters(LocaleId.isBidirectional(this.targetLocale), LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale), this.targetLocale.toString()));
            bidirectionalityClarifier.clarifyMarkup(markup);
        }
        return XMLEventSerializer.serialize(markup);
    }

    @Override
    public String processStartSubfilter(StartSubfilter resource) {
        return "";
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        return "";
    }
}

