/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class PropertyBean
extends PersistenceBean<Property> {
    private String name;
    private String value;
    private boolean isReadOnly;
    private AnnotationsBean annotations = new AnnotationsBean();

    @Override
    protected Property createObject(IPersistenceSession session) {
        return new Property(this.name, this.value, this.isReadOnly);
    }

    @Override
    protected void fromObject(Property obj, IPersistenceSession session) {
        this.name = obj.getName();
        this.value = obj.getValue();
        this.isReadOnly = obj.isReadOnly();
        this.annotations.set(obj.getAnnotations(), session);
    }

    @Override
    protected void setObject(Property obj, IPersistenceSession session) {
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }
}

