/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

class SimpleStore {
    private static int MAXBLOCKLEN = 40000;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;

    SimpleStore() {
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
                this.dis = null;
            }
            if (this.dos != null) {
                this.dos.close();
                this.dos = null;
            }
        }
        catch (IOException e) {
            throw new OkapiException("Error closing.", e);
        }
    }

    public void create(File file) {
        try {
            this.close();
            this.dos = new DataOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new OkapiException("Error creating.", e);
        }
    }

    public void openForRead(File file) {
        try {
            this.close();
            this.dis = new DataInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new OkapiException("Error opening.", e);
        }
    }

    public void write(TextFragment tf) {
        try {
            this.writeLongString(tf.getCodedText());
            this.writeLongString(Code.codesToString(tf.getCodes()));
        }
        catch (IOException e) {
            throw new OkapiException("Error while writing.", e);
        }
    }

    public TextFragment readNext() {
        try {
            String codedText = this.readLongString();
            String tmp = this.readLongString();
            TextFragment tf = new TextFragment(codedText, Code.stringToCodes(tmp));
            return tf;
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            throw new OkapiException("Error while reading.", e);
        }
    }

    private void writeLongString(String data) throws IOException {
        int r = data.length() % MAXBLOCKLEN;
        int n = data.length() / MAXBLOCKLEN;
        int count = n + (r > 0 ? 1 : 0);
        this.dos.writeInt(count);
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            this.dos.writeUTF(data.substring(pos, pos + MAXBLOCKLEN));
            pos += MAXBLOCKLEN;
        }
        if (r > 0) {
            this.dos.writeUTF(data.substring(pos));
        }
    }

    private String readLongString() throws IOException {
        int count = this.dis.readInt();
        if (count == 0) {
            return "";
        }
        if (count == 1) {
            return this.dis.readUTF();
        }
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            tmp.append(this.dis.readUTF());
        }
        return tmp.toString();
    }
}

