/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Field;

public enum MetadataType {
    ID("tuid"),
    TYPE("datatype"),
    GROUP_NAME("Txt::GroupName"),
    FILE_NAME("Txt::FileName");

    private String fieldName;
    private static Map<String, MetadataType> mapping;

    private MetadataType(String fieldName) {
        this.fieldName = fieldName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Field.Store store() {
        return Field.Store.YES;
    }

    public Field.Index indexType() {
        return Field.Index.NOT_ANALYZED;
    }

    public static MetadataType findMetadataType(String keyword) {
        return mapping.get(keyword);
    }

    static {
        mapping = new HashMap<String, MetadataType>(){
            private static final long serialVersionUID = 2838020991609251445L;
            {
                this.put("Txt::GroupName", GROUP_NAME);
                this.put("Txt::FileName", FILE_NAME);
                this.put("datatype", TYPE);
                this.put("tuid", ID);
            }
        };
    }
}

