/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;

public class DefaultEncoder
implements IEncoder {
    private String lineBreak;

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.lineBreak = lineBreak;
    }

    @Override
    public String encode(String text, EncoderContext context) {
        return text.replace("\n", this.lineBreak);
    }

    @Override
    public String encode(char value, EncoderContext context) {
        return String.valueOf(value).replace("\n", this.lineBreak);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return new String(Character.toChars(value)).replace("\n", this.lineBreak);
        }
        return String.valueOf((char)value).replace("\n", this.lineBreak);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public String getEncoding() {
        return "";
    }
}

