/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ReversedIterator;
import net.sf.okapi.common.exceptions.OkapiMisAlignmentException;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class AlignedSegments
implements IAlignedSegments {
    private ITextUnit parent;

    public AlignedSegments(ITextUnit parent) {
        this.parent = parent;
    }

    @Override
    public void append(Segment srcSeg, Segment trgSeg, LocaleId trgLoc) {
        if (srcSeg == null && trgSeg == null) {
            throw new IllegalArgumentException("srcSeg and trgSeg cannot both be null");
        }
        this.insertOrAppend(true, -1, srcSeg, trgSeg, trgLoc);
    }

    @Override
    public void insert(int index, Segment srcSeg, Segment trgSeg, LocaleId trgLoc) {
        if (srcSeg == null) {
            throw new IllegalArgumentException("srcSeg cannot be null");
        }
        this.insertOrAppend(false, index, srcSeg, trgSeg, trgLoc);
    }

    private void insertOrAppend(boolean append, int index, Segment srcSeg, Segment trgSeg, LocaleId trgLoc) {
        Segment sourceSeg = srcSeg != null ? srcSeg : new Segment(null, new TextFragment(""));
        Segment targetSeg = trgSeg != null ? trgSeg : new Segment(null, new TextFragment(""));
        String originalId = null;
        String insertedId = null;
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (append) {
            targetSeg.id = sourceSeg.id;
            if (ci.hasSource()) {
                ci.getSource().getSegments().append(sourceSeg);
            }
            if (ci.hasTarget()) {
                ci.getTarget().getSegments().append(targetSeg);
            }
        } else {
            originalId = this.getSource((LocaleId)trgLoc).getSegments().get((int)index).id;
            if (ci.hasSource()) {
                insertedId = this.doInsert(ci.getSource(), index, null, null, sourceSeg);
            }
            if (ci.hasTarget()) {
                insertedId = this.doInsert(ci.getTarget(), index, originalId, insertedId, targetSeg);
            }
        }
    }

    private String doInsert(TextContainer container, int index, String originalId, String insertedId, Segment seg) {
        ISegments segs = container.getSegments();
        if (originalId == null) {
            segs.insert(index, seg);
            return seg.id;
        }
        Segment currentSeg = segs.get(originalId);
        if (currentSeg != null) {
            segs.insert(segs.getIndex(originalId), seg);
            if (insertedId != null) {
                seg.id = insertedId;
            }
            return seg.id;
        }
        segs.append(seg);
        return insertedId;
    }

    @Override
    public void setSegment(int index, Segment seg, LocaleId trgLoc) {
        ISegments segs = this.getSource(trgLoc).getSegments();
        String newId = seg.id;
        String oldId = segs.get((int)index).id;
        boolean idChanged = !newId.equals(oldId);
        int theIndex = index;
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (ci.hasSource()) {
            ci.getSource().getSegments().set(theIndex, seg.clone());
        }
        if (ci.hasTarget()) {
            segs = ci.getTarget().getSegments();
            segs.set(segs.getIndex(oldId), seg.clone());
        }
        if (idChanged) {
            Segment tempSeg;
            ci = new ContainerIterator(trgLoc);
            if (ci.hasSource() && (tempSeg = ci.getSource().getSegments().get(oldId)) != null) {
                tempSeg.id = newId;
            }
            if (ci.hasTarget() && (tempSeg = ci.getTarget().getSegments().get(oldId)) != null) {
                tempSeg.id = newId;
            }
        }
    }

    @Override
    public boolean remove(Segment seg, LocaleId trgLoc) {
        int count = 0;
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (ci.hasSource()) {
            count += this.removeSegment(ci.getSource(), seg.id);
        }
        if (ci.hasTarget()) {
            count += this.removeSegment(ci.getTarget(), seg.id);
        }
        return count > 0;
    }

    private int removeSegment(TextContainer container, String segId) {
        ISegments segs = container.getSegments();
        int segIndex = segs.getIndex(segId);
        if (segIndex > -1) {
            container.remove(segs.getPartIndex(segIndex));
            return 1;
        }
        return 0;
    }

    @Override
    public Segment getSource(int index, LocaleId trgLoc) {
        return this.getSource(trgLoc).getSegments().get(index);
    }

    @Override
    public Segment getCorrespondingTarget(Segment srcSeg, LocaleId trgLoc) {
        ISegments trgSegs = this.parent.getTargetSegments(trgLoc);
        return trgSegs.get(srcSeg.id);
    }

    @Override
    public Segment getCorrespondingSource(Segment trgSeg, LocaleId trgLoc) {
        ISegments srcSegs = this.getSource(trgLoc).getSegments();
        return srcSegs.get(trgSeg.id);
    }

    @Override
    public void align(List<AlignedPair> alignedSegmentPairs, LocaleId trgLoc) {
        this.parent.createTarget(trgLoc, false, 7);
        TextContainer src = this.getSource(trgLoc);
        TextContainer trg = this.parent.getTarget(trgLoc);
        src.clear();
        trg.clear();
        for (AlignedPair alignedPair : alignedSegmentPairs) {
            String srcSegId = this.appendPartsToContainer(alignedPair.getSourceParts(), src, null);
            this.appendPartsToContainer(alignedPair.getTargetParts(), trg, srcSegId);
        }
        src.setHasBeenSegmentedFlag(true);
        trg.setHasBeenSegmentedFlag(true);
        trg.getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    private String appendPartsToContainer(List<TextPart> parts, TextContainer container, String segId) {
        TextPart part;
        LinkedList<TextPart> partsCopy = new LinkedList<TextPart>(parts);
        int beforeIndex = 0;
        int afterIndex = partsCopy.size();
        Iterator i$ = partsCopy.iterator();
        while (i$.hasNext() && !(part = (TextPart)i$.next()).isSegment()) {
            ++beforeIndex;
        }
        ReversedIterator<TextPart> ri = new ReversedIterator<TextPart>(partsCopy);
        for (TextPart part2 : ri) {
            if (part2.isSegment()) break;
            --afterIndex;
        }
        for (TextPart part2 : partsCopy.subList(0, beforeIndex)) {
            container.append(part2);
        }
        TextFragment frag = new TextFragment();
        for (TextPart part3 : partsCopy.subList(beforeIndex, afterIndex)) {
            frag.append(part3.getContent());
        }
        Segment seg = new Segment(segId, frag);
        container.getSegments().append(seg);
        for (TextPart part4 : partsCopy.subList(afterIndex, partsCopy.size())) {
            container.append(part4);
        }
        return seg.getId();
    }

    @Override
    public void align(LocaleId trgLoc) {
        Iterator<Segment> srcSegsIt = this.getSource(trgLoc).getSegments().iterator();
        Iterator<Segment> trgSegsIt = this.parent.createTarget(trgLoc, false, 4).getSegments().iterator();
        while (srcSegsIt.hasNext()) {
            try {
                Segment srcSeg = srcSegsIt.next();
                Segment trgSeg = trgSegsIt.next();
                trgSeg.id = srcSeg.id;
            }
            catch (NoSuchElementException e) {
                throw new OkapiMisAlignmentException("Different number of source and target segments", e);
            }
        }
        this.parent.getTargetSegments(trgLoc).setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    @Override
    public void alignCollapseAll(LocaleId trgLoc) {
        ContainerIterator ci = new ContainerIterator(trgLoc);
        LinkedList<TextContainer> collapsed = new LinkedList<TextContainer>();
        if (ci.hasSource()) {
            ci.getSource().joinAll();
            ci.getSource().setHasBeenSegmentedFlag(false);
            collapsed.add(ci.getSource());
        }
        if (ci.hasTarget()) {
            ci.getTarget().joinAll();
            ci.getTarget().setHasBeenSegmentedFlag(false);
            collapsed.add(ci.getTarget());
        }
        for (LocaleId loc : this.parent.getTargetLocales()) {
            TextContainer trg;
            TextContainer src = this.getSource(loc);
            if (!collapsed.contains(src) || !collapsed.contains(trg = this.parent.getTarget(loc))) continue;
            trg.getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
            trg.getFirstSegment().id = src.getFirstSegment().getId();
        }
    }

    @Override
    public Segment splitSource(LocaleId trgLoc, Segment srcSeg, int splitPos) {
        ISegments currentSegs;
        Segment currentSeg;
        TextContainer theSource = this.getSource(trgLoc);
        ISegments srcSegs = theSource.getSegments();
        int segIndex = srcSegs.getIndex(srcSeg.id);
        if (segIndex == -1) {
            return null;
        }
        int partIndex = srcSegs.getPartIndex(segIndex);
        theSource.split(partIndex, splitPos, splitPos, false);
        Segment newSeg = srcSegs.get(segIndex + 1);
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (ci.hasTarget() && (currentSeg = (currentSegs = ci.getTarget().getSegments()).get(srcSeg.id)) != null) {
            currentSegs.insert(currentSegs.getIndex(srcSeg.id) + 1, new Segment(srcSeg.id, new TextFragment("")));
        }
        return newSeg;
    }

    @Override
    public Segment splitTarget(LocaleId trgLoc, Segment trgSeg, int splitPos) {
        ISegments currentSegs;
        Segment currentSeg;
        TextContainer theTarget = this.parent.createTarget(trgLoc, false, 4);
        ISegments trgSegs = theTarget.getSegments();
        int segIndex = trgSegs.getIndex(trgSeg.id);
        if (segIndex == -1) {
            return null;
        }
        int partIndex = trgSegs.getPartIndex(segIndex);
        theTarget.split(partIndex, splitPos, splitPos, false);
        Segment newSeg = trgSegs.get(segIndex + 1);
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (ci.hasSource() && (currentSeg = (currentSegs = ci.getSource().getSegments()).get(trgSeg.id)) != null) {
            currentSegs.insert(currentSegs.getIndex(trgSeg.id) + 1, new Segment(trgSeg.id, new TextFragment("")));
        }
        return newSeg;
    }

    @Override
    public void joinWithNext(Segment seg, LocaleId trgLoc) {
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (ci.hasSource()) {
            this.doJoinWithNext(ci.getSource(), seg.id);
        }
        if (ci.hasTarget()) {
            this.doJoinWithNext(ci.getTarget(), seg.id);
        }
    }

    private void doJoinWithNext(TextContainer cont, String segId) {
        ISegments segs = cont.getSegments();
        int segIndex = segs.getIndex(segId);
        if (segIndex != -1) {
            segs.joinWithNext(segIndex);
        }
    }

    @Override
    public void joinAll(LocaleId trgLoc) {
        ContainerIterator ci = new ContainerIterator(trgLoc);
        if (ci.hasSource()) {
            ci.getSource().joinAll();
        }
        if (ci.hasTarget()) {
            ci.getTarget().joinAll();
        }
    }

    @Override
    public AlignmentStatus getAlignmentStatus() {
        for (LocaleId loc : this.parent.getTargetLocales()) {
            ISegments trgSegs = this.parent.getTargetSegments(loc);
            if (trgSegs.getAlignmentStatus() != AlignmentStatus.NOT_ALIGNED) continue;
            return AlignmentStatus.NOT_ALIGNED;
        }
        return AlignmentStatus.ALIGNED;
    }

    @Override
    public AlignmentStatus getAlignmentStatus(LocaleId trgLoc) {
        return this.parent.getTargetSegments(trgLoc).getAlignmentStatus();
    }

    @Override
    public void segmentSource(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer theSource = this.getSource(targetLocale);
        segmenter.computeSegments(theSource);
        theSource.getSegments().create(segmenter.getRanges());
    }

    @Override
    public void segmentTarget(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer theTarget = this.parent.createTarget(targetLocale, false, 4);
        segmenter.computeSegments(theTarget);
        theTarget.getSegments().create(segmenter.getRanges());
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.parent.getSource().getSegments().iterator();
    }

    @Override
    public Iterator<Segment> iterator(LocaleId trgLoc) {
        return this.getSource(trgLoc).getSegments().iterator();
    }

    private TextContainer getSource(LocaleId loc) {
        return this.parent.getSource();
    }

    public final ITextUnit getParent() {
        return this.parent;
    }

    private class ContainerIterator {
        private TextContainer theSource = null;
        private TextContainer theTarget = null;

        public ContainerIterator(LocaleId trgLoc) {
            this.theSource = AlignedSegments.this.getSource(trgLoc);
            this.theTarget = AlignedSegments.this.parent.getTarget(trgLoc);
        }

        public boolean hasSource() {
            return this.theSource != null;
        }

        public TextContainer getSource() {
            if (this.theSource == null) {
                throw new IllegalStateException("this method can only be called after hasSource() returns true");
            }
            return this.theSource;
        }

        public boolean hasTarget() {
            return this.theTarget != null;
        }

        public TextContainer getTarget() {
            if (this.theTarget == null) {
                throw new IllegalStateException("this method can only be called after hasTarget() returns true");
            }
            return this.theTarget;
        }
    }
}

