/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class IDMLPreserveWhitespaceUtil {
    public static final String WHITESPACE_CHARS = "\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2002\\u2003\\u2029\\u205F\\u3000";

    public static void updateTu(ITextUnit tu) {
        if (tu == null) {
            return;
        }
        TextContainer source = tu.getSource();
        if (source == null) {
            return;
        }
        TextFragment firstContent = source.getFirstContent();
        if (firstContent == null) {
            return;
        }
        boolean hasWhitespaces = firstContent.getText().matches(".*[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2002\\u2003\\u2029\\u205F\\u3000].*");
        tu.setPreserveWhitespaces(tu.preserveWhitespaces() || hasWhitespaces);
    }
}

