/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.google.GoogleMTv2Connector;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.lib.verification.Issue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageToolConnector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArrayList<Issue> issues = new ArrayList();
    private String lang;
    private String motherTongue;
    private String serverUrl;
    private IQuery mt;
    private boolean bilingualMode;
    private JSONParser jsonParser = new JSONParser();

    public void initialize(LocaleId locId, LocaleId motherLocId, String serverUrl, boolean translateLTMsg, boolean bilingualMode, String ltTranslationSource, String ltTranslationTarget, String ltTranslationServiceKey) {
        this.lang = locId.getLanguage();
        this.motherTongue = motherLocId.getLanguage();
        if (!serverUrl.endsWith("/")) {
            serverUrl = serverUrl + "/";
        }
        this.serverUrl = serverUrl;
        if (this.mt != null) {
            this.mt.close();
            this.mt = null;
        }
        this.bilingualMode = bilingualMode;
        if (translateLTMsg) {
            this.mt = new GoogleMTv2Connector();
            GoogleMTv2Parameters prm = (GoogleMTv2Parameters)this.mt.getParameters();
            prm.setApiKey(ltTranslationServiceKey);
            this.mt.setLanguages(LocaleId.fromBCP47(ltTranslationSource), LocaleId.fromBCP47(ltTranslationTarget));
            this.mt.open();
        }
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    protected JSONObject sendRequest(URL url) throws UnsupportedEncodingException, IOException, ParseException {
        URLConnection conn = url.openConnection();
        return (JSONObject)this.jsonParser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
    }

    public int checkSegment(URI docId, String subDocId, Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        this.issues.clear();
        if (!trgSeg.text.hasText()) {
            return 0;
        }
        String ctext = trgSeg.text.getCodedText();
        try {
            URL url = this.bilingualMode ? new URL(this.serverUrl + String.format("v2/check?language=%s&text=%s&srctext=%s&motherTongue=%s", this.lang, URLEncoder.encode(ctext, "UTF-8"), URLEncoder.encode(srcSeg.text.getCodedText(), "UTF-8"), this.motherTongue)) : new URL(this.serverUrl + String.format("v2/check?language=%s&text=%s", this.lang, URLEncoder.encode(ctext, "UTF-8")));
            JSONObject object = this.sendRequest(url);
            JSONArray matches = (JSONArray)object.get("matches");
            for (Object match : matches) {
                JSONObject error = (JSONObject)match;
                String msg = (String)error.get("message");
                if (this.mt != null && this.mt.query(msg) > 0) {
                    msg = String.format("%s  (--> %s)", msg, this.mt.next().target.toText());
                }
                Long start = (Long)error.get("offset");
                Long end = start + (Long)error.get("length");
                Issue issue = new Issue(docId, subDocId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), msg, 0, 0, TextFragment.fromFragmentToString(trgSeg.text, start.intValue()), TextFragment.fromFragmentToString(trgSeg.text, end.intValue()), 1.0, tu.getName());
                this.issues.add(issue);
                JSONObject rule = (JSONObject)error.get("rule");
                String itsType = (String)rule.get("issueType");
                if (itsType == null) continue;
                issue.setString("lqiType", itsType);
            }
        }
        catch (Throwable e) {
            this.issues.add(new Issue(docId, subDocId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), "Error with LanguageTool server. All LT checks are skipped from this text unit on. " + e.getMessage(), 0, -99, 0, -1, 2.0, tu.getName()));
        }
        return this.issues.size();
    }
}

