/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.translation;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.genericeditor.GenericEditor;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.lib.ui.translation.ConnectorInfo;
import net.sf.okapi.lib.ui.translation.IConnectorList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ConnectorSelectionPanel
extends Composite {
    private Label stConnectors;
    private Combo cbConnectors;
    private Button btOptions;
    private Text edSettings;
    private List<ConnectorInfo> infoList;
    private ArrayList<String> paramsList;
    private ArrayList<String> displayList;
    private GenericEditor gedit;
    private IContext context;
    private IQuery currentConnector;
    private IParameters currentParams;

    public ConnectorSelectionPanel(Composite p_Parent, int flags, IConnectorList connectors, IContext context, String caption) {
        super(p_Parent, 0);
        this.context = context;
        this.infoList = connectors.getList();
        this.paramsList = new ArrayList();
        this.displayList = new ArrayList();
        for (int i = 0; i < this.infoList.size(); ++i) {
            this.paramsList.add(null);
            this.displayList.add(null);
        }
        this.createContent(caption);
    }

    private void createContent(String caption) {
        GridData gdTmp;
        GridLayout layTmp = new GridLayout(2, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout(layTmp);
        if (caption != null) {
            this.stConnectors = new Label(this, 0);
            this.stConnectors.setText(caption);
            gdTmp = new GridData();
            gdTmp.horizontalSpan = 2;
            this.stConnectors.setLayoutData(gdTmp);
        }
        this.cbConnectors = new Combo(this, 12);
        this.cbConnectors.setVisibleItemCount(10);
        this.cbConnectors.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ConnectorSelectionPanel.this.updateConnector();
            }
        });
        this.cbConnectors.setLayoutData(new GridData(768));
        for (ConnectorInfo ci : this.infoList) {
            this.cbConnectors.add(ci.description);
        }
        this.btOptions = new Button(this, 8);
        this.btOptions.setText("&Settings...");
        this.btOptions.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ConnectorSelectionPanel.this.editParameters();
            }
        });
        UIUtil.ensureWidth(this.btOptions, 80);
        this.edSettings = new Text(this, 2562);
        this.edSettings.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        gdTmp.heightHint = 32;
        this.edSettings.setLayoutData(gdTmp);
    }

    private void instantiateConnector(int index) {
        try {
            this.currentConnector = this.infoList.get((int)index).classLoader == null ? (IQuery)Class.forName(this.infoList.get((int)index).connectorClass).newInstance() : (IQuery)Class.forName(this.infoList.get((int)index).connectorClass, true, this.infoList.get((int)index).classLoader).newInstance();
            this.currentParams = this.currentConnector.getParameters();
            if (!Util.isEmpty((String)this.paramsList.get(index))) {
                this.currentParams.fromString(this.paramsList.get(index));
            }
        }
        catch (InstantiationException e) {
            throw new OkapiException("Error creating the connector. " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiException("Error creating the connector. " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException("Error creating the connector. " + e.getMessage(), (Throwable)e);
        }
    }

    private void updateConnector() {
        int n = this.cbConnectors.getSelectionIndex();
        if (n == -1) {
            this.btOptions.setEnabled(false);
            this.edSettings.setText("");
            return;
        }
        this.btOptions.setEnabled(this.infoList.get((int)n).descriptionProviderClass != null);
        if (this.displayList.get(n) == null) {
            this.instantiateConnector(n);
            String tmp = this.currentConnector.getSettingsDisplay();
            this.displayList.set(n, tmp == null ? "" : tmp);
        }
        this.edSettings.setText(this.displayList.get(n));
    }

    private void editParameters() {
        try {
            int n = this.cbConnectors.getSelectionIndex();
            if (n == -1) {
                return;
            }
            ConnectorInfo ci = this.infoList.get(n);
            if (ci.descriptionProviderClass != null) {
                IEditorDescriptionProvider descProv = null;
                descProv = ci.classLoader == null ? (IEditorDescriptionProvider)Class.forName(ci.descriptionProviderClass).newInstance() : (IEditorDescriptionProvider)Class.forName(ci.descriptionProviderClass, true, ci.classLoader).newInstance();
                this.instantiateConnector(n);
                if (this.gedit == null) {
                    this.gedit = new GenericEditor();
                }
                if (!this.gedit.edit(this.currentParams, descProv, false, this.context)) {
                    return;
                }
                this.paramsList.set(n, this.currentParams.toString());
                this.displayList.set(n, this.currentConnector.getSettingsDisplay());
                this.updateConnector();
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getMessage(), null);
        }
    }

    public void setData(String connectorClass, String paramsData) {
        int n = -1;
        boolean found = false;
        if (!Util.isEmpty((String)connectorClass)) {
            for (ConnectorInfo ci : this.infoList) {
                ++n;
                if (!ci.connectorClass.equals(connectorClass)) continue;
                found = true;
                this.paramsList.set(n, paramsData);
                break;
            }
        }
        if (!found) {
            n = 0;
        }
        this.cbConnectors.select(n);
        this.updateConnector();
    }

    public String getConnectorClass() {
        int n = this.cbConnectors.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.infoList.get((int)n).connectorClass;
    }

    public String getConnectorParameters() {
        int n = this.cbConnectors.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.paramsList.get(n);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.stConnectors != null) {
            this.stConnectors.setEnabled(enabled);
        }
        this.cbConnectors.setEnabled(enabled);
        if (enabled) {
            this.updateConnector();
        } else {
            this.btOptions.setEnabled(enabled);
        }
        this.edSettings.setEnabled(enabled);
    }
}

