/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ListIterator;
import java.util.Stack;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.JSONEncoder;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.json.JsonEventBuilder;
import net.sf.okapi.filters.json.Parameters;
import net.sf.okapi.filters.json.parser.IJsonHandler;
import net.sf.okapi.filters.json.parser.JsonKeyTypes;
import net.sf.okapi.filters.json.parser.JsonParser;
import net.sf.okapi.filters.json.parser.JsonValueTypes;
import net.sf.okapi.filters.json.parser.ParseException;
import net.sf.okapi.filters.json.parser.StreamProvider;
import net.sf.okapi.filters.json.parser.TokenMgrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class JSONFilter
extends AbstractFilter
implements IJsonHandler {
    private static final String MIMETYPE = "application/json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private Parameters params;
    private JsonEventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private IFilter subFilter;
    private Stack<KeyAndType> keyNames;
    private String currentKeyName;
    private JsonKeyTypes currentKeyType;
    private Pattern exceptions;
    private int subfilterIndex;
    private RawDocument input;

    public JSONFilter() {
        this.setMimeType(MIMETYPE);
        this.setMultilingual(false);
        this.setName("okf_json");
        this.setDisplayName("Json Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "JSON (JavaScript Object Notation)", "Configuration for JSON files", null, ".json;"));
        this.setParameters(new Parameters());
    }

    @Override
    public void close() {
        super.close();
        this.hasUtf8Bom = false;
        this.hasUtf8Encoding = false;
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        return this.eventBuilder.next();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String subFilterName;
        this.input = input;
        super.open(input, generateSkeleton);
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        String encoding = detector.getEncoding();
        String linebreak = detector.getNewlineType().toString();
        this.hasUtf8Bom = detector.hasUtf8Bom();
        this.hasUtf8Encoding = detector.hasUtf8Encoding();
        input.setEncoding(encoding);
        this.setEncoding(encoding);
        this.setNewlineType(linebreak);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), encoding, generateSkeleton);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", encoding), e);
        }
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.exceptions = Util.isEmpty(this.params.getExceptions()) ? null : Pattern.compile(this.params.getExceptions());
        if (this.eventBuilder == null) {
            this.eventBuilder = new JsonEventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setMimeType(MIMETYPE);
        this.eventBuilder.setPreserveWhitespace(true);
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        if (!this.params.getUseCodeFinder() && (subFilterName = this.params.getSubfilter()) != null && !"".equals(subFilterName)) {
            this.subFilter = this.getFilterConfigurationMapper().createFilter(subFilterName, this.subFilter);
        }
        this.subfilterIndex = 0;
        this.keyNames = new Stack();
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
        JsonParser parser = new JsonParser(new StreamProvider(reader));
        parser.setHandler(this);
        try {
            parser.parse();
        }
        catch (ParseException | TokenMgrException e) {
            throw new OkapiBadFilterInputException(String.format("Error parsing JSON file: %s", e.getMessage()), e);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = super.getEncoderManager();
            this.encoderManager.setMapping(MIMETYPE, "net.sf.okapi.common.encoder.JSONEncoder");
        }
        return this.encoderManager;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    public void handleStart() {
        this.setFilterWriter(this.createFilterWriter());
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        if (!Util.isEmpty(this.params.getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(this.params.getSimplifierRules());
            this.eventBuilder.addFilterEvent(cs);
        }
    }

    @Override
    public void handleEnd() {
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    @Override
    public void handleComment(String c) {
        this.eventBuilder.addDocumentPart(c);
    }

    @Override
    public void handleKey(String key, JsonValueTypes valueType, JsonKeyTypes keyType) {
        this.eventBuilder.addDocumentPart(String.format("%s%s%S", valueType.getQuoteChar(), key, valueType.getQuoteChar()));
        this.currentKeyName = key;
        this.currentKeyType = keyType;
    }

    @Override
    public void handleWhitespace(String whitespace) {
        this.eventBuilder.addDocumentPart(whitespace);
    }

    @Override
    public void handleValue(String value, JsonValueTypes valueType) {
        String key = this.currentKeyName;
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
        if (!this.params.getExtractStandalone() && key == null) {
            this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
            return;
        }
        switch (valueType) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case SYMBOL: {
                this.eventBuilder.addDocumentPart(value);
                return;
            }
        }
        String resName = this.getKeyNames(key);
        boolean extract = this.params.getExtractAllPairs();
        if (this.exceptions != null && this.exceptions.matcher(resName).find()) {
            boolean bl = extract = !extract;
        }
        if (!extract) {
            this.eventBuilder.addDocumentPart(String.format("%s%s%s", valueType.getQuoteChar(), value, valueType.getQuoteChar()));
            return;
        }
        if (this.subFilter != null) {
            this.callSubfilter(value, valueType, resName);
            return;
        }
        switch (valueType) {
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: {
                this.eventBuilder.startTextUnit(new GenericSkeleton(valueType.getQuoteChar()));
                this.eventBuilder.addToTextUnit(value);
                this.eventBuilder.setTextUnitName(resName);
                this.eventBuilder.endTextUnit(new GenericSkeleton(valueType.getQuoteChar()));
                break;
            }
            case NUMBER: 
            case SYMBOL: {
                this.eventBuilder.startTextUnit(value);
                this.eventBuilder.setTextUnitName(resName);
                this.eventBuilder.endTextUnit();
                break;
            }
        }
        this.logger.debug("KEYNAME: " + resName + " : " + value);
    }

    private void callSubfilter(String value, JsonValueTypes valueType, String parentName) {
        String parentId = this.eventBuilder.findMostRecentParentId();
        if (parentId == null) {
            parentId = this.getDocumentId().getLastId();
        }
        SubFilter sf = new SubFilter(this.subFilter, new JSONEncoder(), ++this.subfilterIndex, parentId, parentName);
        this.eventBuilder.addFilterEvents(sf.getEvents(new RawDocument(this.eventBuilder.decode(value), this.getSrcLoc(), this.getTrgLoc())));
        this.eventBuilder.addToDocumentPart(valueType.getQuoteChar());
        this.eventBuilder.addToDocumentPart(sf.createRefCode().toString());
        this.eventBuilder.addToDocumentPart(valueType.getQuoteChar());
    }

    @Override
    public void handleObjectStart() {
        this.eventBuilder.startGroup(new GenericSkeleton("{"), "Json Object Start");
        this.keyNames.push(new KeyAndType(this.currentKeyName, this.currentKeyType));
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
    }

    @Override
    public void handleObjectEnd() {
        this.eventBuilder.endGroup(new GenericSkeleton("}"));
        this.keyNames.pop();
    }

    @Override
    public void handleListStart() {
        this.eventBuilder.startGroup(new GenericSkeleton("["), "Json List Start");
        this.keyNames.push(new KeyAndType(this.currentKeyName, this.currentKeyType));
        this.currentKeyName = null;
        this.currentKeyType = JsonKeyTypes.DEFAULT;
    }

    @Override
    public void handleListEnd() {
        this.eventBuilder.endGroup(new GenericSkeleton("]"));
        this.keyNames.pop();
    }

    @Override
    public void handleSeparator(String separator) {
        this.eventBuilder.addDocumentPart(separator);
    }

    private String getKeyNames(String key) {
        StringBuilder keyPath = new StringBuilder();
        if (!this.params.getUseKeyAsName()) {
            return null;
        }
        if (!this.params.getUseFullKeyPath()) {
            if (!this.keyNames.isEmpty() && this.keyNames.peek().type == JsonKeyTypes.LIST) {
                return this.keyNames.peek().name;
            }
            return key;
        }
        if (!this.keyNames.isEmpty()) {
            ListIterator it = this.keyNames.listIterator();
            while (it.hasNext()) {
                KeyAndType k = (KeyAndType)it.next();
                if (k == null || k.name == null) continue;
                keyPath.append("/").append(k.name);
            }
        }
        if (key != null && !key.isEmpty()) {
            keyPath.append("/").append(key);
        }
        if (!this.params.getUseLeadingSlashOnKeyPath() && keyPath.charAt(0) == '/') {
            keyPath.deleteCharAt(0);
        }
        return keyPath.toString();
    }

    private class KeyAndType {
        String name;
        JsonKeyTypes type;

        public KeyAndType(String name, JsonKeyTypes type) {
            this.name = name;
            this.type = type;
        }
    }
}

