/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEventBuilder
extends EventBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InlineCodeFinder codeFinder = null;
    private boolean escapeForwardSlashes = true;

    public JsonEventBuilder(String rootId, IFilter subFilter) {
        super(rootId, subFilter);
        if (subFilter.getParameters() != null) {
            this.escapeForwardSlashes = subFilter.getParameters().getBoolean("escapeForwardSlashes");
        }
    }

    @Override
    protected ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        TextFragment text = textUnit.getSource().getFirstContent();
        String unescaped = this.unescape(text);
        text.setCodedText(unescaped);
        if (this.codeFinder != null) {
            this.codeFinder.process(text);
        }
        return textUnit;
    }

    public String decode(String value) {
        return this.unescape(new TextFragment(value));
    }

    private String unescape(TextFragment text) {
        StringBuilder unescaped = new StringBuilder();
        block12: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    break;
                }
                default: {
                    unescaped.append(ch);
                    continue block12;
                }
            }
            ch = text.charAt(++i);
            switch (ch) {
                case 'b': {
                    unescaped.append('\b');
                    continue block12;
                }
                case 'f': {
                    unescaped.append('\f');
                    continue block12;
                }
                case 'n': {
                    unescaped.append('\n');
                    continue block12;
                }
                case 'r': {
                    unescaped.append('\r');
                    continue block12;
                }
                case 't': {
                    unescaped.append('\t');
                    continue block12;
                }
                case '\"': 
                case '\\': {
                    unescaped.append(ch);
                    continue block12;
                }
                case '/': {
                    if (!this.escapeForwardSlashes) continue block12;
                    unescaped.append(ch);
                    continue block12;
                }
                default: {
                    this.logger.warn("Unexpected Json escape sequence '\\{}'.", (Object)Character.valueOf(ch));
                    unescaped.append('\\');
                    unescaped.append(ch);
                }
            }
        }
        return unescaped.toString();
    }

    public void setCodeFinder(InlineCodeFinder codeFinder) {
        this.codeFinder = codeFinder;
    }
}

