/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml.parser;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class Line {
    private static Pattern NOT_THROW_AWAY = Pattern.compile("((\\s*((\r\n)|\r|\n)){2})|[#]");
    private static Yaml yaml = new Yaml();
    public boolean isSkeleton;
    public String line;
    public int indent;
    public boolean isThrowAway = false;
    public boolean startContinuation = false;
    public boolean endContinuation = false;

    public Line(String line, int indent, boolean isSkeleton) {
        this.line = line;
        this.isSkeleton = isSkeleton;
        this.indent = indent;
        this.isThrowAway = this.isThrowAway(line);
    }

    public Line(String line, boolean isSkeleton) {
        this.line = line;
        this.isSkeleton = isSkeleton;
        this.indent = -1;
        this.isThrowAway = this.isThrowAway(line);
    }

    public Line(String line) {
        this.line = line;
        this.isSkeleton = true;
        this.indent = -1;
        this.isThrowAway = this.isThrowAway(line);
    }

    public void setContinuation(boolean start, boolean end) {
        this.startContinuation = start;
        this.endContinuation = end;
    }

    public static String prependWhitespace(int indent) {
        if (indent <= 0) {
            return "";
        }
        char[] repeat = new char[indent];
        Arrays.fill(repeat, ' ');
        return new String(repeat);
    }

    public static String decode(String encoded) {
        String decoded = encoded;
        try {
            decoded = (String)yaml.load(encoded);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decoded;
    }

    private boolean isThrowAway(String line) {
        if (this.isSkeleton) {
            return !NOT_THROW_AWAY.matcher(line).find();
        }
        return false;
    }

    public String toString() {
        return this.line;
    }

    public boolean isEmpty() {
        if (this.line == null) {
            return true;
        }
        return this.line.isEmpty();
    }
}

