/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.merge;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.okapi.common.StringParameters;

public class Parameters
extends StringParameters {
    static final String SKELETONPATH = "skeletonpath";
    static final String APPROVEDONLY = "approvedOnly";
    static final String THROW_EXCEPTION_CODE_DIFFERENCES = "throwExceptionForCodeDifferences";
    static final String THROW_EXCEPTION_SEGMENT_ID_DIFFERENCES = "throwExceptionForSegmentIdDifferences";
    static final String THROW_EXCEPTION_SEGMENT_SOURCE_DIFFERENCES = "throwExceptionForSegmentSourceDifferences";
    private InputStream skeletonInputStream;

    @Override
    public void reset() {
        super.reset();
        this.setSkeletonUri(null);
        this.setSkeletonInputStream(null);
        this.setApprovedOnly(false);
        this.setThrowCodeException(false);
        this.setThrowSegmentIdException(true);
        this.setThrowSegmentSourceException(false);
    }

    public URI getSkeletonUri() throws URISyntaxException {
        return new URI(this.getString(SKELETONPATH));
    }

    public void setSkeletonUri(URI skeletonUri) {
        String s = "";
        if (skeletonUri != null) {
            s = skeletonUri.toString();
        }
        this.setString(SKELETONPATH, s);
    }

    public boolean isApprovedOnly() {
        return this.getBoolean(APPROVEDONLY);
    }

    public void setApprovedOnly(boolean approvedOnly) {
        this.setBoolean(APPROVEDONLY, approvedOnly);
    }

    public InputStream getSkeletonInputStream() {
        return this.skeletonInputStream;
    }

    public void setSkeletonInputStream(InputStream skeletonInputStream) {
        this.skeletonInputStream = skeletonInputStream;
    }

    public boolean isThrowCodeException() {
        return this.getBoolean(THROW_EXCEPTION_CODE_DIFFERENCES);
    }

    public void setThrowCodeException(boolean exception) {
        this.setBoolean(THROW_EXCEPTION_CODE_DIFFERENCES, exception);
    }

    public boolean isThrowSegmentIdException() {
        return this.getBoolean(THROW_EXCEPTION_SEGMENT_ID_DIFFERENCES);
    }

    public void setThrowSegmentIdException(boolean exception) {
        this.setBoolean(THROW_EXCEPTION_SEGMENT_ID_DIFFERENCES, exception);
    }

    public boolean isThrowSegmentSourceException() {
        return this.getBoolean(THROW_EXCEPTION_SEGMENT_SOURCE_DIFFERENCES);
    }

    public void setThrowSegmentSourceException(boolean exception) {
        this.setBoolean(THROW_EXCEPTION_SEGMENT_SOURCE_DIFFERENCES, exception);
    }
}

