/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.step;

import java.io.OutputStream;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.io.InputStreamFromOutputStream;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.tkit.merge.Parameters;
import net.sf.okapi.lib.tkit.merge.SkeletonMergerWriter;

public class SkeletonXliffMergerStep
extends BasePipelineStep {
    private LocaleId trgLoc;
    private RawDocument skeleton;
    private SkeletonMergerWriter skelMergerWriter = new SkeletonMergerWriter();
    private String outputEncoding;

    @Override
    public String getName() {
        return "Skeleton Merger Step";
    }

    @Override
    public String getDescription() {
        return "XLIFF merger which uses a JSON-based skeleton file instead of the original source document.";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.trgLoc = targetLocales.get(0);
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.skeleton = secondInput;
        ((Parameters)this.skelMergerWriter.getParameters()).setSkeletonInputStream(this.skeleton.getStream());
    }

    @Override
    protected Event handleRawDocument(final Event event) {
        final XLIFFFilter xlfFilter = new XLIFFFilter();
        this.skelMergerWriter.setOptions(this.trgLoc, this.outputEncoding);
        InputStreamFromOutputStream<Void> is = new InputStreamFromOutputStream<Void>(){

            @Override
            protected Void produce(OutputStream sink) throws Exception {
                try {
                    SkeletonXliffMergerStep.this.skelMergerWriter.setOutput(sink);
                    xlfFilter.open(event.getRawDocument());
                    while (xlfFilter.hasNext()) {
                        SkeletonXliffMergerStep.this.skelMergerWriter.handleEvent(xlfFilter.next());
                    }
                }
                catch (Exception e) {
                    this.close();
                    throw new OkapiMergeException("Error merging skeleton file", e);
                }
                finally {
                    if (xlfFilter != null) {
                        xlfFilter.close();
                    }
                    SkeletonXliffMergerStep.this.skelMergerWriter.close();
                    SkeletonXliffMergerStep.this.skeleton.close();
                }
                return null;
            }
        };
        return new Event(EventType.RAW_DOCUMENT, new RawDocument(is, this.outputEncoding, this.trgLoc));
    }

    @Override
    public void cancel() {
    }

    @Override
    public void destroy() {
        if (this.skelMergerWriter != null) {
            this.skelMergerWriter.close();
        }
    }
}

