/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.core.ExtElement;

public class ExtElements
implements Iterable<ExtElement> {
    private ArrayList<ExtElement> list;

    public ExtElements() {
    }

    public ExtElements(ExtElements original) {
        if (!original.isEmpty()) {
            for (ExtElement elem : original.list) {
                this.add(new ExtElement(elem));
            }
        }
    }

    @Override
    public Iterator<ExtElement> iterator() {
        if (this.list == null) {
            this.list = new ArrayList(2);
        }
        return this.list.iterator();
    }

    public ExtElement add(ExtElement element) {
        if (this.list == null) {
            this.list = new ArrayList(2);
        }
        this.list.add(element);
        return element;
    }

    public ExtElement add(String namespaceURI, String localPart, String prefix) {
        return this.add(new ExtElement(new QName(namespaceURI, localPart, prefix)));
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list == null || this.list.size() == 0;
    }

    public ExtElement get(int index) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get(index);
    }

    public List<ExtElement> find(String namespaceURI, String localName) {
        if (this.list == null) {
            return Collections.emptyList();
        }
        QName qn = new QName(namespaceURI, localName);
        ArrayList<ExtElement> res = new ArrayList<ExtElement>();
        for (ExtElement elem : this.list) {
            if (!elem.getQName().equals(qn)) continue;
            res.add(elem);
        }
        return res;
    }

    public ExtElement getOrCreate(String namespaceURI, String localName, String prefix) {
        if (this.list != null) {
            QName qn = new QName(namespaceURI, localName);
            for (ExtElement elem : this.list) {
                if (!elem.getQName().equals(qn)) continue;
                return elem;
            }
        }
        return this.add(namespaceURI, localName, prefix);
    }
}

