/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final String MSG_CANT_INSTANTIATE = "ClassUtil: cannot instantiate %s";
    private static final String MSG_EMPTY_CLASSNAME = "ClassUtil: class name cannot be empty";
    private static final String MSG_NULL_REF = "ClassUtil: class reference cannot be null";
    private static final String MSG_NULL_LOADER = "ClassUtil: class loader cannot be null";
    private static final String MSG_NONRESOLVABLE = "ClassUtil: cannot resolve class name %s";
    private static final Pattern SPACES = Pattern.compile("\\s");
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public static Class<?> getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass();
    }

    public static Class<?> getClass(String className) {
        Class<?> ref;
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        try {
            ref = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException(String.format(MSG_NONRESOLVABLE, className));
        }
        return ref;
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.getClassName(obj.getClass());
    }

    public static String getClassName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        return classRef.getSimpleName();
    }

    public static String getQualifiedClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.getQualifiedClassName(obj.getClass());
    }

    public static String getQualifiedClassName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        return classRef.getName();
    }

    public static String getShortClassName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        return ClassUtil.extractShortClassName(ClassUtil.getQualifiedClassName(classRef));
    }

    public static String getShortClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.extractShortClassName(ClassUtil.getQualifiedClassName(obj));
    }

    public static String getPackageName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.getPackageName(obj.getClass());
    }

    public static String getPackageName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        Package pkg = classRef.getPackage();
        if (pkg == null) {
            String shortClassName;
            String className = classRef.getName();
            int index = className.lastIndexOf(shortClassName = classRef.getSimpleName());
            if (index != -1) {
                String res = className.substring(0, index);
                return res.endsWith(".") ? res.substring(0, res.length() - 1) : res;
            }
            return "";
        }
        return pkg.getName();
    }

    public static String getTargetPath(Class<?> cls) {
        try {
            return cls.getResource("").toURI().getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String extractPackageName(String className) {
        if (Util.isEmpty(className)) {
            return "";
        }
        int index = className.lastIndexOf(".");
        if (index > -1) {
            return className.substring(0, index);
        }
        return "";
    }

    public static String extractShortClassName(String className) {
        if (Util.isEmpty(className)) {
            return "";
        }
        int index = className.lastIndexOf(".");
        if (index > -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String qualifyName(String packageName, String shortClassName) {
        if (Util.isEmpty(packageName)) {
            return "";
        }
        if (Util.isEmpty(shortClassName)) {
            return "";
        }
        if (shortClassName.indexOf(".") != -1) {
            return shortClassName;
        }
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        return packageName + shortClassName;
    }

    public static String qualifyName(Class<?> siblingClassRef, String shortClassName) {
        return ClassUtil.qualifyName(ClassUtil.getPackageName(siblingClassRef), shortClassName);
    }

    public static String qualifyName(Object sibling, String shortClassName) {
        if (sibling == null) {
            return "";
        }
        return ClassUtil.qualifyName(sibling.getClass(), shortClassName);
    }

    public static <T> T instantiateClass(Class<T> classRef) throws InstantiationException, IllegalAccessException {
        if (classRef == null) {
            throw new IllegalArgumentException(MSG_NULL_REF);
        }
        return classRef.cast(classRef.newInstance());
    }

    public static Object instantiateClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        return ClassUtil.instantiateClass(Class.forName(className));
    }

    public static Object instantiateClass(String className, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(MSG_NULL_LOADER);
        }
        Class<?> ref = Class.forName(className, true, classLoader);
        if (ref == null) {
            throw new OkapiException(String.format(MSG_NONRESOLVABLE, className));
        }
        return ref.cast(ref.newInstance());
    }

    public static <T> T instantiateClass(Class<T> classRef, Object ... constructorParameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors;
        if (classRef == null) {
            throw new IllegalArgumentException(MSG_NULL_REF);
        }
        if (constructorParameters == null) {
            return ClassUtil.instantiateClass(classRef);
        }
        for (Constructor<?> constructor : constructors = classRef.getConstructors()) {
            Class<?>[] parameterTypes;
            if (constructor == null || (parameterTypes = constructor.getParameterTypes()).length != constructorParameters.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> paramType = parameterTypes[i];
                Object constructorParameter = constructorParameters[i];
                if (paramType.isInstance(constructorParameter)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return classRef.cast(constructor.newInstance(constructorParameters));
        }
        throw new OkapiException(String.format(MSG_CANT_INSTANTIATE, classRef.getName()));
    }

    public static Object instantiateClass(String className, Object ... constructorParameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        Class<?> ref = Class.forName(className);
        return ref.cast(ClassUtil.instantiateClass(ref, constructorParameters));
    }

    public static Object instantiateClass(String className, ClassLoader classLoader, Object ... constructorParameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(MSG_NULL_LOADER);
        }
        Class<?> ref = classLoader.loadClass(className);
        return ref.cast(ClassUtil.instantiateClass(ref, constructorParameters));
    }

    public static String getResourcePath(Class<?> cls, String resourceName) {
        return new File(Util.URLtoURI(cls.getResource(resourceName))).getPath();
    }

    public static String getResourceParent(Class<?> cls, String resourceName) {
        if (ClassUtil.isInJar(cls, resourceName)) {
            URL url = cls.getResource(resourceName);
            try {
                String path = url.getPath();
                int index = path.indexOf(33);
                URI uri = new URI(path.substring(0, index));
                File file = new File(uri);
                return file.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                return "";
            }
        }
        URI uri = Util.URLtoURI(cls.getResource(resourceName));
        return new File(uri).getParent();
    }

    public static boolean isInJar(Class<?> cls, String resPath) {
        URL url = cls.getResource(resPath);
        if (url == null && !resPath.startsWith("/")) {
            resPath = "/" + resPath;
            url = cls.getResource(resPath);
        }
        if (url == null) {
            return false;
        }
        return "jar".equalsIgnoreCase(url.getProtocol());
    }

    public static String buildClassPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            File file = new File(path);
            try {
                sb.append(URLDecoder.decode(file.getAbsolutePath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new OkapiException(e);
            }
        }
        String res = sb.toString();
        if (RegexUtil.contains(res, SPACES)) {
            res = String.format("\"%s\"", res);
        }
        System.out.println(res);
        return res;
    }

    public static String getPath(Class<?> cls) {
        return cls.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static String getClassFilePath(Class<?> cls) {
        return ClassUtil.getPath(cls) + cls.getName().replace('.', '/').concat(".class");
    }

    public static String buildClassPath(Class<?> ... classes) {
        ArrayList<String> paths = new ArrayList<String>(classes.length);
        for (Class<?> cls : classes) {
            paths.add(ClassUtil.getPath(cls));
        }
        return ClassUtil.buildClassPath(ListUtil.stringListAsArray(paths));
    }
}

