/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.IOException;
import java.io.InputStream;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.connectors.microsoft.AzureAuthenticationException;
import net.sf.okapi.connectors.microsoft.Parameters;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int TOKENRETRIES = 3;
    private int SLEEPPAUSE_MS = 300;
    private static final String TOKEN_URL = "https://api.cognitive.microsoft.com/sts/v1.0/issueToken";
    private static final String KEY_HEADER = "Ocp-Apim-Subscription-Key";
    private int TOKEN_EXPIRATION_MS = 420000;
    private HttpClient httpClient;
    private Parameters params;
    private Token token = TokenProvider.expiredToken();

    public TokenProvider(HttpClient httpClient, Parameters params) {
        this.httpClient = httpClient;
        this.params = params;
    }

    public static Token expiredToken() {
        return new Token("", 0L);
    }

    public String get() {
        if (this.token.isExpired() || this.isExpiring()) {
            for (int tries = 0; tries < 3; ++tries) {
                if (this.getAccesstoken()) {
                    return this.token.token;
                }
                if (tries >= 2) continue;
                this.sleep(this.SLEEPPAUSE_MS);
            }
            throw new OkapiException(String.format("Failed to get Microsoft Translator access token after %d tries.", 3));
        }
        return this.token.token;
    }

    private boolean isExpiring() {
        long now = System.currentTimeMillis();
        if (now > this.token.expiresOn - 500L) {
            this.sleep(this.token.expiresOn - now);
            return true;
        }
        return false;
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new OkapiException("Sleep interrupted while attempting to get Azure Marketplace Token" + e.getMessage(), e);
        }
    }

    private boolean getAccesstoken() {
        try {
            String tokenRes = this.getRawToken();
            if (tokenRes != null) {
                this.token = new Token(tokenRes, System.currentTimeMillis() + (long)this.TOKEN_EXPIRATION_MS);
                return true;
            }
        }
        catch (OkapiException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Error in getAccestoken: {}", (Object)e.getMessage());
        }
        return false;
    }

    private String getRawToken() {
        if (this.params.getAzureKey() == null || "".equals(this.params.getAzureKey())) {
            throw new AzureAuthenticationException("You must specify an Azure authentication key.");
        }
        HttpResponse response = null;
        try {
            String responseBody;
            Throwable throwable;
            InputStream is;
            StatusLine status;
            block24: {
                String string;
                block25: {
                    block26: {
                        HttpPost post = new HttpPost(TOKEN_URL);
                        post.addHeader(KEY_HEADER, this.params.getAzureKey());
                        response = this.httpClient.execute(post);
                        status = response.getStatusLine();
                        is = response.getEntity().getContent();
                        throwable = null;
                        responseBody = StreamUtil.streamUtf8AsString(is);
                        if (status.getStatusCode() != 200) break block24;
                        string = responseBody;
                        if (is == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block25;
                    }
                    is.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        this.logger.error("Failed to get token: status {}: {}\nBody: {}", status.getStatusCode(), status.getReasonPhrase(), responseBody);
                        throw new AzureAuthenticationException("Failed to get token: status " + status.getStatusCode() + ", " + status.getReasonPhrase());
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            is.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to fetch token", e);
                throw new AzureAuthenticationException("Failed to get Microsoft Translator token", e);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.getEntity().getContent().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class Token {
        final String token;
        final long expiresOn;

        public Token(String token, long expiresOn) {
            this.token = token;
            this.expiresOn = expiresOn;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expiresOn;
        }
    }
}

