/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Eventive;
import net.sf.okapi.filters.idml.Nameable;

class MarkupRange
implements Eventive {
    protected final List<XMLEvent> events;

    MarkupRange(List<XMLEvent> events) {
        this.events = events;
    }

    static MarkupRange getMarkupRange(List<XMLEvent> events) {
        return new MarkupRange(events);
    }

    static MarkupRange getMarkupRangeStartElement(StartElement startElement) {
        return new MarkupRangeStartElement(startElement);
    }

    static MarkupRange getMarkupRangeEndElement(EndElement endElement) {
        return new MarkupRangeEndElement(endElement);
    }

    @Override
    public List<XMLEvent> getEvents() {
        return this.events;
    }

    static class MarkupRangeElement
    extends MarkupRange
    implements Nameable {
        private static final int START_ELEMENT_INDEX = 0;
        private int endElementIndex;

        MarkupRangeElement(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement) {
            super(MarkupRangeElement.asList(startElement, innerEvents, endElement));
            this.endElementIndex = this.events.size() - 1;
        }

        private static List<XMLEvent> asList(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement) {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(innerEvents.size() + 2);
            events.add(startElement);
            events.addAll(innerEvents);
            events.add(endElement);
            return events;
        }

        StartElement getStartElement() {
            return ((XMLEvent)this.events.get(0)).asStartElement();
        }

        List<XMLEvent> getInnerEvents() {
            return this.events.subList(1, this.endElementIndex);
        }

        EndElement getEndElement() {
            return ((XMLEvent)this.events.get(this.endElementIndex)).asEndElement();
        }

        @Override
        public QName getName() {
            return ((XMLEvent)this.events.get(0)).asStartElement().getName();
        }

        static class MarkupRangeElementBuilder
        implements Builder<MarkupRangeElement> {
            protected StartElement startElement;
            protected List<XMLEvent> innerEvents = new ArrayList<XMLEvent>();
            protected EndElement endElement;

            MarkupRangeElementBuilder() {
            }

            MarkupRangeElementBuilder setStartElement(StartElement startElement) {
                this.startElement = startElement;
                return this;
            }

            MarkupRangeElementBuilder addInnerEvent(XMLEvent innerEvent) {
                this.innerEvents.add(innerEvent);
                return this;
            }

            MarkupRangeElementBuilder addInnerEvents(List<XMLEvent> innerEvents) {
                this.innerEvents.addAll(innerEvents);
                return this;
            }

            MarkupRangeElementBuilder setEndElement(EndElement endElement) {
                this.endElement = endElement;
                return this;
            }

            @Override
            public MarkupRangeElement build() {
                return new MarkupRangeElement(this.startElement, this.innerEvents, this.endElement);
            }
        }
    }

    static class MarkupRangeEndElement
    extends MarkupRange
    implements Nameable {
        private static final int END_ELEMENT_INDEX = 0;

        MarkupRangeEndElement(EndElement endElement) {
            super(Collections.singletonList(endElement));
        }

        @Override
        public QName getName() {
            return ((XMLEvent)this.events.get(0)).asEndElement().getName();
        }
    }

    static class MarkupRangeStartElement
    extends MarkupRange
    implements Nameable {
        private static final int START_ELEMENT_INDEX = 0;

        MarkupRangeStartElement(StartElement startElement) {
            super(Collections.singletonList(startElement));
        }

        @Override
        public QName getName() {
            return ((XMLEvent)this.events.get(0)).asStartElement().getName();
        }
    }

    static class MarkupRangeBuilder
    implements Builder<MarkupRange> {
        protected List<XMLEvent> events = new ArrayList<XMLEvent>();

        MarkupRangeBuilder() {
        }

        MarkupRangeBuilder addEvents(List<XMLEvent> events) {
            this.events.addAll(events);
            return this;
        }

        @Override
        public MarkupRange build() {
            return new MarkupRange(this.events);
        }
    }
}

