/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MarkupRangeElementParser;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.PropertiesParser;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StoryChildElementsWriter;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.StyleRange;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.StyleRangeParser;

class StoryChildElementsParser {
    private static final QName CHANGE_TYPE = Namespaces.getDefaultNamespace().getQName("ChangeType");
    private static final String DELETED_TEXT = "DeletedText";
    private static final QName ROW = Namespaces.getDefaultNamespace().getQName("Row");
    private static final QName COLUMN = Namespaces.getDefaultNamespace().getQName("Column");
    private static final QName CELL = Namespaces.getDefaultNamespace().getQName("Cell");
    private static final EnumSet<ParsingIdioms.StyledStoryChildElement> PARAGRAPH_STYLE_RANGE_STYLED_ELEMENTS = EnumSet.complementOf(EnumSet.of(ParsingIdioms.StyledStoryChildElement.UNSUPPORTED, ParsingIdioms.StyledStoryChildElement.PARAGRAPH_STYLE_RANGE));
    private final StartElement startElement;
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final XMLEventReader eventReader;
    private StyleRange currentParagraphStyleRange;
    private StyleRange currentCharacterStyleRange;

    StoryChildElementsParser(StartElement startElement, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
        this.startElement = startElement;
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.eventReader = eventReader;
    }

    List<StoryChildElement> parse() throws XMLStreamException {
        if (!ParsingIdioms.StyledStoryChildElement.PARAGRAPH_STYLE_RANGE.getName().equals(this.startElement.getName())) {
            if (PARAGRAPH_STYLE_RANGE_STYLED_ELEMENTS.contains((Object)ParsingIdioms.StyledStoryChildElement.fromName(this.startElement.getName()))) {
                return this.parseAsFromParagraphStyleRange(this.startElement);
            }
            return this.parseFromUnstyledRange(this.startElement);
        }
        return this.parseFromParagraphStyleRange();
    }

    private List<StoryChildElement> parseWithStyleDefinitions(StyleDefinitions styleDefinitions) throws XMLStreamException {
        this.currentParagraphStyleRange = styleDefinitions.getParagraphStyleRange();
        this.currentCharacterStyleRange = styleDefinitions.getCharacterStyleRange();
        return this.parse();
    }

    private List<StoryChildElement> parseFromUnstyledRange(StartElement startElement) throws XMLStreamException {
        StoryChildElement.StoryChildElementBuilder storyChildElementBuilder = new StoryChildElement.StoryChildElementBuilder();
        return Collections.singletonList(new StoryChildElementParser(startElement, this.eventReader).parse(storyChildElementBuilder));
    }

    private List<StoryChildElement> parseAsFromParagraphStyleRange(StartElement startElement) throws XMLStreamException {
        StyleRange paragraphStyleRange;
        StyleRange styleRange = paragraphStyleRange = null == this.currentParagraphStyleRange ? StyleRange.getDefaultParagraphStyleRange(this.eventFactory) : this.currentParagraphStyleRange;
        if (!ParsingIdioms.StyledStoryChildElement.CHARACTER_STYLE_RANGE.getName().equals(startElement.getName())) {
            return this.parseAsFromCharacterStyleRange(startElement, paragraphStyleRange);
        }
        return this.parseFromCharacterStyleRange(startElement, paragraphStyleRange, null);
    }

    private List<StoryChildElement> parseFromParagraphStyleRange() throws XMLStreamException {
        StyleRange paragraphStyleRange;
        ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
        this.currentParagraphStyleRange = paragraphStyleRange = new StyleRangeParser(this.startElement, this.eventReader).parse();
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                return storyChildElements;
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            if (!ParsingIdioms.StyledStoryChildElement.CHARACTER_STYLE_RANGE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.addAll(this.parseAsFromCharacterStyleRange(event.asStartElement(), paragraphStyleRange));
                continue;
            }
            storyChildElements.addAll(this.parseFromCharacterStyleRange(event.asStartElement(), paragraphStyleRange, null));
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private List<StoryChildElement> parseAsFromCharacterStyleRange(StartElement startElement, StyleRange paragraphStyleRange) throws XMLStreamException {
        StyleRange characterStyleRange = null == this.currentCharacterStyleRange ? StyleRange.getDefaultCharacterStyleRange(this.eventFactory) : this.currentCharacterStyleRange;
        StyleDefinitions styleDefinitions = new StyleDefinitions(paragraphStyleRange, characterStyleRange);
        if (this.parameters.getUntagXmlStructures()) {
            if (ParsingIdioms.StyledStoryChildElement.XML_ATTRIBUTE.getName().equals(startElement.getName()) || ParsingIdioms.StyledStoryChildElement.XML_COMMENT.getName().equals(startElement.getName()) || ParsingIdioms.StyledStoryChildElement.XML_INSTRUCTION.getName().equals(startElement.getName())) {
                this.skipRange(startElement);
                return Collections.emptyList();
            }
            if (ParsingIdioms.StyledStoryChildElement.XML_ELEMENT.getName().equals(startElement.getName())) {
                return this.parseFromElementRange(startElement, styleDefinitions);
            }
        }
        if (ParsingIdioms.StyledStoryChildElement.HYPERLINK_TEXT_SOURCE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseHyperlinkTextSource(startElement, styleDefinitions));
        }
        if (ParsingIdioms.StyledStoryChildElement.FOOTNOTE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseFootnote(startElement, styleDefinitions));
        }
        if (ParsingIdioms.StyledStoryChildElement.NOTE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseNote(startElement, styleDefinitions));
        }
        if (ParsingIdioms.StyledStoryChildElement.TABLE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseTable(startElement, styleDefinitions));
        }
        if (ParsingIdioms.StyledStoryChildElement.CHANGE.getName().equals(startElement.getName())) {
            return this.parseFromChangedRange(startElement, styleDefinitions);
        }
        if (ParsingIdioms.StyledStoryChildElement.CONTENT.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseContent(startElement, styleDefinitions));
        }
        if (ParsingIdioms.StyledStoryChildElement.BREAK.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseBreak(startElement, styleDefinitions));
        }
        return Collections.singletonList(this.parseFromStyledRange(startElement, styleDefinitions));
    }

    private List<StoryChildElement> parseFromCharacterStyleRange(StartElement startElement, StyleRange paragraphStyleRange, StyleRange defaultCharacterStyleRange) throws XMLStreamException {
        StyleRange characterStyleRange;
        this.currentCharacterStyleRange = characterStyleRange = null == defaultCharacterStyleRange ? new StyleRangeParser(startElement, this.eventReader).parse() : defaultCharacterStyleRange;
        StyleDefinitions styleDefinitions = new StyleDefinitions(paragraphStyleRange, characterStyleRange);
        ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                return storyChildElements;
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            if (this.parameters.getUntagXmlStructures()) {
                if (ParsingIdioms.StyledStoryChildElement.XML_ATTRIBUTE.getName().equals(event.asStartElement().getName()) || ParsingIdioms.StyledStoryChildElement.XML_COMMENT.getName().equals(event.asStartElement().getName()) || ParsingIdioms.StyledStoryChildElement.XML_INSTRUCTION.getName().equals(event.asStartElement().getName())) {
                    this.skipRange(event.asStartElement());
                    continue;
                }
                if (ParsingIdioms.StyledStoryChildElement.XML_ELEMENT.getName().equals(event.asStartElement().getName())) {
                    storyChildElements.addAll(this.parseFromElementRange(event.asStartElement(), styleDefinitions));
                    continue;
                }
            }
            if (ParsingIdioms.StyledStoryChildElement.HYPERLINK_TEXT_SOURCE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseHyperlinkTextSource(event.asStartElement(), styleDefinitions));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.FOOTNOTE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseFootnote(event.asStartElement(), styleDefinitions));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.NOTE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseNote(event.asStartElement(), styleDefinitions));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.TABLE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseTable(event.asStartElement(), styleDefinitions));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.CHANGE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.addAll(this.parseFromChangedRange(event.asStartElement(), styleDefinitions));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.CONTENT.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseContent(event.asStartElement(), styleDefinitions));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.BREAK.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseBreak(event.asStartElement(), styleDefinitions));
                continue;
            }
            storyChildElements.add(this.parseFromStyledRange(event.asStartElement(), styleDefinitions));
        }
        return storyChildElements;
    }

    private List<StoryChildElement> parseFromElementRange(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        XMLEvent event;
        ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
        while (!(!this.eventReader.hasNext() || (event = this.eventReader.nextTag()).isEndElement() && startElement.getName().equals(event.asEndElement().getName()))) {
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            storyChildElements.addAll(new StoryChildElementsParser(event.asStartElement(), this.parameters, this.eventFactory, this.eventReader).parseWithStyleDefinitions(styleDefinitions));
        }
        return storyChildElements;
    }

    private StoryChildElement parseHyperlinkTextSource(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource.HyperlinkTextSourceBuilder hyperlinkTextSourceBuilder = new StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource.HyperlinkTextSourceBuilder();
        return new StyledTextReferenceElementParser(startElement, styleDefinitions, this.parameters, this.eventFactory, this.eventReader).parse(hyperlinkTextSourceBuilder);
    }

    private StoryChildElement parseFootnote(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        StoryChildElement.StyledTextReferenceElement.Footnote.FootnoteBuilder footnoteBuilder = new StoryChildElement.StyledTextReferenceElement.Footnote.FootnoteBuilder();
        return new StyledTextReferenceElementParser(startElement, styleDefinitions, this.parameters, this.eventFactory, this.eventReader).parse(footnoteBuilder);
    }

    private StoryChildElement parseNote(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        StoryChildElement.StyledTextReferenceElement.Note.NoteBuilder noteBuilder = new StoryChildElement.StyledTextReferenceElement.Note.NoteBuilder();
        return new StyledTextReferenceElementParser(startElement, styleDefinitions, this.parameters, this.eventFactory, this.eventReader).parse(noteBuilder);
    }

    private StoryChildElement parseTable(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        return new TableParser(startElement, styleDefinitions, this.parameters, this.eventFactory, this.eventReader).parse();
    }

    private List<StoryChildElement> parseFromChangedRange(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        String changeTypeValue = startElement.getAttributeByName(CHANGE_TYPE).getValue();
        if (DELETED_TEXT.equals(changeTypeValue)) {
            this.skipRange(startElement);
            return Collections.emptyList();
        }
        return this.acceptChanges(startElement, styleDefinitions);
    }

    private void skipRange(StartElement startElement) throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isEndElement() || !event.asEndElement().getName().equals(startElement.getName())) continue;
            return;
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private List<StoryChildElement> acceptChanges(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        return this.parseFromElementRange(startElement, styleDefinitions);
    }

    private StoryChildElement parseContent(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        StoryChildElement.StyledTextElement.Content.ContentBuilder contentBuilder = new StoryChildElement.StyledTextElement.Content.ContentBuilder();
        contentBuilder.setStyleDefinitions(styleDefinitions);
        return new StoryChildElementParser(startElement, this.eventReader).parse(contentBuilder);
    }

    private StoryChildElement parseBreak(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        StoryChildElement.StyledTextElement.Break.BreakBuilder breakBuilder = new StoryChildElement.StyledTextElement.Break.BreakBuilder();
        breakBuilder.setStyleDefinitions(styleDefinitions);
        return new StoryChildElementParser(startElement, this.eventReader).parse(breakBuilder);
    }

    private StoryChildElement parseFromStyledRange(StartElement startElement, StyleDefinitions styleDefinitions) throws XMLStreamException {
        StoryChildElement.StyledTextElement.StyledTextElementBuilder styledTextElementBuilder = new StoryChildElement.StyledTextElement.StyledTextElementBuilder();
        styledTextElementBuilder.setStyleDefinitions(styleDefinitions);
        return new StoryChildElementParser(startElement, this.eventReader).parse(styledTextElementBuilder);
    }

    private static class TableParser {
        private final StartElement startElement;
        private final StyleDefinitions styleDefinitions;
        private final Parameters parameters;
        private final XMLEventFactory eventFactory;
        private final XMLEventReader eventReader;

        private TableParser(StartElement startElement, StyleDefinitions styleDefinitions, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
            this.startElement = startElement;
            this.styleDefinitions = styleDefinitions;
            this.parameters = parameters;
            this.eventFactory = eventFactory;
            this.eventReader = eventReader;
        }

        StoryChildElement.StyledTextReferenceElement.Table parse() throws XMLStreamException {
            StoryChildElement.StyledTextReferenceElement.Table.TableBuilder tableBuilder = new StoryChildElement.StyledTextReferenceElement.Table.TableBuilder();
            tableBuilder.setStyleDefinitions(this.styleDefinitions);
            tableBuilder.setStartElement(this.startElement);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextTag();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    tableBuilder.setEndElement(event.asEndElement());
                    return tableBuilder.build();
                }
                if (!event.isStartElement()) {
                    throw new IllegalStateException("Unexpected structure");
                }
                if (ParsingIdioms.PROPERTIES.equals(event.asStartElement().getName())) {
                    tableBuilder.setProperties(new PropertiesParser(event.asStartElement(), this.eventReader).parse());
                    continue;
                }
                if (ROW.equals(event.asStartElement().getName()) || COLUMN.equals(event.asStartElement().getName())) {
                    tableBuilder.addMarkupRangeElement(new MarkupRangeElementParser(event.asStartElement(), this.eventReader).parse(new MarkupRange.MarkupRangeElement.MarkupRangeElementBuilder()));
                    continue;
                }
                if (!CELL.equals(event.asStartElement().getName())) {
                    throw new IllegalStateException("Unexpected structure");
                }
                StoryChildElement.StyledTextReferenceElement.Table.Cell.CellBuilder cellBuilder = new StoryChildElement.StyledTextReferenceElement.Table.Cell.CellBuilder();
                tableBuilder.addCell((StoryChildElement.StyledTextReferenceElement.Table.Cell)new StyledTextReferenceElementParser(event.asStartElement(), null, this.parameters, this.eventFactory, this.eventReader).parse(cellBuilder));
            }
            throw new IllegalStateException("Unexpected structure");
        }
    }

    private static class StyledTextReferenceElementParser {
        private final StartElement startElement;
        private final StyleDefinitions styleDefinitions;
        private final Parameters parameters;
        private final XMLEventFactory eventFactory;
        private final XMLEventReader eventReader;

        private StyledTextReferenceElementParser(StartElement startElement, StyleDefinitions styleDefinitions, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
            this.startElement = startElement;
            this.styleDefinitions = styleDefinitions;
            this.parameters = parameters;
            this.eventFactory = eventFactory;
            this.eventReader = eventReader;
        }

        StoryChildElement.StyledTextReferenceElement parse(StoryChildElement.StyledTextReferenceElement.StyledTextReferenceElementBuilder styledTextReferenceElementBuilder) throws XMLStreamException {
            styledTextReferenceElementBuilder.setStyleDefinitions(this.styleDefinitions);
            styledTextReferenceElementBuilder.setStartElement(this.startElement);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextTag();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    StyleRangeEventsGenerator styleRangeEventsGenerator = new StyleRangeEventsGenerator(this.eventFactory);
                    styledTextReferenceElementBuilder.setStyleRangeEventsGenerator(styleRangeEventsGenerator).setStoryChildElementsWriter(new StoryChildElementsWriter(styleRangeEventsGenerator)).setEndElement(event.asEndElement());
                    return styledTextReferenceElementBuilder.build();
                }
                if (!event.isStartElement()) {
                    throw new IllegalStateException("Unexpected structure");
                }
                if (ParsingIdioms.PROPERTIES.equals(event.asStartElement().getName())) {
                    styledTextReferenceElementBuilder.setProperties(new PropertiesParser(event.asStartElement(), this.eventReader).parse());
                    continue;
                }
                styledTextReferenceElementBuilder.addStoryChildElements(new StoryChildElementsParser(event.asStartElement(), this.parameters, this.eventFactory, this.eventReader).parse());
            }
            throw new IllegalStateException("Unexpected structure");
        }
    }

    private static class StoryChildElementParser
    extends MarkupRangeElementParser {
        StoryChildElementParser(StartElement startElement, XMLEventReader eventReader) {
            super(startElement, eventReader);
        }

        StoryChildElement parse(StoryChildElement.StoryChildElementBuilder storyChildElementBuilder) throws XMLStreamException {
            return (StoryChildElement)super.parse(storyChildElementBuilder);
        }
    }
}

