/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.markdown.MarkdownEventBuilder;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.parser.MarkdownParser;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;
import net.sf.okapi.filters.markdown.parser.MarkdownTokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MarkdownFilter
extends AbstractFilter {
    private static final String DEFAULT_HTML_SUBFILTER_CONFIG_SPEC = "okf_html@for_markdown.fprm";
    private static final Pattern HTML_CDATA_PAT = Pattern.compile("\\<!\\[CDATA\\[(.*)\\]\\]\\>");
    private static final Code CDATA_START_CODE = new Code(TextFragment.TagType.OPENING, "cdata", "<![CDATA[");
    private static final Code CDATA_END_CODE = new Code(TextFragment.TagType.CLOSING, "cdata", "]]>");
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private MarkdownParser parser;
    private Parameters params = new Parameters();
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private HtmlFilter htmlFilter;
    private int htmlSectionIndex;
    private MarkdownEventBuilder eventBuilder;

    public MarkdownFilter() {
        this.parser = new MarkdownParser(this.params);
        this.setMimeType("text/x-markdown");
        this.setMultilingual(false);
        this.setName("okf_markdown");
        this.setDisplayName("Markdown Filter");
        this.setFilterWriter(this.createFilterWriter());
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/x-markdown", this.getClass().getName(), "Markdown", "Markdown files", null, ".md"));
        this.htmlFilter = new HtmlFilter();
        InputStream configStream = this.getClass().getResourceAsStream(DEFAULT_HTML_SUBFILTER_CONFIG_SPEC);
        this.htmlFilter.getParameters().load(configStream, false);
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
            this.detector = null;
            this.eventBuilder = null;
        }
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasQueuedEvents();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.detector != null && this.detector.hasUtf8Bom();
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.detector != null && this.detector.hasUtf8Encoding();
    }

    @Override
    public Event next() {
        if (this.hasNext()) {
            Event e = this.eventBuilder.next();
            if (this.LOGGER.isDebugEnabled()) {
                FilterUtil.logDebugEvent(e, "next()=>", this.LOGGER);
            }
            return e;
        }
        throw new IllegalStateException("No events available");
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        super.open(input, generateSkeleton);
        this.htmlSectionIndex = 0;
        this.currentRawDocument = input;
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setNewlineType(this.detector.getNewlineType().toString());
        String detectedEncoding = this.getDetectedEncoding();
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        this.parser = new MarkdownParser(this.params);
        this.generateTokens();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(this.parser.toString());
        }
        if (!Util.isEmpty(this.params.getHtmlSubfilter())) {
            this.htmlFilter = (HtmlFilter)this.getFilterConfigurationMapper().createFilter(this.params.getHtmlSubfilter(), this.htmlFilter);
            if (this.htmlFilter == null) {
                throw new OkapiBadFilterInputException("Unkown subfilter: " + this.params.getHtmlSubfilter());
            }
        }
        if (this.eventBuilder == null) {
            this.eventBuilder = new MarkdownEventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setPreserveWhitespace(true);
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
            this.eventBuilder.setCodeFinder(this.params.getCodeFinder());
        }
        this.generateEvents();
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
        this.createSkeletonWriter();
        this.getEncoderManager();
    }

    private String getDetectedEncoding() {
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Overridding user set encoding (if any). Setting auto-detected encoding {}.", (Object)detectedEncoding);
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            this.LOGGER.debug("Default encoding and detected encoding not found. Using best guess encoding {}", (Object)detectedEncoding);
        }
        return detectedEncoding;
    }

    private void generateTokens() {
        this.parser.setNewline(this.getNewlineType());
        try (Scanner scanner = new Scanner(this.currentRawDocument.getReader());){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                this.parser.parse(scanner.next());
            }
        }
    }

    private void generateEvents() {
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Generating Events from the following tokens...\n{}", (Object)this.parser.dumpTokens());
        }
        block0: while (this.parser.hasNextToken()) {
            MarkdownToken token = this.parser.getNextToken();
            if (token.getType().equals((Object)MarkdownTokenType.INDENTED_CODE_BLOCK)) {
                if (!this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.startTextUnit();
                }
                while (this.parser.hasNextToken()) {
                    if (token.getType().equals((Object)MarkdownTokenType.END_INDENTED_CODE_BLOCK)) {
                        this.eventBuilder.endTextUnit();
                        continue block0;
                    }
                    if (this.isIndented(token) || this.isNewline(token)) {
                        this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, token.getType().name(), token.getContent()));
                    } else {
                        this.eventBuilder.addToTextUnit(token.getContent());
                    }
                    token = this.parser.getNextToken();
                }
                continue;
            }
            if (this.isMaybeTranslatableHtmlBlock(token)) {
                if (this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.endTextUnit();
                }
                this.eventBuilder.addFilterEvents(this.processByHtmlFilter(token.getContent()));
                continue;
            }
            if (token.getType().equals((Object)MarkdownTokenType.HTML_INLINE)) {
                String tag = token.getContent();
                Matcher m = HTML_CDATA_PAT.matcher(tag);
                if (m.matches()) {
                    String cdataText = m.group(1);
                    if (!this.eventBuilder.isCurrentTextUnit()) {
                        this.eventBuilder.startTextUnit("");
                    }
                    this.eventBuilder.addToTextUnit(CDATA_START_CODE.clone());
                    this.eventBuilder.addToTextUnit(cdataText);
                    this.eventBuilder.addToTextUnit(CDATA_END_CODE.clone());
                    continue;
                }
                List<Event> subEvents = this.processByHtmlFilter(tag);
                for (Event e : subEvents) {
                    if (e.isTextUnit()) {
                        ITextUnit tu = e.getTextUnit();
                        if (tu.isReferent()) {
                            this.eventBuilder.addFilterEvent(e);
                            continue;
                        }
                        this.verifyOurTUAssumptions(tu, tag);
                        if (tu.getSkeleton() != null) {
                            if (this.eventBuilder.isCurrentTextUnit()) {
                                this.eventBuilder.endTextUnit();
                            }
                            this.eventBuilder.addFilterEvent(e);
                            continue;
                        }
                        if (!this.eventBuilder.isCurrentTextUnit()) {
                            this.eventBuilder.startTextUnit("");
                        }
                        for (TextPart tp : tu.getSource().getParts()) {
                            TextFragment tf = tp.text;
                            if (!TextFragment.MARKERS_REGEX.matcher(tf.getCodedText()).replaceAll("").isEmpty()) {
                                this.LOGGER.warn("TextFragment of a TextUnit generated for the HTML Inline tag \"{}\" has non-code text \"{}\". This is unexpected and non-code part will be discarded.", (Object)tag, (Object)tf.getText());
                            }
                            for (Code c : tf.getCodes()) {
                                c = c.clone();
                                c.setTagType(TextFragment.TagType.PLACEHOLDER);
                                this.eventBuilder.addToTextUnit(c);
                            }
                        }
                        continue;
                    }
                    if (e.isDocumentPart()) {
                        if (this.eventBuilder.isCurrentTextUnit()) {
                            this.eventBuilder.endTextUnit();
                        }
                        this.eventBuilder.addFilterEvent(e);
                        continue;
                    }
                    if (e.isStartSubfilter() || e.isEndSubfilter()) {
                        this.LOGGER.debug("{} event from HTML subfilter for \"{}\" being ignored.", (Object)e.getEventType().name(), (Object)tag);
                        continue;
                    }
                    this.LOGGER.warn("Unexpected {} event from HTML subfilter for \"{}\". Ignored.", (Object)e.getEventType().name(), (Object)tag);
                }
                continue;
            }
            if (this.isDocumentPart(token)) {
                if (this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.endTextUnit();
                }
                this.eventBuilder.addDocumentPart(token.getContent());
                continue;
            }
            if (this.isInlineMarkup(token)) {
                if (!this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.startTextUnit();
                }
                this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, token.getType().name(), token.getContent()));
                continue;
            }
            if (this.isCode(token)) {
                this.insertCodeOrDocPart(token.getType().name(), token.getContent());
                continue;
            }
            if (token.isTranslatable()) {
                if (!this.eventBuilder.isCurrentTextUnit()) {
                    this.eventBuilder.startTextUnit();
                }
                this.eventBuilder.addToTextUnit(token.getContent());
                continue;
            }
            this.eventBuilder.addDocumentPart(token.getContent());
        }
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.endTextUnit();
        }
        this.eventBuilder.flushRemainingTempEvents();
        this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
    }

    private void verifyOurTUAssumptions(ITextUnit tu, String tag) {
        if (tu.getAnnotations() != null && tu.getAnnotations().iterator().hasNext()) {
            this.LOGGER.error("TU has annotation(s): {}", (Object)tu.getAnnotations().toString());
        }
        if (tu.getSkeleton() != null && !tu.getSource().isEmpty()) {
            this.LOGGER.error("TU has a skeleton \"{}\" and a non-empty source \"{}\" at the same time.", (Object)tu.getSkeleton().toString(), (Object)tu.getSource().getFirstContent().toText());
        }
        if (tu.getSkeleton() != null && !tu.getSkeleton().toString().replaceAll(Pattern.quote("[#$") + ".*" + Pattern.quote("]"), "").equals(tag)) {
            this.LOGGER.error("TU skeleton \"{}\" doesn't match with the original tag \"{}\"", (Object)tu.getSkeleton().toString(), (Object)tag);
        }
    }

    private List<Event> processByHtmlFilter(String content) {
        String parentName;
        String parentId = this.eventBuilder.findMostRecentParentId();
        if (parentId == null) {
            parentId = this.getDocumentId().getLastId();
        }
        if ((parentName = this.eventBuilder.findMostRecentParentName()) == null) {
            parentName = this.getDocumentId().getLastId();
        }
        try (SubFilter htmlsf = new SubFilter(this.htmlFilter, this.getEncoderManager(), ++this.htmlSectionIndex, parentId, parentName);){
            List<Event> subEvents = htmlsf.getEvents(new RawDocument(content, this.getSrcLoc()));
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("---- Events from HTML subfilter for \"{}\". ----", (Object)content);
                FilterUtil.logDebugEvents(subEvents, this.LOGGER);
                this.LOGGER.debug("---- End of subfilter events ----");
            }
            List<Event> list = subEvents;
            return list;
        }
    }

    private void insertCodeOrDocPart(String type, String data) {
        if (this.eventBuilder.isCurrentTextUnit()) {
            this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, type, data));
        } else {
            this.eventBuilder.addDocumentPart(data);
        }
    }

    private boolean isCode(MarkdownToken token) {
        return token != null && !this.isNewline(token) && !token.isTranslatable() && !this.isMaybeTranslatableHtmlBlock(token) && !token.getType().equals((Object)MarkdownTokenType.TEXT);
    }

    private boolean isMaybeTranslatableHtmlBlock(MarkdownToken token) {
        if (token == null) {
            return false;
        }
        MarkdownTokenType ttype = token.getType();
        return ttype.equals((Object)MarkdownTokenType.HTML_BLOCK) || ttype.equals((Object)MarkdownTokenType.HTML_INNER_BLOCK);
    }

    private boolean isNewline(MarkdownToken token) {
        return token != null && (token.getType().equals((Object)MarkdownTokenType.SOFT_LINE_BREAK) || token.getType().equals((Object)MarkdownTokenType.HARD_LINE_BREAK) || token.getType().equals((Object)MarkdownTokenType.BLANK_LINE));
    }

    private boolean isDocumentPart(MarkdownToken token) {
        if (token == null) {
            return false;
        }
        MarkdownTokenType ttype = token.getType();
        return token != null && !token.isTranslatable() && (this.isNewline(token) || ttype.equals((Object)MarkdownTokenType.BULLET_LIST_ITEM) || ttype.equals((Object)MarkdownTokenType.ORDERED_LIST_ITEM) || ttype.equals((Object)MarkdownTokenType.FENCED_CODE_BLOCK) || ttype.equals((Object)MarkdownTokenType.FENCED_CODE_BLOCK_INFO) || ttype.equals((Object)MarkdownTokenType.HEADING_PREFIX) || ttype.equals((Object)MarkdownTokenType.HEADING_UNDERLINE) || ttype.equals((Object)MarkdownTokenType.THEMATIC_BREAK) || ttype.equals((Object)MarkdownTokenType.REFERENCE) || ttype.equals((Object)MarkdownTokenType.WHITE_SPACE) || ttype.equals((Object)MarkdownTokenType.TABLE_PIPE) || ttype.equals((Object)MarkdownTokenType.TABLE_SEPARATOR) || ttype.equals((Object)MarkdownTokenType.HTML_INNER_BLOCK_COMMENT) || ttype.equals((Object)MarkdownTokenType.HTML_COMMENT_BLOCK) || ttype.equals((Object)MarkdownTokenType.YAML_METADATA_HEADER));
    }

    private boolean isIndented(MarkdownToken token) {
        return token.getContent().startsWith("    ");
    }

    private boolean isInlineMarkup(MarkdownToken token) {
        if (token == null) {
            return false;
        }
        return token.getType().isInline();
    }
}

