/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown;

import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends StringParameters {
    private static final String HTML_SUBFILTER_CONFIG_PATH = "htmlSubfilter";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String TRANSLATE_URLS = "translateUrls";
    private static final String TRANSLATE_CODE_BLOCKS = "translateCodeBlocks";
    private static final String TRANSLATE_HEADER_METADATA = "translateHeaderMetadata";
    private static final String TRANSLATE_IMAGE_ALTTEXT = "translateImageAltText";
    private static final String URL_TO_TRANSLATE_PATTERN = "urlToTranslatePattern";
    private static final String NON_TRANSLATE_BLOCKS = "nonTranslateBlocks";
    private InlineCodeFinder codeFinder;

    public Parameters() {
        this.reset();
    }

    public String getHtmlSubfilter() {
        return this.getString(HTML_SUBFILTER_CONFIG_PATH);
    }

    public void setHtmlSubfilter(String htmlSubfilter) {
        this.setString(HTML_SUBFILTER_CONFIG_PATH, htmlSubfilter);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public boolean getTranslateUrls() {
        return this.getBoolean(TRANSLATE_URLS);
    }

    public void setTranslateUrls(boolean translateUrls) {
        this.setBoolean(TRANSLATE_URLS, translateUrls);
    }

    public String getUrlToTranslatePattern() {
        return this.getString(URL_TO_TRANSLATE_PATTERN);
    }

    public void setUrlToTranslatePattern(String urlToTranslatePattern) {
        this.setString(URL_TO_TRANSLATE_PATTERN, urlToTranslatePattern);
    }

    public boolean getTranslateCodeBlocks() {
        return this.getBoolean(TRANSLATE_CODE_BLOCKS);
    }

    public void setTranslateCodeBlocks(boolean translateCodeBlocks) {
        this.setBoolean(TRANSLATE_CODE_BLOCKS, translateCodeBlocks);
    }

    public boolean getTranslateHeaderMetadata() {
        return this.getBoolean(TRANSLATE_HEADER_METADATA);
    }

    public void setTranslateHeaderMetadata(boolean translateHeaderMetadata) {
        this.setBoolean(TRANSLATE_HEADER_METADATA, translateHeaderMetadata);
    }

    public boolean getTranslateImageAltText() {
        return this.getBoolean(TRANSLATE_IMAGE_ALTTEXT);
    }

    public void setTranslateImageAltText(boolean translateImageAltText) {
        this.setBoolean(TRANSLATE_IMAGE_ALTTEXT, translateImageAltText);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getNonTranslateBlocks() {
        return this.getString(NON_TRANSLATE_BLOCKS);
    }

    public void setNonTranslateBlocks(String nonTranslatableBlocks) {
        this.setString(NON_TRANSLATE_BLOCKS, nonTranslatableBlocks);
    }

    @Override
    public void reset() {
        super.reset();
        this.setHtmlSubfilter(null);
        this.setUseCodeFinder(false);
        this.setTranslateUrls(false);
        this.setUrlToTranslatePattern(".+");
        this.setTranslateCodeBlocks(true);
        this.setTranslateHeaderMetadata(false);
        this.setTranslateImageAltText(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("{{#test}} handle bar test {{/test}}\n{{stand-alone handle bar}}\n");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("\\{\\{[^}]+\\}\\}");
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

