/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.ChunkParser;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunBuilderSkipper;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleExclusionChecker;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockParser
extends ChunkParser<Block> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ElementSkipper defaultElementSkipper;
    private ElementSkipper blockPropertiesElementSkipper;
    private ElementSkipper insertedRunContentElementSkipper;
    private ElementSkipper deletedRunContentAndProofingErrorElementSkipper;
    private ElementSkipper bookmarkElementSkipper;
    private RunBuilderSkipper runBuilderSkipper;
    private BlockBuilder builder;
    private String paragraphStyle;

    BlockParser(StartElementContext startElementContext, IdGenerator nestedBlockIdGenerator, StyleDefinitions styleDefinitions) {
        super(startElementContext, nestedBlockIdGenerator, styleDefinitions);
        this.defaultElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), new ElementSkipper.SkippableElement[0]);
        this.blockPropertiesElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_LANGUAGE, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_DELETED_PARAGRAPH_MARK, ElementSkipper.RevisionPropertySkippableElement.PARAGRAPH_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTIES_CHANGE);
        this.insertedRunContentElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.RevisionInlineSkippableElement.RUN_INSERTED_CONTENT);
        this.deletedRunContentAndProofingErrorElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.RevisionInlineSkippableElement.RUN_DELETED_CONTENT, ElementSkipper.GeneralInlineSkippableElement.PROOFING_ERROR_ANCHOR);
        this.bookmarkElementSkipper = ElementSkipperFactory.createBookmarkElementSkipper(ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_START, ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_END);
        this.runBuilderSkipper = new RunBuilderSkipper();
        this.builder = new BlockBuilder();
    }

    private void addRunsToBuilder(BlockBuilder builder, RunMerger runMerger) throws XMLStreamException {
        for (Block.BlockChunk chunk : runMerger.getRuns()) {
            builder.addChunk(chunk);
        }
        runMerger.reset();
    }

    private void parseRunContainer(ChunkContainer chunkContainer, StartElement runContainerStart) throws XMLStreamException {
        RunContainer rc = new RunContainer();
        RunMerger runMerger = new RunMerger();
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (e.isEndElement() && runContainerStart.getName().equals(e.asEndElement().getName())) {
                rc.setStartElement(runContainerStart);
                rc.setEndElement(e.asEndElement());
                rc.setType(RunContainer.Type.fromValue(runContainerStart.getName().getLocalPart()));
                rc.addChunks(runMerger);
                chunkContainer.addChunk(rc);
                return;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(this.builder, runMerger, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isRunContainerStartEvent(e)) {
                rc.addChunks(runMerger);
                this.parseRunContainer(rc, e.asStartElement());
                continue;
            }
            if (!XMLEventHelpers.isRunContainerPropertiesStartEvent(e)) continue;
            StartElementContext rcPropertiesElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
            BlockProperties blockProperties = MarkupComponentParser.parseBlockProperties(rcPropertiesElementContext, ElementSkipperFactory.createGeneralElementSkipper(this.startElementContext.getConditionalParameters(), new ElementSkipper.SkippableElement[0]));
            rc.setProperties(blockProperties);
        }
        throw new IllegalStateException("Invalid content? Unterminated run container");
    }

    @Override
    public Block parse() throws XMLStreamException {
        this.log("startBlock: " + this.startElementContext.getStartElement());
        this.builder.addMarkupComponent(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), AttributeStripper.RevisionAttributeStripper.stripParagraphRevisionAttributes(this.startElementContext)));
        RunMerger runMerger = new RunMerger();
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                StartElementContext blockPropertiesElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                BlockProperties blockProperties = MarkupComponentParser.parseBlockProperties(blockPropertiesElementContext, this.blockPropertiesElementSkipper);
                if (!blockProperties.getProperties().isEmpty() || !blockProperties.getAttributes().isEmpty()) {
                    this.builder.addMarkupComponent(blockProperties);
                }
                this.paragraphStyle = this.getParagraphStyle(blockProperties);
                runMerger.setParagraphStyle(this.paragraphStyle);
                this.builder.setIsHidden(StyleExclusionChecker.isStyleExcluded(this.paragraphStyle, this.startElementContext.getConditionalParameters()));
                continue;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(this.builder, runMerger, e.asStartElement());
                continue;
            }
            if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e) && !runMerger.isEmpty()) {
                runMerger.append(this.startElementContext.getConditionalParameters().getLineSeparatorReplacement());
                this.defaultElementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
                continue;
            }
            if (XMLEventHelpers.isRunContainerStartEvent(e)) {
                StartElement runContainerStart = e.asStartElement();
                this.addRunsToBuilder(this.builder, runMerger);
                this.parseRunContainer(this.builder, runContainerStart);
                continue;
            }
            if (XMLEventHelpers.isSimpleFieldStartEvent(e)) {
                this.addRunsToBuilder(this.builder, runMerger);
                StartElementContext simpleFieldElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                for (XMLEvent fldEvent : XMLEventHelpers.gatherEvents(simpleFieldElementContext)) {
                    this.builder.addEvent(fldEvent);
                }
                this.builder.flushMarkup();
                continue;
            }
            if (this.processSkippableElements(e) || XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(this.builder, runMerger);
            if (e.isEndElement() && this.startElementContext.getStartElement().getName().equals(e.asEndElement().getName())) {
                this.builder.addMarkupComponent(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                this.log("End block: " + e);
                return this.builder.build();
            }
            this.builder.addEvent(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated paragraph");
    }

    private String getParagraphStyle(BlockProperties blockProperties) {
        Attribute paragraphLevelAttribute = blockProperties.getParagraphLevelAttribute();
        if (null != paragraphLevelAttribute) {
            return paragraphLevelAttribute.getValue();
        }
        BlockProperty paragraphStyleProperty = blockProperties.getParagraphStyleProperty();
        if (null != paragraphStyleProperty) {
            return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
        }
        return null;
    }

    private boolean processSkippableElements(XMLEvent event) throws XMLStreamException {
        if (event.isStartElement() && this.insertedRunContentElementSkipper.canSkip(event.asStartElement(), this.startElementContext.getStartElement())) {
            this.insertedRunContentElementSkipper.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext, ElementSkipper.InlineSkippableElement.class));
            return true;
        }
        if (ElementSkipper.GeneralElementSkipper.isInsertedRunContentEndElement(event)) {
            return true;
        }
        if (event.isStartElement() && this.deletedRunContentAndProofingErrorElementSkipper.canSkip(event.asStartElement(), this.startElementContext.getStartElement())) {
            this.deletedRunContentAndProofingErrorElementSkipper.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext));
            return true;
        }
        if (event.isStartElement() && this.bookmarkElementSkipper.canSkip(event.asStartElement(), null)) {
            this.bookmarkElementSkipper.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext));
            return true;
        }
        return false;
    }

    private void processRun(BlockBuilder blockBuilder, RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        StartElementContext runElementContext = StartElementContextFactory.createStartElementContext(startEl, this.startElementContext);
        RunBuilder runBuilder = new RunParser(runElementContext, this.nestedBlockIdGenerator, this.styleDefinitions, blockBuilder.isHidden()).parse();
        if (this.runBuilderSkipper.canSkip(runBuilder)) {
            return;
        }
        this.clarifyVisibility(runBuilder);
        blockBuilder.setRunName(startEl.getName());
        blockBuilder.setTextName(runBuilder.getTextName());
        runMerger.add(runBuilder);
    }

    private void clarifyVisibility(RunBuilder runBuilder) {
        if (this.startElementContext.getConditionalParameters().getTranslateWordHidden()) {
            return;
        }
        List<RunProperty> combinedRunProperties = this.styleDefinitions.getCombinedRunProperties(this.paragraphStyle, runBuilder.getRunStyle(), runBuilder.getRunProperties()).getProperties();
        for (RunProperty property : combinedRunProperties) {
            if (!XMLEventHelpers.WPML_PROPERTY_VANISH.getLocalPart().equals(property.getName().getLocalPart())) continue;
            if (property instanceof RunProperty.WpmlToggleRunProperty && !((RunProperty.WpmlToggleRunProperty)property).getToggleValue()) {
                return;
            }
            runBuilder.setHidden(true);
            return;
        }
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }

    private static class BlockBuilder
    implements ChunkContainer {
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private List<XMLEvent> currentMarkupComponentEvents = new ArrayList<XMLEvent>();
        private Markup markup = new Block.BlockMarkup();
        private boolean isHidden = false;
        private QName runName;
        private QName textName;

        BlockBuilder() {
        }

        boolean isHidden() {
            return this.isHidden;
        }

        void setIsHidden(boolean isHidden) {
            this.isHidden = isHidden;
        }

        void setRunName(QName runName) {
            if (this.runName == null) {
                this.runName = runName;
            }
        }

        void setTextName(QName textName) {
            if (this.textName == null) {
                this.textName = textName;
            }
        }

        private void flushMarkup() {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            if (!this.markup.getComponents().isEmpty()) {
                this.chunks.add(this.markup);
                this.markup = new Block.BlockMarkup();
            }
        }

        void addEvent(XMLEvent event) {
            this.currentMarkupComponentEvents.add(event);
        }

        @Override
        public void addChunk(Block.BlockChunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            this.markup.addComponent(markupComponent);
        }

        Block build() {
            this.flushMarkup();
            return new Block(this.chunks, this.runName, this.textName, this.isHidden);
        }
    }
}

