/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.PresentationNotesStyleDefinitions;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleDefinitionsParser;

class PresentationNotesStylesParser
implements StyleDefinitionsParser {
    private static final String UNEXPECTED_STRUCTURE = "Unexpected structure";
    private static final QName NOTES_STYLE = Namespaces.PresentationML.getQName("notesStyle");
    private static final QName DEFAULT_RPR = Namespaces.DrawingML.getQName("defRPr");
    private static final List<QName> paragraphLevelNames = Arrays.asList(Namespaces.DrawingML.getQName("lvl1pPr"), Namespaces.DrawingML.getQName("lvl2pPr"), Namespaces.DrawingML.getQName("lvl3pPr"), Namespaces.DrawingML.getQName("lvl4pPr"), Namespaces.DrawingML.getQName("lvl5pPr"), Namespaces.DrawingML.getQName("lvl6pPr"), Namespaces.DrawingML.getQName("lvl7pPr"), Namespaces.DrawingML.getQName("lvl8pPr"), Namespaces.DrawingML.getQName("lvl9pPr"));
    private static final int INVALID_PARAGRAPH_LEVEL_ID = -1;
    static final String DEFAULT_PARAGRAPH_LEVEL_ID = "0";
    private XMLEventFactory eventFactory;
    private XMLInputFactory inputFactory;
    private Reader reader;
    private ConditionalParameters conditionalParameters;

    PresentationNotesStylesParser(XMLEventFactory eventFactory, XMLInputFactory inputFactory, Reader reader, ConditionalParameters conditionalParameters) {
        this.eventFactory = eventFactory;
        this.inputFactory = inputFactory;
        this.reader = reader;
        this.conditionalParameters = conditionalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleDefinitions parse() throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(this.reader);
        Map<String, RunProperties> runPropertiesByParagraphLevelIds = null;
        try {
            while (eventReader.hasNext()) {
                StartElement element;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !NOTES_STYLE.equals((element = event.asStartElement()).getName())) continue;
                runPropertiesByParagraphLevelIds = this.parseNotesStyle(element, eventReader);
                break;
            }
        }
        finally {
            this.reader.close();
        }
        return new PresentationNotesStyleDefinitions(this.getExtraDocumentDefaultRunProperties(), runPropertiesByParagraphLevelIds);
    }

    private RunProperties getExtraDocumentDefaultRunProperties() {
        return new RunProperties.DefaultRunProperties(null, null, Collections.singletonList(RunPropertyFactory.createRunProperty(new QName(null, "baseline"), DEFAULT_PARAGRAPH_LEVEL_ID)));
    }

    private Map<String, RunProperties> parseNotesStyle(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
        HashMap<String, RunProperties> runPropertiesByParagraphLevelIds = new HashMap<String, RunProperties>(paragraphLevelNames.size());
        while (reader.hasNext()) {
            StartElement element;
            int paragraphLevelId;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                if (runPropertiesByParagraphLevelIds.isEmpty()) {
                    runPropertiesByParagraphLevelIds.put(DEFAULT_PARAGRAPH_LEVEL_ID, RunProperties.emptyRunProperties());
                }
                return runPropertiesByParagraphLevelIds;
            }
            if (!event.isStartElement() || -1 == (paragraphLevelId = this.getParagraphLevelIdByName((element = event.asStartElement()).getName()))) continue;
            runPropertiesByParagraphLevelIds.put(String.valueOf(paragraphLevelId), this.parseParagraphLevelRunProperties(element, reader));
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE);
    }

    private int getParagraphLevelIdByName(QName name) {
        for (int id = 0; id < paragraphLevelNames.size(); ++id) {
            QName paragraphLevel = paragraphLevelNames.get(id);
            if (!name.equals(paragraphLevel)) continue;
            return id;
        }
        return -1;
    }

    private RunProperties parseParagraphLevelRunProperties(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
        RunProperties runProperties = null;
        while (reader.hasNext()) {
            StartElement element;
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                if (null == runProperties) {
                    return RunProperties.emptyRunProperties();
                }
                return runProperties;
            }
            if (!event.isStartElement() || !DEFAULT_RPR.equals((element = event.asStartElement()).getName())) continue;
            runProperties = this.parseDefaultRunProperties(element, reader);
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE);
    }

    private RunProperties parseDefaultRunProperties(StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(startElement, eventReader, this.eventFactory, this.conditionalParameters);
        return new RunPropertiesParser(startElementContext).parse();
    }
}

