/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.verification.AbstractChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.Parameters;

public class InlineCodesChecker
extends AbstractChecker {
    @Override
    public void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        super.startProcess(sourceLocale, targetLocale, params, issues);
    }

    @Override
    public void processStartDocument(StartDocument sd, List<String> sigList) {
        super.processStartDocument(sd, sigList);
    }

    @Override
    public void processStartSubDocument(StartSubDocument ssd) {
        super.processStartSubDocument(ssd);
    }

    @Override
    public void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.getTrgLoc());
        if (trgCont == null) {
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null || !this.getParams().getCodeDifference()) continue;
            this.checkInlineCodes(srcSeg, trgSeg, tu, trgCont);
        }
        this.setAnnotationIds(srcCont, trgCont);
    }

    private ArrayList<Code> stripNoiseCodes(Segment seg) {
        ArrayList<Code> list = new ArrayList<Code>(seg.text.getCodes());
        Iterator<Code> iter = list.iterator();
        while (iter.hasNext()) {
            Code code = iter.next();
            if (this.getParams().getTypesToIgnore().indexOf(code.getType() + ";") == -1) continue;
            iter.remove();
        }
        return list;
    }

    private String buildCodeList(List<Code> list) {
        StringBuilder tmp = new StringBuilder();
        for (Code code : list) {
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            if (code.getData().isEmpty()) {
                tmp.append(code.getOuterData().replaceAll("></x>", "/>"));
                continue;
            }
            tmp.append("\"" + code.getData() + "\"");
        }
        return tmp.toString();
    }

    private String buildOpenCloseSequence(ArrayList<Code> list) {
        StringBuilder sb = new StringBuilder();
        for (Code code : list) {
            switch (code.getTagType()) {
                case OPENING: {
                    sb.append("o");
                    break;
                }
                case CLOSING: {
                    sb.append("c");
                    break;
                }
                case PLACEHOLDER: {
                    String tmp = code.getData();
                    int ch = 112;
                    if (!Util.isEmpty(tmp) && this.getParams().getGuessOpenClose()) {
                        if (tmp.startsWith("</")) {
                            ch = 99;
                        } else if (tmp.startsWith("<")) {
                            ch = 111;
                        }
                        if (tmp.endsWith("/>")) {
                            ch = 112;
                        }
                    }
                    sb.append((char)ch);
                }
            }
        }
        return sb.toString();
    }

    private void checkInlineCodes(Segment srcSeg, Segment trgSeg, ITextUnit tu, TextContainer trgCont) {
        Iterator<Code> iter;
        ArrayList<Code> srcList = this.stripNoiseCodes(srcSeg);
        ArrayList<Code> trgList = this.stripNoiseCodes(trgSeg);
        if (srcList.size() == 0 && trgList.size() == 0) {
            return;
        }
        String srcOC = this.buildOpenCloseSequence(srcList);
        String trgOC = this.buildOpenCloseSequence(trgList);
        boolean checkOC = true;
        Iterator<Code> srcIter = srcList.iterator();
        block0: while (srcIter.hasNext()) {
            Code srcCode = srcIter.next();
            Iterator<Code> trgIter = trgList.iterator();
            while (trgIter.hasNext()) {
                Code trgCode = trgIter.next();
                if (trgCode.getData().isEmpty() && srcCode.getData().isEmpty()) {
                    if (trgCode.getId() != srcCode.getId() || !trgCode.getType().equals(srcCode.getType())) continue;
                    trgIter.remove();
                    srcIter.remove();
                    continue block0;
                }
                if (!trgCode.getData().equals(srcCode.getData())) continue;
                trgIter.remove();
                srcIter.remove();
                continue block0;
            }
        }
        if (!srcList.isEmpty()) {
            iter = srcList.iterator();
            while (iter.hasNext()) {
                if (!this.getParams().missingCodesAllowed.contains(iter.next().getData())) continue;
                iter.remove();
            }
        }
        if (!srcList.isEmpty()) {
            this.addAnnotationAndReportIssue(IssueType.MISSING_CODE, tu, trgCont, srcSeg.getId(), "Missing placeholders in the target: " + this.buildCodeList(srcList), 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), srcList);
            checkOC = false;
        }
        if (!trgList.isEmpty()) {
            iter = trgList.iterator();
            while (iter.hasNext()) {
                if (!this.getParams().extraCodesAllowed.contains(iter.next().getData())) continue;
                iter.remove();
            }
        }
        if (!trgList.isEmpty()) {
            this.addAnnotationAndReportIssue(IssueType.EXTRA_CODE, tu, trgCont, srcSeg.getId(), "Extra placeholders in the target: " + this.buildCodeList(trgList), 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), trgList);
            checkOC = false;
        }
        if (checkOC) {
            int j = 0;
            boolean done = false;
            for (int i = 0; i < srcOC.length(); ++i) {
                block16: {
                    if (srcOC.charAt(i) == 'p') continue;
                    while (true) {
                        if (trgOC.length() <= j) {
                            this.addAnnotationAndReportIssue(IssueType.SUSPECT_CODE, tu, trgCont, srcSeg.getId(), "Suspect sequence of opening and closing target placeholders.", 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), trgList);
                            done = true;
                            break block16;
                        }
                        if (trgOC.charAt(j) != 'p') break;
                        ++j;
                    }
                    if (trgOC.charAt(j) != srcOC.charAt(i)) {
                        this.addAnnotationAndReportIssue(IssueType.SUSPECT_CODE, tu, trgCont, srcSeg.getId(), String.format("Suspect sequence of opening and closing placeholders in the target (placeholder %d).", i + 1), 0, -1, 0, -1, 50.0, srcSeg.toString(), trgSeg.toString(), trgList);
                        done = true;
                    } else {
                        ++j;
                    }
                }
                if (done) break;
            }
        }
    }
}

