/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.charlisting;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static String OUTPUTPATH = "outputPath";
    private static String AUTOOPEN = "autoOpen";

    public String getOutputPath() {
        return this.getString(OUTPUTPATH);
    }

    public void setOutputPath(String outputPath) {
        this.setString(OUTPUTPATH, outputPath);
    }

    public boolean isAutoOpen() {
        return this.getBoolean(AUTOOPEN);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.setBoolean(AUTOOPEN, autoOpen);
    }

    @Override
    public void reset() {
        super.reset();
        this.setOutputPath("charlist.txt");
        this.setAutoOpen(true);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OUTPUTPATH, "Path of the result file", "Full path of the result file.");
        desc.add(AUTOOPEN, "Open the result file after completion", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Used Characters Listing", true, false);
        PathInputPart part = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Result File", true);
        part.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        desc.addCheckboxPart(paramDesc.get(AUTOOPEN));
        return desc;
    }
}

