/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.whitespacecorrection;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrector;

@EditorFor(value=WhitespaceCorrectionStepParameters.class)
public class WhitespaceCorrectionStepParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PUNCTUATION = "punctuation";
    private static final String WHITESPACE = "whitespace";
    private EnumSet<WhitespaceCorrector.Punctuation> punctuation = EnumSet.allOf(WhitespaceCorrector.Punctuation.class);
    private EnumSet<WhitespaceCorrector.Whitespace> whitespace = WhitespaceCorrector.ALL_WHITESPACE;

    @Override
    public void reset() {
        super.reset();
        this.punctuation = EnumSet.allOf(WhitespaceCorrector.Punctuation.class);
        this.whitespace = WhitespaceCorrector.ALL_WHITESPACE;
    }

    public void setWhiteSpace(Collection<WhitespaceCorrector.Whitespace> whitespace) {
        this.whitespace.clear();
        for (WhitespaceCorrector.Whitespace w : whitespace) {
            this.whitespace.add(w);
        }
    }

    public void setPunctuation(Collection<WhitespaceCorrector.Punctuation> punctuation) {
        this.punctuation.clear();
        for (WhitespaceCorrector.Punctuation p : punctuation) {
            this.punctuation.add(p);
        }
    }

    public EnumSet<WhitespaceCorrector.Punctuation> getPunctuation() {
        return this.punctuation;
    }

    public EnumSet<WhitespaceCorrector.Whitespace> getWhitespace() {
        return this.whitespace;
    }

    @Override
    public String toString() {
        String ps = this.punctuation.stream().map(p -> p.toString()).collect(Collectors.joining(","));
        this.buffer.setString(PUNCTUATION, ps.toString());
        String ws = this.whitespace.stream().map(s -> s.toString()).collect(Collectors.joining(","));
        this.buffer.setString(WHITESPACE, ws);
        return super.toString();
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.loadPunctuation(this.buffer.getString(PUNCTUATION));
        this.loadWhitespace(this.buffer.getString(WHITESPACE));
    }

    private void loadPunctuation(String s) {
        if (s.equals("")) {
            return;
        }
        this.punctuation.clear();
        for (String ps : s.split(",")) {
            WhitespaceCorrector.Punctuation p = WhitespaceCorrector.Punctuation.valueOf(ps);
            if (ps == null) continue;
            this.punctuation.add(p);
        }
    }

    private void loadWhitespace(String s) {
        if (s.equals("")) {
            return;
        }
        this.whitespace.clear();
        for (String ws : s.split(",")) {
            WhitespaceCorrector.Whitespace w = WhitespaceCorrector.Whitespace.valueOf(ws);
            if (ws == null) continue;
            this.whitespace.add(w);
        }
    }

    public boolean getFullStop() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.FULL_STOP);
    }

    public void setFullStop(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.FULL_STOP, value);
    }

    public boolean getComma() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.COMMA);
    }

    public void setComma(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.COMMA, value);
    }

    public boolean getExclamationPoint() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.EXCLAMATION_MARK);
    }

    public void setExclamationPoint(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.EXCLAMATION_MARK, value);
    }

    public boolean getQuestionMark() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.QUESTION_MARK);
    }

    public void setQuestionMark(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.QUESTION_MARK, value);
    }

    private void set(WhitespaceCorrector.Punctuation p, boolean value) {
        if (value) {
            this.punctuation.add(p);
        } else {
            this.punctuation.remove((Object)p);
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("fullStop", "Full Stop", null);
        desc.add("comma", "Comma", null);
        desc.add("exclamationPoint", "Exclamation Point", null);
        desc.add("questionMark", "Question Mark", null);
        desc.add("verticalWhitespace", "Vertical White Space", null);
        desc.add("nonbreakingWhitespace", "Nonbreaking Whitespace", null);
        desc.add("horizontalTabs", "Horizontal Tabs", null);
        desc.add("space", "Standard White Space", null);
        desc.add("other", "All Other Whitespace", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Correct whitespace following", true, false);
        desc.addCheckboxPart(paramDesc.get("fullStop"));
        desc.addCheckboxPart(paramDesc.get("comma"));
        desc.addCheckboxPart(paramDesc.get("exclamationPoint"));
        desc.addCheckboxPart(paramDesc.get("questionMark"));
        desc.addSeparatorPart();
        desc.addTextLabelPart("Whitespace To Be Deleted");
        desc.addCheckboxPart(paramDesc.get("verticalWhitespace"));
        desc.addCheckboxPart(paramDesc.get("nonbreakingWhitespace"));
        desc.addCheckboxPart(paramDesc.get("horizontalTabs"));
        desc.addCheckboxPart(paramDesc.get("space"));
        desc.addCheckboxPart(paramDesc.get("other"));
        return desc;
    }
}

