/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.applications.tikal.logger.ILogHandler;
import net.sf.okapi.applications.tikal.logger.LogHandlerFactory;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UserConfiguration;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationEditor;
import net.sf.okapi.common.filters.IFilterConfigurationListEditor;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.apertium.ApertiumMTConnector;
import net.sf.okapi.connectors.bifile.BilingualFileConnector;
import net.sf.okapi.connectors.globalsight.GlobalSightTMConnector;
import net.sf.okapi.connectors.google.GoogleMTv2Connector;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.lingo24.Lingo24Connector;
import net.sf.okapi.connectors.microsoft.MicrosoftMTConnector;
import net.sf.okapi.connectors.mmt.MMTConnector;
import net.sf.okapi.connectors.mymemory.MyMemoryTMConnector;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.connectors.tda.Parameters;
import net.sf.okapi.connectors.tda.TDASearchConnector;
import net.sf.okapi.connectors.translatetoolkit.TranslateToolkitTMConnector;
import net.sf.okapi.filters.mosestext.FilterWriterParameters;
import net.sf.okapi.lib.merge.step.OriginalDocumentXliffMergerStep;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.RawDocumentWriterStep;
import net.sf.okapi.steps.formatconversion.FormatConversionStep;
import net.sf.okapi.steps.formatconversion.TableFilterWriterParameters;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.moses.ExtractionStep;
import net.sf.okapi.steps.moses.MergingParameters;
import net.sf.okapi.steps.moses.MergingStep;
import net.sf.okapi.steps.scopingreport.ScopingReportStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.wordcount.CharacterCountStep;
import net.sf.okapi.steps.wordcount.WordCountStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    protected static final int CMD_EXTRACT = 0;
    protected static final int CMD_MERGE = 1;
    protected static final int CMD_EDITCONFIG = 2;
    protected static final int CMD_QUERYTRANS = 3;
    protected static final int CMD_CONV2PO = 4;
    protected static final int CMD_CONV2TMX = 5;
    protected static final int CMD_CONV2TABLE = 6;
    protected static final int CMD_CONV2PEN = 7;
    protected static final int CMD_TRANSLATE = 8;
    protected static final int CMD_EXTRACTTOMOSES = 9;
    protected static final int CMD_LEVERAGEMOSES = 10;
    protected static final int CMD_SEGMENTATION = 11;
    protected static final int CMD_SHOWCONFIGS = 12;
    protected static final int CMD_REPORT = 14;
    private static final String DEFAULT_SEGRULES = "-";
    private static final String MSG_ONLYWITHUICOMP = "UI-based commands are available only in the distributions with UI components.";
    private static ILogHandler logHandler;
    protected ArrayList<String> inputs;
    protected String skeleton;
    protected String output;
    protected String specifiedConfigId;
    protected String specifiedConfigIdPath;
    protected String configId;
    protected String inputEncoding;
    protected String outputEncoding;
    protected LocaleId srcLoc;
    protected LocaleId trgLoc;
    protected int command = -1;
    protected String query;
    protected boolean useGoogleV2;
    protected String googleV2Params;
    protected boolean useTransToolkit;
    protected String transToolkitParams;
    protected boolean useGlobalSight;
    protected String globalSightParams;
    protected boolean useTDA;
    protected String tdaParams;
    protected boolean useMyMemory;
    protected String myMemoryParams;
    protected boolean useApertium;
    protected String apertiumParams;
    protected boolean usePensieve;
    protected String pensieveData;
    protected boolean useMicrosoft;
    protected String microsoftParams;
    protected boolean useBifile;
    protected boolean useLingo24;
    protected String lingo24Params;
    protected boolean useMMT;
    protected String mmtUrl;
    protected String mmtContext;
    protected String bifileData;
    protected boolean genericOutput = false;
    protected String tableConvFormat;
    protected String tableConvCodes;
    protected int convTargetStyle = 0;
    protected boolean convApprovedEntriesOnly = false;
    protected boolean convSkipEntriesWithoutText = true;
    protected boolean convOverwrite = false;
    protected String segRules;
    protected boolean showTraceHint = true;
    protected String tmOptions;
    protected boolean levOptFillTarget = true;
    protected String levOptTMXPath;
    protected boolean extOptCopy = true;
    protected boolean extOptAltTrans = true;
    protected boolean extOptCodeAttrs = false;
    protected boolean mosesCopyToTarget = false;
    protected boolean mosesOverwriteTarget = false;
    protected boolean moses2Outputs = false;
    protected boolean mosesUseGModeInAltTrans = true;
    protected boolean abortOnFailure = true;
    protected String mosesFromPath;
    protected String mosesFromPathParam;
    protected String mosesToPathParam;
    protected String skeletonDir;
    protected String outputDir;
    protected String rootDir = System.getProperty("user.dir");
    protected ExecutionContext context;
    protected String configPath = null;
    private FilterConfigurationMapper fcMapper;
    private Hashtable<String, String> extensionsMap;

    private static String getConsoleEncodingName() {
        String osName = System.getProperty("os.name");
        String enc = null;
        enc = osName.contains("OS X") ? "UTF-8" : (osName.startsWith("Windows") ? "cp850" : Charset.defaultCharset().name());
        UserConfiguration uc = new UserConfiguration();
        uc.load("Tikal");
        return uc.getProperty("displayEncoding", enc);
    }

    public static void main(String[] originalArgs) {
        StringBuilder sb = new StringBuilder();
        for (String st : originalArgs) {
            sb.append(st);
            sb.append(" ");
        }
        LOGGER.debug(sb.toString());
        Main prog = new Main();
        boolean useLogger = false;
        boolean showTrace = false;
        try {
            ArrayList<String> args = new ArrayList<String>();
            for (String tmp : originalArgs) {
                if (tmp.length() <= 0) continue;
                args.add(tmp);
            }
            if (args.contains("-trace")) {
                showTrace = true;
            }
            if (args.contains("-logger")) {
                useLogger = true;
            }
            if (!useLogger) {
                PrintStream ps = new PrintStream((OutputStream)System.out, true, Main.getConsoleEncodingName());
                logHandler = LogHandlerFactory.getLogHandler();
                logHandler.initialize(ps);
                if (showTrace) {
                    logHandler.setLogLevel(1);
                }
            }
            prog.printBanner();
            if (args.size() == 0) {
                prog.printUsage();
                return;
            }
            if (args.contains("-?")) {
                prog.printUsage();
                return;
            }
            if (args.contains("-h") || args.contains("--help") || args.contains("-help")) {
                prog.showHelp();
                return;
            }
            if (args.contains("-i") || args.contains("--info") || args.contains("-info")) {
                prog.showInfo();
                return;
            }
            prog.transToolkitParams = "https://amagama-live.translatehouse.org/api/v1/";
            for (int i = 0; i < args.size(); ++i) {
                String arg = (String)args.get(i);
                if (arg.equals("-fc")) {
                    prog.specifiedConfigId = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-sl")) {
                    prog.srcLoc = LocaleId.fromString(prog.getArgument(args, ++i));
                    continue;
                }
                if (arg.equals("-tl")) {
                    prog.trgLoc = LocaleId.fromString(prog.getArgument(args, ++i));
                    continue;
                }
                if (arg.equals("-ie")) {
                    prog.inputEncoding = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-oe")) {
                    prog.outputEncoding = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-od")) {
                    prog.outputDir = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-sd")) {
                    prog.skeletonDir = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-rd")) {
                    prog.rootDir = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-pd")) {
                    prog.specifiedConfigIdPath = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-x")) {
                    prog.command = 0;
                    continue;
                }
                if (arg.equals("-x1")) {
                    prog.command = 0;
                    continue;
                }
                if (arg.equals("-xm")) {
                    prog.command = 9;
                    continue;
                }
                if (arg.equals("-2")) {
                    prog.moses2Outputs = true;
                    continue;
                }
                if (arg.equals("-t")) {
                    prog.command = 8;
                    continue;
                }
                if (arg.equals("-m")) {
                    prog.command = 1;
                    continue;
                }
                if (arg.equals("-m1")) {
                    prog.command = 1;
                    continue;
                }
                if (arg.equals("-lm")) {
                    prog.command = 10;
                    continue;
                }
                if (arg.equals("-totrg")) {
                    prog.mosesCopyToTarget = true;
                    prog.mosesOverwriteTarget = false;
                    continue;
                }
                if (arg.equals("-overtrg")) {
                    prog.mosesCopyToTarget = true;
                    prog.mosesOverwriteTarget = true;
                    continue;
                }
                if (arg.equals("-bpt")) {
                    prog.mosesUseGModeInAltTrans = false;
                    continue;
                }
                if (arg.equals("-over")) {
                    prog.convOverwrite = true;
                    continue;
                }
                if (arg.equals("-from")) {
                    prog.mosesFromPathParam = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-to")) {
                    prog.mosesToPathParam = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-2po")) {
                    prog.command = 4;
                    continue;
                }
                if (arg.equals("-2tmx")) {
                    prog.command = 5;
                    continue;
                }
                if (arg.equals("-2tbl")) {
                    prog.command = 6;
                    continue;
                }
                if (arg.equals("-csv")) {
                    prog.tableConvFormat = "csv";
                    continue;
                }
                if (arg.equals("-tab")) {
                    prog.tableConvFormat = "tab";
                    continue;
                }
                if (arg.equals("-xliff")) {
                    prog.tableConvCodes = "xliff";
                    continue;
                }
                if (arg.equals("-xliffgx")) {
                    prog.tableConvCodes = "xliffgx";
                    continue;
                }
                if (arg.equals("-tmx")) {
                    prog.tableConvCodes = "tmx";
                    continue;
                }
                if (arg.equals("-all")) {
                    prog.convSkipEntriesWithoutText = false;
                    continue;
                }
                if (arg.equals("-approved")) {
                    prog.convApprovedEntriesOnly = true;
                    continue;
                }
                if (arg.equals("-nofill")) {
                    prog.levOptFillTarget = false;
                    continue;
                }
                if (arg.equals("-nocopy")) {
                    prog.extOptCopy = false;
                    continue;
                }
                if (arg.equals("-noalttrans")) {
                    prog.extOptAltTrans = false;
                    continue;
                }
                if (arg.equals("-codeattrs")) {
                    prog.extOptCodeAttrs = true;
                    continue;
                }
                if (arg.equals("-maketmx")) {
                    prog.levOptTMXPath = "pretrans.tmx";
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.levOptTMXPath = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-trgsource")) {
                    prog.convTargetStyle = 1;
                    continue;
                }
                if (arg.equals("-trgempty")) {
                    prog.convTargetStyle = 2;
                    continue;
                }
                if (arg.equals("-imp")) {
                    prog.command = 7;
                    prog.pensieveData = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-exp")) {
                    prog.command = 5;
                    prog.specifiedConfigId = "okf_pensieve";
                    continue;
                }
                if (arg.equals("-e")) {
                    prog.command = 2;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.specifiedConfigId = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-generic")) {
                    prog.genericOutput = true;
                    prog.tableConvCodes = "generic";
                    continue;
                }
                if (arg.equals("-q")) {
                    prog.command = 3;
                    prog.query = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-opt")) {
                    prog.tmOptions = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-gg") || arg.equals("-google")) {
                    prog.useGoogleV2 = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.googleV2Params = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-tt")) {
                    prog.useTransToolkit = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.transToolkitParams = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-gs")) {
                    prog.useGlobalSight = true;
                    prog.globalSightParams = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-tda")) {
                    prog.useTDA = true;
                    prog.tdaParams = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-ms")) {
                    prog.useMicrosoft = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.microsoftParams = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-apertium")) {
                    prog.useApertium = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.apertiumParams = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-mm")) {
                    prog.useMyMemory = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.myMemoryParams = prog.getArgument(args, ++i);
                    continue;
                }
                if (arg.equals("-pen")) {
                    prog.usePensieve = true;
                    prog.pensieveData = "http://localhost:8080";
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.pensieveData = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-bi")) {
                    prog.useBifile = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.bifileData = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-lingo24")) {
                    prog.useLingo24 = true;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.lingo24Params = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-mmt")) {
                    prog.useMMT = true;
                    prog.mmtUrl = prog.getArgument(args, ++i);
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.mmtContext = (String)args.get(++i);
                    continue;
                }
                if (arg.endsWith("-listconf") || arg.equals("-lfc")) {
                    prog.command = 12;
                    continue;
                }
                if (arg.equals("-s")) {
                    prog.command = 11;
                    prog.segRules = DEFAULT_SEGRULES;
                    continue;
                }
                if (arg.equals("-seg")) {
                    prog.segRules = DEFAULT_SEGRULES;
                    if (args.size() <= i + 1 || ((String)args.get(i + 1)).startsWith(DEFAULT_SEGRULES)) continue;
                    prog.segRules = (String)args.get(++i);
                    continue;
                }
                if (arg.equals("-trace") || arg.equals("-logger")) continue;
                if (arg.equals("-continue")) {
                    prog.abortOnFailure = false;
                    continue;
                }
                if (arg.equals("-safe")) {
                    prog.context.setIsNoPrompt(false);
                    continue;
                }
                if (arg.equals("-sr")) {
                    prog.command = 14;
                    continue;
                }
                if (!arg.startsWith(DEFAULT_SEGRULES)) {
                    prog.inputs.add((String)args.get(i));
                    continue;
                }
                prog.showTraceHint = false;
                throw new InvalidParameterException(String.format("Invalid command-line argument '%s'.", args.get(i)));
            }
            if (prog.specifiedConfigId != null) {
                String cfgPath = Util.getDirectoryName(prog.specifiedConfigId);
                if (!cfgPath.isEmpty()) {
                    prog.specifiedConfigIdPath = cfgPath;
                    prog.specifiedConfigId = Util.getFilename(prog.specifiedConfigId, true);
                }
                if (prog.specifiedConfigId.endsWith(".fprm")) {
                    prog.specifiedConfigId = Util.getFilename(prog.specifiedConfigId, false);
                }
            }
            if (prog.command == -1) {
                LOGGER.warn("No command specified. Please use one of the command described below:");
                prog.printUsage();
                return;
            }
            if (prog.command == 2) {
                if (prog.specifiedConfigId == null) {
                    prog.editAllConfigurations();
                } else {
                    prog.editConfiguration();
                }
                return;
            }
            if (prog.command == 12) {
                prog.showAllConfigurations();
                return;
            }
            if (prog.command == 3) {
                prog.processQuery();
                return;
            }
            if (prog.command == 14) {
                prog.printScopingReport();
                return;
            }
            if (prog.inputs.size() == 0) {
                throw new OkapiException("No input document specified.");
            }
            Timer timer = new Timer();
            int errorCount = 0;
            for (int i = 0; i < prog.inputs.size(); ++i) {
                if (i > 0) {
                    Main.displayDivider();
                }
                try {
                    prog.process(prog.inputs.get(i), args);
                    continue;
                }
                catch (Throwable e) {
                    Main.displayError(e, showTrace, prog.showTraceHint);
                    if (prog.abortOnFailure) {
                        System.exit(1);
                        continue;
                    }
                    ++errorCount;
                }
            }
            if (prog.inputs.size() > 1) {
                Main.displayDivider();
                Main.displaySummary(prog.inputs.size(), errorCount, timer);
            }
        }
        catch (Throwable e) {
            Main.displayError(e, showTrace, prog.showTraceHint);
            System.exit(1);
        }
    }

    private static void displayDivider() {
        LOGGER.info("------------------------------------------------------------");
    }

    private static void displaySummary(int fileCount, int errorCount, Timer t) {
        LOGGER.info("Files: " + fileCount + ", Errors: " + errorCount + ", Time: " + t);
    }

    private static void displayError(Throwable e, boolean showTrace, boolean showTraceHint) {
        if (showTrace) {
            e.printStackTrace();
        } else {
            LOGGER.error(e.getMessage());
            Throwable e2 = e.getCause();
            if (e2 != null) {
                LOGGER.error(e2.getMessage());
            }
            if (showTraceHint) {
                LOGGER.info("You can use the -trace option for more details.");
            }
        }
    }

    public Main() {
        this.inputs = new ArrayList();
        this.context = new ExecutionContext();
        this.context.setApplicationName("Tikal");
        this.context.setIsNoPrompt(true);
    }

    protected String getArgument(List<String> args, int index) {
        if (index >= args.size()) {
            this.showTraceHint = false;
            throw new OkapiException(String.format("Missing parameter after '%s'", args.get(index - 1)));
        }
        return args.get(index);
    }

    private void initialize() {
        this.fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(this.fcMapper, false, true);
        this.extensionsMap = new Hashtable();
        this.extensionsMap.put(".docx", "okf_openxml");
        this.extensionsMap.put(".pptx", "okf_openxml");
        this.extensionsMap.put(".xlsx", "okf_openxml");
        this.extensionsMap.put(".odt", "okf_openoffice");
        this.extensionsMap.put(".swx", "okf_openoffice");
        this.extensionsMap.put(".ods", "okf_openoffice");
        this.extensionsMap.put(".swc", "okf_openoffice");
        this.extensionsMap.put(".odp", "okf_openoffice");
        this.extensionsMap.put(".sxi", "okf_openoffice");
        this.extensionsMap.put(".odg", "okf_openoffice");
        this.extensionsMap.put(".sxd", "okf_openoffice");
        this.extensionsMap.put(".htm", "okf_html");
        this.extensionsMap.put(".html", "okf_html");
        this.extensionsMap.put(".xlf", "okf_xliff");
        this.extensionsMap.put(".xlif", "okf_xliff");
        this.extensionsMap.put(".xliff", "okf_xliff");
        this.extensionsMap.put(".tmx", "okf_tmx");
        this.extensionsMap.put(".properties", "okf_properties");
        this.extensionsMap.put(".lang", "okf_properties-skypeLang");
        this.extensionsMap.put(".po", "okf_po");
        this.extensionsMap.put(".xml", "okf_xml");
        this.extensionsMap.put(".resx", "okf_xml-resx");
        this.extensionsMap.put(".srt", "okf_regex-srt");
        this.extensionsMap.put(".dtd", "okf_dtd");
        this.extensionsMap.put(".ent", "okf_dtd");
        this.extensionsMap.put(".ts", "okf_ts");
        this.extensionsMap.put(".txt", "okf_plaintext");
        this.extensionsMap.put(".csv", "okf_table_csv");
        this.extensionsMap.put(".ttx", "okf_ttx");
        this.extensionsMap.put(".json", "okf_json");
        this.extensionsMap.put(".pentm", "okf_pensieve");
        this.extensionsMap.put(".yml", "okf_yaml");
        this.extensionsMap.put(".idml", "okf_idml");
        this.extensionsMap.put(".mif", "okf_mif");
        this.extensionsMap.put(".txp", "okf_transifex");
        this.extensionsMap.put(".rtf", "okf_tradosrtf");
        this.extensionsMap.put(".zip", "okf_archive");
        this.extensionsMap.put(".txml", "okf_txml");
        this.extensionsMap.put(".md", "okf_markdown");
        if (this.specifiedConfigIdPath != null) {
            this.fcMapper.setCustomConfigurationsDirectory(this.specifiedConfigIdPath);
        }
        this.loadFromPluginsAndUpdate();
    }

    private String getConfigurationId(String ext) {
        String id = this.extensionsMap.get(ext);
        if (id == null) {
            throw new OkapiException(String.format("Could not guess the configuration for the extension '%s'", ext));
        }
        return id;
    }

    private void editAllConfigurations() {
        this.initialize();
        this.guessMissingLocales(null);
        this.fcMapper.updateCustomConfigurations();
        try {
            IFilterConfigurationListEditor editor = (IFilterConfigurationListEditor)Class.forName("net.sf.okapi.common.ui.filters.FilterConfigurationEditor").newInstance();
            editor.editConfigurations(this.fcMapper);
        }
        catch (InstantiationException e) {
            throw new OkapiException(MSG_ONLYWITHUICOMP);
        }
        catch (IllegalAccessException e) {
            throw new OkapiException(MSG_ONLYWITHUICOMP);
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException(MSG_ONLYWITHUICOMP);
        }
    }

    private void editConfiguration() {
        this.initialize();
        this.guessMissingLocales(null);
        if (this.specifiedConfigId == null) {
            throw new OkapiException("You must specified the configuration to edit.");
        }
        this.configId = this.specifiedConfigId;
        if (!this.prepareFilter(this.configId)) {
            return;
        }
        try {
            IFilterConfigurationEditor editor = (IFilterConfigurationEditor)Class.forName("net.sf.okapi.common.ui.filters.FilterConfigurationEditor").newInstance();
            editor.editConfiguration(this.configId, this.fcMapper);
        }
        catch (InstantiationException e) {
            throw new OkapiException(MSG_ONLYWITHUICOMP);
        }
        catch (IllegalAccessException e) {
            throw new OkapiException(MSG_ONLYWITHUICOMP);
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException(MSG_ONLYWITHUICOMP);
        }
    }

    private void showAllConfigurations() {
        this.initialize();
        this.fcMapper.updateCustomConfigurations();
        LOGGER.info("List of all filter configurations available:");
        Iterator<FilterConfiguration> iter = this.fcMapper.getAllConfigurations();
        while (iter.hasNext()) {
            FilterConfiguration config = iter.next();
            LOGGER.info(" - {} = {}", (Object)config.configId, (Object)config.description);
        }
    }

    private boolean prepareFilter(String configId) {
        if (this.fcMapper.getConfiguration(configId) != null) {
            return true;
        }
        Iterator<FilterConfiguration> configs = this.fcMapper.getAllConfigurations();
        while (configs.hasNext()) {
            FilterConfiguration fc = configs.next();
            if (!configId.startsWith(fc.configId)) continue;
            if (this.fcMapper.getConfiguration(configId) == null) {
                this.fcMapper.addCustomConfiguration(configId);
            }
            return true;
        }
        LOGGER.error("Could not guess the filter for the configuration '{}'", (Object)configId);
        return false;
    }

    private void loadFromPluginsAndUpdate() {
        PluginsManager mgt = new PluginsManager();
        mgt.discover(new File(this.getAppRootDirectory() + File.separator + "dropins"), true);
        this.fcMapper.addFromPlugins(mgt);
    }

    private void guessMissingLocales(String inputPath) {
        List<String> guessed;
        if (this.srcLoc != null && this.trgLoc != null) {
            return;
        }
        if (inputPath != null && (guessed = FileUtil.guessLanguages(inputPath)).size() > 0) {
            if (this.srcLoc == null) {
                this.srcLoc = LocaleId.fromString(guessed.get(0));
            }
            if (guessed.size() > 1 && this.trgLoc == null) {
                this.trgLoc = LocaleId.fromString(guessed.get(1));
            }
        }
        if (this.srcLoc == null) {
            this.srcLoc = LocaleId.fromString("en");
        }
        if (this.trgLoc == null) {
            this.trgLoc = new LocaleId(Locale.getDefault());
            if (this.trgLoc.sameLanguageAs(this.srcLoc)) {
                this.trgLoc = LocaleId.fromString("fr");
            }
        }
    }

    private void guessMissingParameters(String inputOfConfig) {
        if (this.specifiedConfigId == null) {
            String ext = Util.getExtension(inputOfConfig);
            if (Util.isEmpty(ext)) {
                throw new OkapiException(String.format("The input file '%s' has no extension to guess the filter from.", inputOfConfig));
            }
            this.configId = this.getConfigurationId(ext.toLowerCase());
        } else {
            this.configId = this.specifiedConfigId;
        }
        this.guessMissingEncodings();
    }

    private void guessMissingEncodings() {
        if (this.outputEncoding == null) {
            this.outputEncoding = this.inputEncoding != null ? this.inputEncoding : Charset.defaultCharset().name();
        }
        if (this.inputEncoding == null) {
            this.inputEncoding = Charset.defaultCharset().name();
        }
    }

    String pathChangeFolder(String newFolder, String oldPath) {
        String result;
        if (newFolder == null) {
            result = oldPath;
        } else {
            File file = new File(newFolder, Util.getFilename(oldPath, true));
            result = file.toString();
        }
        return result;
    }

    String pathInsertOutBeforeExt(String oldPath) {
        String ext = Util.getExtension(oldPath);
        int n = oldPath.lastIndexOf(46);
        if (n == -1) {
            return oldPath + ".out";
        }
        return oldPath.substring(0, n) + ".out" + ext;
    }

    private void guessMergingArguments(String input) {
        String ext = Util.getExtension(input);
        if (!ext.equals(".xlf")) {
            throw new OkapiException(String.format("The input file '%s' does not have the expected .xlf extension.", input));
        }
        int n = input.lastIndexOf(46);
        this.skeleton = input.substring(0, n);
        this.output = this.outputDir == null ? this.pathInsertOutBeforeExt(this.skeleton) : this.pathChangeFolder(this.outputDir, this.skeleton);
        this.skeleton = this.pathChangeFolder(this.skeletonDir, this.skeleton);
    }

    private void guessMergingMosesArguments(String input) {
        this.mosesFromPath = !Util.isEmpty(this.mosesFromPathParam) ? this.mosesFromPathParam : input + "." + this.trgLoc.toString();
        this.output = !Util.isEmpty(this.mosesToPathParam) ? this.mosesToPathParam : this.pathInsertOutBeforeExt(input);
    }

    /*
     * Unable to fully structure code
     */
    protected void process(String input, List<String> args) throws URISyntaxException {
        timer = new Timer();
        this.initialize();
        this.fcMapper.updateCustomConfigurations();
        switch (this.command) {
            case 8: {
                Main.LOGGER.info("Translation");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                file = new File(input);
                rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                var6_15 = null;
                rd.setFilterConfigId(this.configId);
                this.translateFile(rd);
                if (rd == null) break;
                if (var6_15 == null) ** GOTO lbl25
                try {
                    rd.close();
                }
                catch (Throwable var7_20) {
                    var6_15.addSuppressed(var7_20);
                }
                break;
lbl25:
                // 1 sources

                rd.close();
                break;
                catch (Throwable var7_21) {
                    try {
                        var6_15 = var7_21;
                        throw var7_21;
                    }
                    catch (Throwable var8_29) {
                        if (rd != null) {
                            if (var6_15 != null) {
                                try {
                                    rd.close();
                                }
                                catch (Throwable var9_32) {
                                    var6_15.addSuppressed(var9_32);
                                }
                            } else {
                                rd.close();
                            }
                        }
                        throw var8_29;
                    }
                }
            }
            case 11: {
                Main.LOGGER.info("Segmentation");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                file = new File(input);
                rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                var6_16 = null;
                rd.setFilterConfigId(this.configId);
                this.segmentFile(rd);
                if (rd == null) break;
                if (var6_16 == null) ** GOTO lbl62
                try {
                    rd.close();
                }
                catch (Throwable var7_22) {
                    var6_16.addSuppressed(var7_22);
                }
                break;
lbl62:
                // 1 sources

                rd.close();
                break;
                catch (Throwable var7_23) {
                    try {
                        var6_16 = var7_23;
                        throw var7_23;
                    }
                    catch (Throwable var10_35) {
                        if (rd != null) {
                            if (var6_16 != null) {
                                try {
                                    rd.close();
                                }
                                catch (Throwable var11_39) {
                                    var6_16.addSuppressed(var11_39);
                                }
                            } else {
                                rd.close();
                            }
                        }
                        throw var10_35;
                    }
                }
            }
            case 0: {
                Main.LOGGER.info("Extraction");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                file = new File(input);
                rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                var6_17 = null;
                rd.setFilterConfigId(this.configId);
                this.extractFile(rd);
                if (rd == null) break;
                if (var6_17 == null) ** GOTO lbl99
                try {
                    rd.close();
                }
                catch (Throwable var7_24) {
                    var6_17.addSuppressed(var7_24);
                }
                break;
lbl99:
                // 1 sources

                rd.close();
                break;
                catch (Throwable var7_25) {
                    try {
                        var6_17 = var7_25;
                        throw var7_25;
                    }
                    catch (Throwable var12_41) {
                        if (rd != null) {
                            if (var6_17 != null) {
                                try {
                                    rd.close();
                                }
                                catch (Throwable var13_44) {
                                    var6_17.addSuppressed(var13_44);
                                }
                            } else {
                                rd.close();
                            }
                        }
                        throw var12_41;
                    }
                }
            }
            case 9: {
                Main.LOGGER.info("Extraction to Moses InlineText");
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                file = new File(input);
                rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                var6_18 = null;
                rd.setFilterConfigId(this.configId);
                this.extractFileToMoses(rd);
                if (rd == null) break;
                if (var6_18 == null) ** GOTO lbl136
                try {
                    rd.close();
                }
                catch (Throwable var7_26) {
                    var6_18.addSuppressed(var7_26);
                }
                break;
lbl136:
                // 1 sources

                rd.close();
                break;
                catch (Throwable var7_27) {
                    try {
                        var6_18 = var7_27;
                        throw var7_27;
                    }
                    catch (Throwable var14_45) {
                        if (rd != null) {
                            if (var6_18 != null) {
                                try {
                                    rd.close();
                                }
                                catch (Throwable var15_46) {
                                    var6_18.addSuppressed(var15_46);
                                }
                            } else {
                                rd.close();
                            }
                        }
                        throw var14_45;
                    }
                }
            }
            case 1: {
                Main.LOGGER.info("Merging");
                this.guessMergingArguments(input);
                this.guessMissingLocales(input);
                this.guessMissingParameters(this.skeleton);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                Main.LOGGER.info("Source language: {}", (Object)this.srcLoc);
                Main.LOGGER.info("Target language: {}", (Object)this.trgLoc);
                Main.LOGGER.info("Default input encoding: {}", (Object)this.inputEncoding);
                Main.LOGGER.info("Output encoding: {}", (Object)this.outputEncoding);
                Main.LOGGER.info("Filter configuration: {}", (Object)this.configId);
                Main.LOGGER.info("XLIFF: {}", (Object)input);
                Main.LOGGER.info("Output: {}", (Object)(this.output == null ? "<auto-defined>" : this.output));
                originalDoc = new RawDocument(Util.toURI(this.skeleton), this.inputEncoding, this.srcLoc, this.trgLoc);
                originalDoc.setFilterConfigId(this.configId);
                driver = new PipelineDriver();
                driver.setFilterConfigurationMapper(this.fcMapper);
                bic = new BatchItemContext(new RawDocument(Util.toURI(input), StandardCharsets.UTF_8.name(), this.srcLoc, this.trgLoc), Util.toURI(this.output), this.outputEncoding, new RawDocument[]{originalDoc});
                driver.addBatchItem(bic);
                driver.addStep(new OriginalDocumentXliffMergerStep());
                driver.addStep(new RawDocumentWriterStep());
                driver.processBatch();
                driver.destroy();
                break;
            }
            case 10: {
                Main.LOGGER.info("Merging Moses InlineText");
                this.guessMissingLocales(input);
                this.guessMergingMosesArguments(input);
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                file = new File(input);
                rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc, this.configId);
                var9_33 = null;
                this.leverageFileWithMoses(rd);
                if (rd == null) break;
                if (var9_33 == null) ** GOTO lbl198
                try {
                    rd.close();
                }
                catch (Throwable var10_36) {
                    var9_33.addSuppressed(var10_36);
                }
                break;
lbl198:
                // 1 sources

                rd.close();
                break;
                catch (Throwable var10_37) {
                    try {
                        var9_33 = var10_37;
                        throw var10_37;
                    }
                    catch (Throwable var16_47) {
                        if (rd != null) {
                            if (var9_33 != null) {
                                try {
                                    rd.close();
                                }
                                catch (Throwable var17_48) {
                                    var9_33.addSuppressed(var17_48);
                                }
                            } else {
                                rd.close();
                            }
                        }
                        throw var16_47;
                    }
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (this.command == 4) {
                    Main.LOGGER.info("Conversion to PO");
                } else if (this.command == 5) {
                    Main.LOGGER.info("Conversion to TMX");
                } else if (this.command == 6) {
                    Main.LOGGER.info("Conversion to Table");
                } else {
                    Main.LOGGER.info("Importing to Pensieve TM");
                }
                this.guessMissingParameters(input);
                if (!this.prepareFilter(this.configId)) {
                    return;
                }
                this.guessMissingLocales(input);
                file = new File(input);
                output = input;
                output = this.command == 4 ? output + ".po" : (this.command == 5 ? output + ".tmx" : (this.command == 6 ? output + ".txt" : this.checkPensieveDirExtension()));
                outputURI = new File(output).toURI();
                rd = new RawDocument(file.toURI(), this.inputEncoding, this.srcLoc, this.trgLoc);
                var11_40 = null;
                rd.setFilterConfigId(this.configId);
                Main.LOGGER.info("Source language: {}", (Object)this.srcLoc);
                Main.LOGGER.info("Target language: {}", (Object)this.trgLoc);
                Main.LOGGER.info("Default input encoding: {}", (Object)this.inputEncoding);
                Main.LOGGER.info("Filter configuration: {}", (Object)this.configId);
                Main.LOGGER.info("Output: {}", (Object)output);
                this.convertFile(rd, outputURI);
                if (rd == null) break;
                if (var11_40 == null) ** GOTO lbl252
                try {
                    rd.close();
                }
                catch (Throwable var12_42) {
                    var11_40.addSuppressed(var12_42);
                }
                break;
lbl252:
                // 1 sources

                rd.close();
                break;
                catch (Throwable var12_43) {
                    try {
                        var11_40 = var12_43;
                        throw var12_43;
                    }
                    catch (Throwable var18_49) {
                        if (rd != null) {
                            if (var11_40 != null) {
                                try {
                                    rd.close();
                                }
                                catch (Throwable var19_50) {
                                    var11_40.addSuppressed(var19_50);
                                }
                            } else {
                                rd.close();
                            }
                        }
                        throw var18_49;
                    }
                }
            }
        }
        Main.LOGGER.info("Done in " + timer);
    }

    private void printBanner() {
        if (this.getClass().getPackage() == null) {
            return;
        }
        LOGGER.info("-------------------------------------------------------------------------------");
        LOGGER.info("Okapi Tikal - Localization Toolset");
        LOGGER.info("Version: {}", (Object)this.getClass().getPackage().getImplementationVersion());
        LOGGER.info("-------------------------------------------------------------------------------");
    }

    private void showInfo() {
        Runtime rt = Runtime.getRuntime();
        rt.runFinalization();
        rt.gc();
        LOGGER.info("Java version: {}", (Object)System.getProperty("java.version"));
        LOGGER.info("Platform: {}, {}, {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")});
        NumberFormat nf = NumberFormat.getInstance();
        LOGGER.info("Java VM memory: free={} KB, total={} KB", (Object)nf.format(rt.freeMemory() / 1024L), (Object)nf.format(rt.totalMemory() / 1024L));
        LOGGER.info("Tikal display encoding: {}", (Object)Main.getConsoleEncodingName());
        LOGGER.info("-------------------------------------------------------------------------------");
    }

    private String getAppRootDirectory() {
        try {
            LOGGER.debug("1 " + this.getClass());
            LOGGER.debug("2 " + this.getClass().getProtectionDomain());
            LOGGER.debug("3 " + this.getClass().getProtectionDomain().getCodeSource());
            LOGGER.debug("4 " + this.getClass().getProtectionDomain().getCodeSource().getLocation());
            LOGGER.debug("5 " + this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
            File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
            String appRootFolder = URLDecoder.decode(file.getAbsolutePath(), "utf-8");
            boolean fromJar = appRootFolder.endsWith(".jar");
            if (fromJar) {
                appRootFolder = Util.getDirectoryName(appRootFolder);
            }
            return Util.getDirectoryName(appRootFolder);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void showHelp() throws MalformedURLException {
        Util.openWikiTopic("Tikal");
    }

    private void printUsage() {
        LOGGER.info("Shows this screen: -?");
        LOGGER.info("Shows version and other information: -i or --info");
        LOGGER.info("Opens the user guide page: -h or --help");
        LOGGER.info("Lists all available filter configurations: -lfc or --listconf");
        LOGGER.info("Outputs all messages to the current logger instead of the console: -logger");
        LOGGER.info("Outputs debug messages when in console mode (no effect on logger): -trace");
        LOGGER.info("Does not abort batch processing in case of individual errors: -continue");
        LOGGER.info("Edits or view filter configurations (UI-dependent command):");
        LOGGER.info("   -e [[-fc] configId] [-pd configDirectory]");
        LOGGER.info("Extracts a file to XLIFF (and optionally segment and pre-translate):");
        LOGGER.info("   -x[1] inputFile [inputFile2...] [-fc configId] [-ie encoding] [-sl srcLang]");
        LOGGER.info("      [-tl trgLang] [-seg [srxFile]] [-tt [url]|-mm [key]");
        LOGGER.info("      |-pen tmDirectory|-gs configFile|-apertium [configFile]|-mmt url [context]");
        LOGGER.info("      |-ms configFile|-tda configFile|-gg configFile|-bi bilingFile|-lingo24 configFile]");
        LOGGER.info("      [-maketmx [tmxFile]] [-opt threshold] [-od outputDirectory]");
        LOGGER.info("      [-rd rootDirectory] [-nocopy] [-noalttrans] [-pd configDirectory]");
        LOGGER.info("      -x and -x1: use original file for merge");
        LOGGER.info("Merges an XLIFF document back to its original format:");
        LOGGER.info("   -m[1] xliffFile [xliffFile2...] [-fc configId] [-ie encoding] [-oe encoding]");
        LOGGER.info("      [-sd sourceDirectory] [-od outputDirectory] [-pd configDirectory]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-av|-v <libVersion>|-vp <jarPath>]|-vc <configPath>");
        LOGGER.info("      -m and -m1: use original file for merge");
        LOGGER.info("Translates a file:");
        LOGGER.info("   -t inputFile [inputFile2...] [-fc configId] [-ie encoding] [-oe encoding]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-seg [srxFile]] [-tt [url]");
        LOGGER.info("      |-mm [key]|-pen tmDirectory|-gs configFile|-apertium [configFile]|-mmt url [context]");
        LOGGER.info("      |-ms configFile|-tda configFile|-gg configFile|-bi bilingFile|-lingo24 [configFile]");
        LOGGER.info("      [-maketmx [tmxFile]] [-opt threshold] [-pd configDirectory]");
        LOGGER.info("      [-rd rootDirectory]");
        LOGGER.info("Extracts a file to Moses InlineText:");
        LOGGER.info("   -xm inputFile [-fc configId] [-ie encoding] [-seg [srxFile]] [-2]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-rd rootDirectory]");
        LOGGER.info("      [-to srcOutputFile] (single input only)");
        LOGGER.info("Leverages a file with Moses InlineText:");
        LOGGER.info("   -lm inputFile [-fc configId] [-ie encoding] [-oe encoding] [-sl srcLang]");
        LOGGER.info("      [-tl trgLang] [-seg [srxFile]] [-totrg|-overtrg] [-bpt]");
        LOGGER.info("      [-rd rootDirectory] [-noalttrans]");
        LOGGER.info("      [-from mosesFile] [-to outputFile] (single input only)");
        LOGGER.info("Segments a file:");
        LOGGER.info("   -s inputFile [-fc configId] [-ie encoding] [-rd rootDirectory]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-seg [srxFile]] [-pd configDirectory]");
        LOGGER.info("Queries translation resources:");
        LOGGER.info("   -q \"source text\" [-sl srcLang] [-tl trgLang]");
        LOGGER.info("      [-tt [url]] [-mm [key]] [-pen tmDirectory] [-gs configFile] [-mmt url [context]]");
        LOGGER.info("      [-apertium [configFile]] [-ms configFile] [-tda configFile] [-lingo24 [configFile]]");
        LOGGER.info("      [-gg configFile] [-bi bilingFile] [-lingo24 configFile] [-opt threshold[:maxhits]]");
        LOGGER.info("Converts to PO format:");
        LOGGER.info("   -2po inputFile [inputFile2...] [-fc configId] [-ie encoding] [-all]");
        LOGGER.info("      [-generic] [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty]");
        LOGGER.info("      [-rd rootDirectory] [-pd configDirectory] [-approved]");
        LOGGER.info("Converts to TMX format:");
        LOGGER.info("   -2tmx inputFile [inputFile2...] [-fc configId] [-ie encoding] [-all]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty] [-rd rootDirectory]");
        LOGGER.info("      [-pd configDirectory] [-approved]");
        LOGGER.info("Converts to table format:");
        LOGGER.info("   -2tbl inputFile [inputFile2...] [-fc configId] [-ie encoding]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty] [-csv|-tab]");
        LOGGER.info("      [-xliff|-xliffgx|-tmx|-generic] [-all] [-rd rootDirectory]");
        LOGGER.info("      [-pd configDirectory] [-approved]");
        LOGGER.info("Imports to Pensieve TM:");
        LOGGER.info("   -imp tmDirectory inputFile [inputFile2...] [-fc configId] [-ie encoding]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-trgsource|-trgempty] [-all] [-over]");
        LOGGER.info("      [-rd rootDirectory] [-pd configDirectory] [-approved]");
        LOGGER.info("Exports Pensieve TM as TMX:");
        LOGGER.info("   -exp tmDirectory1 [tmDirectory2...] [-sl srcLang] [-tl trgLang]");
        LOGGER.info("      [-trgsource|-trgempty] [-all]");
        LOGGER.info("Prints a Scoping Report:");
        LOGGER.info("   -sr inputFile [inputFile2...] [-fc configId] [-ie encoding]");
        LOGGER.info("      [-sl srcLang] [-tl trgLang] [-pd configDirectory] [-seg [srxFile]]");
        LOGGER.info("      [-tt [url]|-mm [key]|-pen tmDirectory|-gs configFile|-mmt url [context]");
        LOGGER.info("      |-apertium [configFile]|-ms configFile|-tda configFile|-gg configFile");
        LOGGER.info("      |-bi bilingFile|-lingo24 [configFile] [-maketmx [tmxFile]] [-opt threshold]");
    }

    private void displayQuery(IQuery conn) {
        String name = conn.getClass().getName();
        int count = name.endsWith("PensieveTMConnector") || name.endsWith("GoogleMTv2Connector") || name.endsWith("MyMemoryTMConnector") || name.endsWith("MicrosoftMTConnector") || name.endsWith("GlobalSightTMConnector") || name.endsWith("BilingualFileConnector") || name.endsWith("Lingo24Connector") || name.endsWith("MMTConnector") ? conn.query(this.parseToTextFragment(this.query)) : conn.query(this.query);
        LOGGER.info("\n= From {} ({}->{})", new Object[]{name, conn.getSourceLanguage(), conn.getTargetLanguage()});
        if (conn instanceof ITMQuery) {
            ITMQuery tmConn = (ITMQuery)conn;
            LOGGER.info("  Threshold={}, Maximum hits={}", (Object)tmConn.getThreshold(), (Object)tmConn.getMaximumHits());
        }
        boolean first = true;
        if (count > 0) {
            while (conn.hasNext()) {
                QueryResult qr = conn.next();
                if (first && !Util.isEmpty(qr.engine)) {
                    first = false;
                    LOGGER.info("  Engine: '{}'", (Object)qr.engine);
                }
                LOGGER.info("score: {}, origin: '{}'{}", new Object[]{qr.getCombinedScore(), qr.origin == null ? "" : qr.origin, qr.fromMT() ? " (from MT)" : ""});
                LOGGER.info("  Source: \"{}\"", (Object)qr.source.toText());
                LOGGER.info("  Target: \"{}\"", (Object)qr.target.toText());
            }
        } else {
            LOGGER.info("  Source: \"{}\"", (Object)this.query);
            LOGGER.info("  <No translation has been found>");
        }
    }

    private void processQuery() {
        BaseConnector conn;
        this.guessMissingLocales(null);
        if (!(this.useGoogleV2 || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA || this.useBifile || this.useLingo24 || this.useMMT)) {
            this.useTransToolkit = true;
        }
        int[] opt = this.parseTMOptions();
        int threshold = opt[0];
        int maxhits = opt[1];
        if (this.useGoogleV2) {
            conn = new GoogleMTv2Connector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.usePensieve) {
            conn = new PensieveTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useTransToolkit) {
            conn = new TranslateToolkitTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useGlobalSight) {
            conn = new GlobalSightTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useTDA) {
            conn = new TDASearchConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useMicrosoft) {
            conn = new MicrosoftMTConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useMyMemory) {
            conn = new MyMemoryTMConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useApertium) {
            conn = new ApertiumMTConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useBifile) {
            conn = new BilingualFileConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            this.setTMOptionsIfPossible(conn, threshold, maxhits);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useLingo24) {
            conn = new Lingo24Connector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
        if (this.useMMT) {
            conn = new MMTConnector();
            conn.setParameters(this.prepareConnectorParameters(conn.getClass().getName()));
            conn.setLanguages(this.srcLoc, this.trgLoc);
            conn.open();
            this.displayQuery(conn);
            conn.close();
        }
    }

    private int[] parseTMOptions() {
        int[] opt = new int[]{-1, -1};
        if (!Util.isEmpty(this.tmOptions)) {
            try {
                int n = this.tmOptions.indexOf(58);
                if (n == -1) {
                    opt[0] = Integer.parseInt(this.tmOptions);
                } else {
                    opt[0] = Integer.parseInt(this.tmOptions.substring(0, n));
                    opt[1] = Integer.parseInt(this.tmOptions.substring(n + 1));
                    if (opt[1] < 0) {
                        throw new OkapiException(String.format("Invalid TM options: '%s' Maximum hits must be more than 0.", this.tmOptions));
                    }
                }
                if (opt[0] < 0 || opt[0] > 100) {
                    throw new OkapiException(String.format("Invalid TM options: '%s' Thresold must be between 0 and 100.", this.tmOptions));
                }
            }
            catch (NumberFormatException e) {
                throw new OkapiException(String.format("Invalid TM options: '%s'", this.tmOptions));
            }
        }
        return opt;
    }

    private void setTMOptionsIfPossible(IQuery conn, int threshold, int maxhits) {
        ITMQuery tmConn = (ITMQuery)conn;
        if (threshold > -1) {
            tmConn.setThreshold(threshold);
        }
        if (maxhits > -1) {
            tmConn.setMaximumHits(maxhits);
        }
    }

    private void convertFile(RawDocument rd, URI outputURI) {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(this.rootDir, Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        FormatConversionStep fcStep = new FormatConversionStep();
        net.sf.okapi.steps.formatconversion.Parameters params = fcStep.getParameters();
        if (this.command == 4) {
            params.setOutputFormat("po");
            params.setOutputPath("output.po");
        } else if (this.command == 5) {
            params.setOutputFormat("tmx");
            params.setOutputPath("output.tmx");
        } else if (this.command == 6) {
            params.setOutputFormat("table");
            TableFilterWriterParameters opt = new TableFilterWriterParameters();
            opt.fromArguments(this.tableConvFormat, this.tableConvCodes);
            params.setFormatOptions(opt.toString());
            params.setOutputPath("output.txt");
        } else if (this.command == 7) {
            params.setOutputFormat("pensieve");
            params.setOutputPath(this.checkPensieveDirExtension());
        }
        params.setSingleOutput(this.command == 7);
        params.setUseGenericCodes(this.genericOutput);
        params.setTargetStyle(this.convTargetStyle);
        params.setSkipEntriesWithoutText(this.convSkipEntriesWithoutText);
        params.setOverwriteSameSource(this.convOverwrite);
        params.setApprovedEntriesOnly(this.convApprovedEntriesOnly);
        driver.addStep(fcStep);
        driver.addBatchItem(rd, outputURI, this.outputEncoding);
        driver.processBatch();
    }

    private IPipelineStep addSegmentationStep() {
        if (this.segRules.equals(DEFAULT_SEGRULES)) {
            this.segRules = this.getAppRootDirectory();
            this.segRules = this.segRules + File.separator + "config" + File.separator + "defaultSegmentation.srx";
        } else if (Util.isEmpty(Util.getExtension(this.segRules))) {
            this.segRules = this.segRules + ".srx";
        }
        SegmentationStep segStep = new SegmentationStep();
        net.sf.okapi.steps.segmentation.Parameters segParams = (net.sf.okapi.steps.segmentation.Parameters)segStep.getParameters();
        segParams.setSegmentSource(true);
        segParams.setSegmentTarget(true);
        File f = new File(this.segRules);
        segParams.setSourceSrxPath(f.getAbsolutePath());
        segParams.setTargetSrxPath(f.getAbsolutePath());
        segParams.setCopySource(this.extOptCopy);
        LOGGER.info("Segmentation: {}", (Object)f.getAbsolutePath());
        return segStep;
    }

    private IPipelineStep addLeveragingStep() {
        LeveragingStep levStep = new LeveragingStep();
        net.sf.okapi.steps.leveraging.Parameters levParams = (net.sf.okapi.steps.leveraging.Parameters)levStep.getParameters();
        if (this.usePensieve) {
            levParams.setResourceClassName(PensieveTMConnector.class.getName());
        } else if (this.useTransToolkit) {
            levParams.setResourceClassName(TranslateToolkitTMConnector.class.getName());
        } else if (this.useMyMemory) {
            levParams.setResourceClassName(MyMemoryTMConnector.class.getName());
        } else if (this.useGoogleV2) {
            levParams.setResourceClassName(GoogleMTv2Connector.class.getName());
        } else if (this.useGlobalSight) {
            levParams.setResourceClassName(GlobalSightTMConnector.class.getName());
        } else if (this.useTDA) {
            levParams.setResourceClassName(TDASearchConnector.class.getName());
        } else if (this.useMicrosoft) {
            levParams.setResourceClassName(MicrosoftMTConnector.class.getName());
        } else if (this.useApertium) {
            levParams.setResourceClassName(ApertiumMTConnector.class.getName());
        } else if (this.useBifile) {
            levParams.setResourceClassName(BilingualFileConnector.class.getName());
        } else if (this.useLingo24) {
            levParams.setResourceClassName(Lingo24Connector.class.getName());
        } else if (this.useMMT) {
            levParams.setResourceClassName(MMTConnector.class.getName());
        }
        IParameters p = this.prepareConnectorParameters(levParams.getResourceClassName());
        if (p != null) {
            levParams.setResourceParameters(p.toString());
        }
        levParams.setFillTarget(this.levOptFillTarget);
        int[] opt = this.parseTMOptions();
        if (opt[0] > -1) {
            levParams.setThreshold(opt[0]);
        }
        if (this.levOptTMXPath != null) {
            levParams.setMakeTMX(true);
            levParams.setTMXPath(this.levOptTMXPath);
        }
        return levStep;
    }

    private void extractFile(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(this.rootDir, Util.getDirectoryName(rd.getInputURI().getPath()));
        driver.setExecutionContext(this.context);
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        if (this.useGoogleV2 || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA || this.useBifile || this.useLingo24 || this.useMMT) {
            driver.addStep(this.addLeveragingStep());
        }
        FilterEventsWriterStep fewStep = new FilterEventsWriterStep();
        XLIFFWriter writer = new XLIFFWriter();
        fewStep.setFilterWriter(writer);
        XLIFFWriterParameters paramsXliff = writer.getParameters();
        paramsXliff.setPlaceholderMode(true);
        paramsXliff.setCopySource(this.extOptCopy);
        paramsXliff.setIncludeAltTrans(this.extOptAltTrans);
        paramsXliff.setIncludeCodeAttrs(this.extOptCodeAttrs);
        fewStep.setDocumentRoots(this.rootDir);
        driver.addStep(fewStep);
        String tmp = rd.getInputURI().getPath();
        if (tmp.endsWith("/") || tmp.endsWith("\\")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        tmp = tmp + ".xlf";
        tmp = this.pathChangeFolder(this.outputDir, tmp);
        driver.addBatchItem(rd, new File(tmp).toURI(), this.outputEncoding);
        LOGGER.info("Source language: {}", (Object)this.srcLoc);
        LOGGER.info("Target language: {}", (Object)this.trgLoc);
        LOGGER.info("Default input encoding: {}", (Object)this.inputEncoding);
        LOGGER.info("Filter configuration: {}", (Object)this.configId);
        LOGGER.info("Output: {}", (Object)tmp);
        driver.processBatch();
    }

    private void segmentFile(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(this.rootDir, Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        driver.addStep(this.addSegmentationStep());
        FilterEventsToRawDocumentStep ferdStep = new FilterEventsToRawDocumentStep();
        driver.addStep(ferdStep);
        String tmp = rd.getInputURI().getPath();
        this.output = this.pathInsertOutBeforeExt(tmp);
        LOGGER.info("Source language: {}", (Object)this.srcLoc);
        LOGGER.info("Target language: {}", (Object)this.trgLoc);
        LOGGER.info("Default input encoding: {}", (Object)this.inputEncoding);
        LOGGER.info("Output encoding: {}", (Object)this.outputEncoding);
        LOGGER.info("Filter configuration: {}", (Object)this.configId);
        LOGGER.info("Output: {}", (Object)this.output);
        driver.addBatchItem(rd, new File(this.output).toURI(), this.outputEncoding);
        driver.processBatch();
    }

    private void leverageFileWithMoses(RawDocument rd) {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(this.rootDir, Util.getDirectoryName(rd.getInputURI().getPath()));
        driver.addStep(new RawDocumentToFilterEventsStep());
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        MergingStep mrgStep = new MergingStep();
        MergingParameters params = (MergingParameters)mrgStep.getParameters();
        params.setCopyToTarget(this.mosesCopyToTarget);
        params.setOverwriteExistingTarget(this.mosesOverwriteTarget);
        params.setForceAltTransOutput(this.extOptAltTrans);
        params.setUseGModeInAltTrans(this.mosesUseGModeInAltTrans);
        driver.addStep(mrgStep);
        driver.addStep(new FilterEventsToRawDocumentStep());
        try (RawDocument rdMoses = new RawDocument(new File(this.mosesFromPath).toURI(), "UTF-8", this.trgLoc);){
            driver.addBatchItem(new BatchItemContext(rd, new File(this.output).toURI(), this.outputEncoding, rdMoses));
            driver.processBatch();
        }
    }

    private void extractFileToMoses(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(this.rootDir, Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        ExtractionStep extStep = new ExtractionStep();
        if (this.moses2Outputs) {
            FilterWriterParameters p = (FilterWriterParameters)extStep.getParameters();
            p.setSourceAndTarget(true);
        }
        driver.addStep(extStep);
        String outPath = !Util.isEmpty(this.mosesToPathParam) ? this.mosesToPathParam : rd.getInputURI().getPath();
        if (!outPath.endsWith("." + this.srcLoc.toString())) {
            outPath = outPath + "." + this.srcLoc.toString();
        }
        driver.addBatchItem(rd, new File(outPath).toURI(), "UTF-8");
        LOGGER.info("Source language: {}", (Object)this.srcLoc);
        if (this.moses2Outputs) {
            LOGGER.info("Target language: {}", (Object)this.trgLoc);
        }
        LOGGER.info("Default input encoding: {}", (Object)this.inputEncoding);
        LOGGER.info("Filter configuration: {}", (Object)this.configId);
        driver.processBatch();
    }

    private void translateFile(RawDocument rd) throws URISyntaxException {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        driver.setRootDirectories(this.rootDir, Util.getDirectoryName(rd.getInputURI().getPath()));
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        if (this.useGoogleV2 || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA || this.useBifile || this.useLingo24 || this.useMMT) {
            driver.addStep(this.addLeveragingStep());
        } else {
            LOGGER.info("No valid translation resource has been specified: The text will not be modified.");
        }
        FilterEventsToRawDocumentStep ferdStep = new FilterEventsToRawDocumentStep();
        driver.addStep(ferdStep);
        String tmp = rd.getInputURI().getPath();
        this.output = this.pathInsertOutBeforeExt(tmp);
        LOGGER.info("Source language: {}", (Object)this.srcLoc);
        LOGGER.info("Target language: {}", (Object)this.trgLoc);
        LOGGER.info("Default input encoding: {}", (Object)this.inputEncoding);
        LOGGER.info("Output encoding: {}", (Object)this.outputEncoding);
        LOGGER.info("Filter configuration: {}", (Object)this.configId);
        LOGGER.info("Output: {}", (Object)this.output);
        driver.addBatchItem(rd, new File(this.output).toURI(), this.outputEncoding);
        driver.processBatch();
    }

    private String checkPensieveDirExtension() {
        String ext = Util.getExtension(this.pensieveData);
        if (Util.isEmpty(ext)) {
            this.pensieveData = this.pensieveData + ".pentm";
        }
        return this.pensieveData;
    }

    private IParameters prepareConnectorParameters(String connectorClassName) {
        if (connectorClassName.equals(PensieveTMConnector.class.getName())) {
            net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
            if (this.pensieveData.startsWith("http:")) {
                params.setHost(this.pensieveData);
                params.setUseServer(true);
            } else {
                params.setDbDirectory(this.checkPensieveDirExtension());
            }
            return params;
        }
        if (connectorClassName.equals(TranslateToolkitTMConnector.class.getName())) {
            net.sf.okapi.connectors.translatetoolkit.Parameters params = new net.sf.okapi.connectors.translatetoolkit.Parameters();
            params.setUrl(this.transToolkitParams);
            return params;
        }
        if (connectorClassName.equals(MyMemoryTMConnector.class.getName())) {
            net.sf.okapi.connectors.mymemory.Parameters params = new net.sf.okapi.connectors.mymemory.Parameters();
            params.setKey(this.myMemoryParams);
            return params;
        }
        if (connectorClassName.equals(GlobalSightTMConnector.class.getName())) {
            net.sf.okapi.connectors.globalsight.Parameters params = new net.sf.okapi.connectors.globalsight.Parameters();
            URI paramURI = new File(this.globalSightParams).toURI();
            params.load(Util.URItoURL(paramURI), false);
            return params;
        }
        if (connectorClassName.equals(TDASearchConnector.class.getName())) {
            Parameters params = new Parameters();
            URI paramURI = new File(this.tdaParams).toURI();
            params.load(Util.URItoURL(paramURI), false);
            return params;
        }
        if (connectorClassName.equals(MicrosoftMTConnector.class.getName())) {
            net.sf.okapi.connectors.microsoft.Parameters params = new net.sf.okapi.connectors.microsoft.Parameters();
            if (this.microsoftParams != null) {
                URI paramURI = new File(this.microsoftParams).toURI();
                params.load(Util.URItoURL(paramURI), false);
            }
            return params;
        }
        if (connectorClassName.equals(GoogleMTv2Connector.class.getName())) {
            GoogleMTv2Parameters params = new GoogleMTv2Parameters();
            if (this.googleV2Params != null) {
                URI paramURI = new File(this.googleV2Params).toURI();
                params.load(Util.URItoURL(paramURI), false);
            }
            return params;
        }
        if (connectorClassName.equals(ApertiumMTConnector.class.getName())) {
            net.sf.okapi.connectors.apertium.Parameters params = new net.sf.okapi.connectors.apertium.Parameters();
            if (this.apertiumParams != null) {
                URI paramURI = new File(this.apertiumParams).toURI();
                params.load(Util.URItoURL(paramURI), false);
            }
            return params;
        }
        if (connectorClassName.equals(BilingualFileConnector.class.getName())) {
            net.sf.okapi.connectors.bifile.Parameters params = new net.sf.okapi.connectors.bifile.Parameters();
            params.setBiFile(this.bifileData);
            params.setInputEncoding(this.inputEncoding);
            return params;
        }
        if (connectorClassName.equals(Lingo24Connector.class.getName())) {
            net.sf.okapi.connectors.lingo24.Parameters params = new net.sf.okapi.connectors.lingo24.Parameters();
            if (this.lingo24Params != null) {
                params.setUserKey(this.lingo24Params);
            }
            return params;
        }
        if (connectorClassName.equals(MMTConnector.class.getName())) {
            net.sf.okapi.connectors.mmt.Parameters params = new net.sf.okapi.connectors.mmt.Parameters();
            params.setUrl(this.mmtUrl);
            if (this.mmtContext != null) {
                params.setContext(this.mmtContext);
            }
            return params;
        }
        return null;
    }

    private void printScopingReport() {
        this.initialize();
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper(this.fcMapper);
        for (String input : this.inputs) {
            this.guessMissingParameters(input);
            this.guessMissingLocales(input);
            driver.addBatchItem(new RawDocument(Util.toURI(input), StandardCharsets.UTF_8.name(), this.srcLoc, this.trgLoc, this.configId), (URI)null, (String)null);
        }
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep(rd2feStep);
        String template = "\n[Scoping Report]\nDate: [PROJECT_DATE]\nFiles:\n  [[ITEM_NAME]]\nTotals:\n  [PROJECT_TOTAL_WORD_COUNT] words\n  [PROJECT_TOTAL_CHARACTER_COUNT] characters\n";
        if (this.segRules != null) {
            driver.addStep(this.addSegmentationStep());
        }
        if (this.useGoogleV2 || this.useTransToolkit || this.useMyMemory || this.usePensieve || this.useGlobalSight || this.useApertium || this.useMicrosoft || this.useTDA || this.useBifile || this.useLingo24 || this.useMMT) {
            driver.addStep(this.addLeveragingStep());
            template = template + "\nExact Local Context: [PROJECT_EXACT_LOCAL_CONTEXT] words\n                     [PROJECT_EXACT_LOCAL_CONTEXT_CHARACTERS] characters\n100% Match: [PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT] words\n            [PROJECT_GMX_LEVERAGED_MATCHED_CHARACTER_COUNT] characters\nFuzzy Match: [PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT] words\n             [PROJECT_GMX_FUZZY_MATCHED_CHARACTER_COUNT] characters\nRepetitions: [PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT] words\n             [PROJECT_GMX_REPETITION_MATCHED_CHARACTER_COUNT] characters";
        }
        WordCountStep wcStep = new WordCountStep();
        driver.addStep(wcStep);
        CharacterCountStep ccStep = new CharacterCountStep();
        driver.addStep(ccStep);
        ScopingReportStep srStep = new ScopingReportStep();
        net.sf.okapi.steps.scopingreport.Parameters params = new net.sf.okapi.steps.scopingreport.Parameters();
        params.setCustomTemplateString(template);
        params.setOutputPath(null);
        srStep.setParameters(params);
        driver.addStep(srStep);
        driver.processBatch();
        driver.destroy();
        LOGGER.info(srStep.getReportGenerator().generate());
    }

    public TextFragment parseToTextFragment(String text) {
        int n;
        Pattern patternOpening = Pattern.compile("\\<(\\w+)[ ]*[^\\>/]*\\>");
        Pattern patternClosing = Pattern.compile("\\</(\\w+)[ ]*[^\\>]*\\>");
        Pattern patternPlaceholder = Pattern.compile("\\<(\\w+)[ ]*[^\\>]*/\\>");
        TextFragment tf = new TextFragment();
        tf.setCodedText(text);
        int start = 0;
        int diff = 0;
        Matcher m = patternOpening.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.OPENING, m.group(1));
            start = n + m.group().length();
        }
        text = tf.getCodedText();
        diff = 0;
        start = 0;
        m = patternClosing.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.CLOSING, m.group(1));
            start = n + m.group().length();
        }
        text = tf.getCodedText();
        diff = 0;
        start = 0;
        m = patternPlaceholder.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.PLACEHOLDER, null);
            start = n + m.group().length();
        }
        return tf;
    }

    public static class Timer {
        private long startMillis = System.currentTimeMillis();

        public double elapsedSeconds() {
            return (double)(System.currentTimeMillis() - this.startMillis) / 1000.0;
        }

        public String toString() {
            return "" + this.elapsedSeconds() + "s";
        }
    }
}

