/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import net.sf.okapi.applications.rainbow.lib.PathBuilder;
import net.sf.okapi.applications.rainbow.lib.Res;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PathBuilderPanel
extends Composite {
    private int initLevel = 0;
    private Button m_chkUseSubdir;
    private Text m_edSubdir;
    private Button m_chkUseExt;
    private Button m_chkUsePrefix;
    private Button m_chkUseSuffix;
    private Button m_chkUseReplace;
    private Text m_edExt;
    private Button m_rdExtReplace;
    private Button m_rdExtAppend;
    private Button m_rdExtPrepend;
    private Text m_edPrefix;
    private Text m_edSuffix;
    private Text m_edSearch;
    private Text m_edReplace;
    private Text m_edBefore;
    private Text m_edAfter;
    private PathBuilder m_TempPB;
    private String m_sSrcRoot;
    private String m_sTrgRoot;
    private String srcLangStr;
    private String trgLangStr;

    public PathBuilderPanel(Composite p_Parent, int p_nFlags) {
        super(p_Parent, p_nFlags);
        this.createContent();
    }

    private void createContent() {
        GridLayout layTmp = new GridLayout(5, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        ModifyListener MLUpdate = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathBuilderPanel.this.updateSample();
            }
        };
        SelectionAdapter SAUpdate = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathBuilderPanel.this.updateSample();
            }
        };
        this.m_chkUseSubdir = new Button((Composite)this, 32);
        this.m_chkUseSubdir.setText(Res.getString("PathBuilderPanel.subFolder"));
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.m_chkUseSubdir.setLayoutData((Object)gdTmp);
        this.m_chkUseSubdir.addSelectionListener((SelectionListener)SAUpdate);
        this.m_edSubdir = new Text((Composite)this, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.m_edSubdir.setLayoutData((Object)gdTmp);
        this.m_edSubdir.addModifyListener(MLUpdate);
        this.m_chkUseExt = new Button((Composite)this, 32);
        this.m_chkUseExt.setText(Res.getString("PathBuilderPanel.extension"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 3;
        this.m_chkUseExt.setLayoutData((Object)gdTmp);
        this.m_chkUseExt.addSelectionListener((SelectionListener)SAUpdate);
        this.m_chkUsePrefix = new Button((Composite)this, 32);
        this.m_chkUsePrefix.setText(Res.getString("PathBuilderPanel.prefix"));
        this.m_chkUsePrefix.addSelectionListener((SelectionListener)SAUpdate);
        this.m_chkUseReplace = new Button((Composite)this, 32);
        this.m_chkUseReplace.setText(Res.getString("PathBuilderPanel.replaceThis"));
        this.m_chkUseReplace.addSelectionListener((SelectionListener)SAUpdate);
        this.m_edExt = new Text((Composite)this, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        gdTmp.grabExcessHorizontalSpace = false;
        this.m_edExt.setLayoutData((Object)gdTmp);
        this.m_edExt.addModifyListener(MLUpdate);
        Composite cmpTmp = new Composite((Composite)this, 0);
        gdTmp = new GridData();
        gdTmp.verticalSpan = 3;
        cmpTmp.setLayoutData((Object)gdTmp);
        layTmp = new GridLayout();
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        cmpTmp.setLayout((Layout)layTmp);
        this.m_rdExtReplace = new Button(cmpTmp, 16);
        this.m_rdExtReplace.setText(Res.getString("PathBuilderPanel.extensionReplace"));
        this.m_rdExtReplace.addSelectionListener((SelectionListener)SAUpdate);
        this.m_rdExtAppend = new Button(cmpTmp, 16);
        this.m_rdExtAppend.setText(Res.getString("PathBuilderPanel.extensionAppend"));
        this.m_rdExtAppend.addSelectionListener((SelectionListener)SAUpdate);
        this.m_rdExtPrepend = new Button(cmpTmp, 16);
        this.m_rdExtPrepend.setText(Res.getString("PathBuilderPanel.extensionPrepend"));
        this.m_rdExtPrepend.addSelectionListener((SelectionListener)SAUpdate);
        this.m_edPrefix = new Text((Composite)this, 2048);
        this.m_edPrefix.setLayoutData((Object)new GridData(768));
        this.m_edPrefix.addModifyListener(MLUpdate);
        this.m_edSearch = new Text((Composite)this, 2048);
        this.m_edSearch.setLayoutData((Object)new GridData(768));
        this.m_edSearch.addModifyListener(MLUpdate);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.m_chkUseSuffix = new Button((Composite)this, 32);
        this.m_chkUseSuffix.setText(Res.getString("PathBuilderPanel.suffix"));
        this.m_chkUseSuffix.addSelectionListener((SelectionListener)SAUpdate);
        Label stTmp = new Label((Composite)this, 0);
        stTmp.setText(Res.getString("PathBuilderPanel.replaceBy"));
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.m_edSuffix = new Text((Composite)this, 2048);
        this.m_edSuffix.setLayoutData((Object)new GridData(768));
        this.m_edSuffix.addModifyListener(MLUpdate);
        this.m_edReplace = new Text((Composite)this, 2048);
        this.m_edReplace.setLayoutData((Object)new GridData(768));
        this.m_edReplace.addModifyListener(MLUpdate);
        stTmp = new Label((Composite)this, 0);
        stTmp.setText(Res.getString("PathBuilderPanel.before"));
        this.m_edBefore = new Text((Composite)this, 2048);
        this.m_edBefore.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.m_edBefore.setLayoutData((Object)gdTmp);
        stTmp = new Label((Composite)this, 0);
        stTmp.setText(Res.getString("PathBuilderPanel.after"));
        this.m_edAfter = new Text((Composite)this, 2048);
        this.m_edAfter.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.m_edAfter.setLayoutData((Object)gdTmp);
        this.pack();
    }

    public void setTargetRoot(String p_sValue) {
        this.m_sTrgRoot = p_sValue == null || p_sValue.length() == 0 ? null : p_sValue;
    }

    public void setData(PathBuilder p_Data, String p_sSrcRoot, String p_sSrcPath, String p_sTrgRoot, String srcLang, String trgLang) {
        ++this.initLevel;
        this.m_TempPB = new PathBuilder();
        this.m_TempPB.copyFrom(p_Data);
        this.m_sSrcRoot = p_sSrcRoot;
        this.m_sTrgRoot = p_sTrgRoot;
        this.srcLangStr = srcLang;
        this.trgLangStr = trgLang;
        this.m_edBefore.setText(p_sSrcPath);
        this.m_chkUseSubdir.setSelection(p_Data.useSubfolder());
        this.m_edSubdir.setText(p_Data.getSubfolder());
        this.m_chkUseExt.setSelection(p_Data.useExtension());
        this.m_edExt.setText(p_Data.getExtension());
        this.m_rdExtReplace.setSelection(p_Data.getExtensionType() == 2);
        this.m_rdExtAppend.setSelection(p_Data.getExtensionType() == 1);
        this.m_rdExtPrepend.setSelection(p_Data.getExtensionType() == 0);
        this.m_chkUsePrefix.setSelection(p_Data.usePrefix());
        this.m_edPrefix.setText(p_Data.getPrefix());
        this.m_chkUseSuffix.setSelection(p_Data.useSuffix());
        this.m_edSuffix.setText(p_Data.getSuffix());
        this.m_chkUseReplace.setSelection(p_Data.useReplace());
        this.m_edSearch.setText(p_Data.getSearch());
        this.m_edReplace.setText(p_Data.getReplace());
        --this.initLevel;
        this.updateSample();
    }

    public void saveData(PathBuilder pathBuilder) {
        pathBuilder.setUseSubfolder(this.m_chkUseSubdir.getSelection());
        pathBuilder.setSubfolder(this.m_edSubdir.getText());
        pathBuilder.setUseExtension(this.m_chkUseExt.getSelection());
        pathBuilder.setExtension(this.m_edExt.getText());
        if (this.m_rdExtReplace.getSelection()) {
            pathBuilder.setExtensionType(2);
        } else if (this.m_rdExtAppend.getSelection()) {
            pathBuilder.setExtensionType(1);
        } else {
            pathBuilder.setExtensionType(0);
        }
        pathBuilder.setUsePrefix(this.m_chkUsePrefix.getSelection());
        pathBuilder.setPrefix(this.m_edPrefix.getText());
        pathBuilder.setUseSuffix(this.m_chkUseSuffix.getSelection());
        pathBuilder.setSuffix(this.m_edSuffix.getText());
        pathBuilder.setUseReplace(this.m_chkUseReplace.getSelection());
        pathBuilder.setSearch(this.m_edSearch.getText());
        pathBuilder.setReplace(this.m_edReplace.getText());
    }

    public void setSourceLanguage(String newLang) {
        this.srcLangStr = newLang;
        this.updateSample();
    }

    public void setTargetLanguage(String newLang) {
        this.trgLangStr = newLang;
        this.updateSample();
    }

    public void updateSample() {
        if (this.initLevel > 0) {
            return;
        }
        this.saveData(this.m_TempPB);
        String sTmp = this.m_TempPB.getPath(this.m_edBefore.getText(), this.m_sSrcRoot, this.m_sTrgRoot, this.srcLangStr, this.trgLangStr);
        this.m_edAfter.setText(sTmp);
        this.m_edSubdir.setEnabled(this.m_chkUseSubdir.getSelection());
        this.m_edPrefix.setEnabled(this.m_chkUsePrefix.getSelection());
        this.m_edSuffix.setEnabled(this.m_chkUseSuffix.getSelection());
        this.m_edSearch.setEnabled(this.m_chkUseReplace.getSelection());
        this.m_edReplace.setEnabled(this.m_chkUseReplace.getSelection());
        boolean enabled = this.m_chkUseExt.getSelection();
        this.m_edExt.setEnabled(enabled);
        this.m_rdExtAppend.setEnabled(enabled);
        this.m_rdExtPrepend.setEnabled(enabled);
        this.m_rdExtReplace.setEnabled(enabled);
    }
}

