/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;

public class TextPart
implements IWithProperties,
IWithAnnotations {
    protected LinkedHashMap<String, Property> properties;
    protected Annotations annotations;
    public TextFragment text;

    public TextPart() {
        this.text = new TextFragment();
    }

    public TextPart(TextFragment text) {
        if (text == null) {
            text = new TextFragment();
        }
        this.text = text;
    }

    public TextPart(String text) {
        this.text = new TextFragment(text);
    }

    public TextPart clone() {
        TextPart tp = new TextPart(this.text.clone());
        if (this.properties != null) {
            tp.properties = new LinkedHashMap();
            for (Property prop : this.properties.values()) {
                tp.properties.put(prop.getName(), prop.clone());
            }
        }
        if (this.annotations != null) {
            tp.annotations = this.annotations.clone();
        }
        return tp;
    }

    public String toString() {
        if (this.text == null) {
            return "";
        }
        return this.text.toText();
    }

    public TextFragment getContent() {
        return this.text;
    }

    public void setContent(TextFragment fragment) {
        this.text = fragment;
    }

    public boolean isSegment() {
        return false;
    }

    @Override
    public Iterable<IAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public Property setProperty(Property property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(property.getName(), property);
        return property;
    }

    @Override
    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties.keySet();
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(name);
    }
}

