/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PredictAPIUtil {
    public static final int CONTENT_CHAR_LIMIT = 250000;
    private final JSONParser parser = new JSONParser();

    public List<JSONObject> getPredictRequests(String sourceText) {
        ArrayList<JSONObject> requests = new ArrayList<JSONObject>();
        List<String> splitTexts = this.getSplitTexts(sourceText);
        for (String splitText : splitTexts) {
            JSONObject root = new JSONObject();
            JSONObject payload = new JSONObject();
            JSONObject textSnippet = new JSONObject();
            textSnippet.put("content", splitText);
            payload.put("textSnippet", textSnippet);
            root.put("payload", payload);
            requests.add(root);
        }
        return requests;
    }

    private List<String> getSplitTexts(String sourceText) {
        ArrayList<String> splitTexts = new ArrayList<String>();
        for (int i = 0; i < sourceText.length(); i += 250000) {
            splitTexts.add(sourceText.substring(i, Math.min(sourceText.length(), i + 250000)));
        }
        return splitTexts;
    }

    public String extractTranslation(InputStream is) throws ParseException {
        JSONObject response = (JSONObject)this.parser.parse(StreamUtil.streamUtf8AsString(is));
        JSONArray payload = (JSONArray)response.get("payload");
        JSONObject payloadElement = (JSONObject)payload.get(0);
        JSONObject translation = (JSONObject)payloadElement.get("translation");
        JSONObject translatedContent = (JSONObject)translation.get("translatedContent");
        return (String)translatedContent.get("content");
    }
}

