/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.DesignMap;
import net.sf.okapi.filters.idml.DesignMapParser;
import net.sf.okapi.filters.idml.NonTranslatableSubDocument;
import net.sf.okapi.filters.idml.OrderingIdioms;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.PasteboardItem;
import net.sf.okapi.filters.idml.Preferences;
import net.sf.okapi.filters.idml.PreferencesParser;
import net.sf.okapi.filters.idml.Spread;
import net.sf.okapi.filters.idml.SpreadParser;
import net.sf.okapi.filters.idml.StorySubDocument;
import net.sf.okapi.filters.idml.SubDocument;

class Document {
    static final String MIME_TYPE = "application/vnd.adobe.indesign-idml-package";
    private final Parameters parameters;
    private final XMLInputFactory inputFactory;
    private final XMLEventFactory eventFactory;
    private ZipFile zipFile;
    private String startDocumentId;
    private String encoding;
    private List<String> nonTranslatableSubDocuments;
    private Enumeration<? extends ZipEntry> zipFileEntries;
    private int currentSubDocumentId;

    Document(Parameters parameters, XMLInputFactory inputFactory, XMLEventFactory eventFactory) {
        this.parameters = parameters;
        this.inputFactory = inputFactory;
        this.eventFactory = eventFactory;
    }

    Event open(String startDocumentId, URI uri, LocaleId sourceLocale, String encoding, IFilterWriter filterWriter) throws XMLStreamException, IOException {
        this.zipFile = new ZipFile(new File(uri.getPath()), 1);
        if (!MIME_TYPE.equals(this.getMimeType())) {
            throw new OkapiBadFilterInputException("IDML filter tried to initialise a file that is not supported.");
        }
        this.encoding = encoding;
        this.startDocumentId = startDocumentId;
        DesignMap designMap = new DesignMapParser(this.getPartReader("designmap.xml"), this.inputFactory).parse();
        Preferences preferences = new PreferencesParser(this.getPartReader(designMap.getPreferencesPartName()), this.inputFactory).parse();
        ArrayList<PasteboardItem> pasteboardItems = new ArrayList<PasteboardItem>();
        ArrayList<PasteboardItem> invisiblePasteboardItems = new ArrayList<PasteboardItem>();
        List<Spread> masterSpreads = this.getSpreads(designMap.getMasterSpreadPartNames(), designMap.getActiveLayerId(), ParsingIdioms.MASTER_SPREAD);
        List<PasteboardItem> masterSpreadPasteboardItems = OrderingIdioms.getOrderedPasteboardItems(masterSpreads, preferences.getStoryPreference().getStoryDirection());
        if (this.parameters.getExtractMasterSpreads()) {
            pasteboardItems.addAll(masterSpreadPasteboardItems);
        } else {
            invisiblePasteboardItems.addAll(masterSpreadPasteboardItems);
        }
        List<Spread> spreads = this.getSpreads(designMap.getSpreadPartNames(), designMap.getActiveLayerId(), ParsingIdioms.SPREAD);
        pasteboardItems.addAll(OrderingIdioms.getOrderedPasteboardItems(spreads, preferences.getStoryPreference().getStoryDirection()));
        List<PasteboardItem> visiblePasteboardItems = this.getVisiblePasteboardItems(designMap, pasteboardItems);
        invisiblePasteboardItems.addAll(this.getInvisiblePasteboardItems(pasteboardItems, visiblePasteboardItems));
        List<String> storyIds = OrderingIdioms.getOrderedStoryIds(visiblePasteboardItems);
        List<String> storyPartNames = OrderingIdioms.getOrderedStoryPartNames(designMap.getStoryPartNames(), storyIds);
        List<String> invisibleStoryIds = OrderingIdioms.getOrderedStoryIds(invisiblePasteboardItems);
        List<String> invisibleStoryPartNames = OrderingIdioms.getOrderedStoryPartNames(designMap.getStoryPartNames(), invisibleStoryIds);
        this.nonTranslatableSubDocuments = PartNames.getPartNames(designMap, invisibleStoryPartNames);
        this.zipFileEntries = this.getZipFileEntries(designMap, storyPartNames);
        this.currentSubDocumentId = 0;
        return this.getStartDocumentEvent(uri, sourceLocale, filterWriter);
    }

    private String getMimeType() throws IOException {
        int result;
        BufferedInputStream inputStream = new BufferedInputStream(this.zipFile.getInputStream(this.zipFile.getEntry("mimetype")));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(MIME_TYPE.length());
        while (-1 != (result = ((InputStream)inputStream).read())) {
            ((OutputStream)outputStream).write((byte)result);
        }
        return ((Object)outputStream).toString();
    }

    private List<Spread> getSpreads(List<String> spreadPartNames, String activeLayerId, QName spreadName) throws IOException, XMLStreamException {
        ArrayList<Spread> spreads = new ArrayList<Spread>();
        for (String spreadPartName : spreadPartNames) {
            Spread spread = new SpreadParser(this.getPartReader(spreadPartName), this.inputFactory, activeLayerId).parse(spreadName);
            spreads.add(spread);
        }
        return spreads;
    }

    private Reader getPartReader(String partName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(partName);
        if (null == entry) {
            throw new OkapiBadFilterInputException("File is missing " + partName);
        }
        return new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding);
    }

    private List<PasteboardItem> getVisiblePasteboardItems(DesignMap designMap, List<PasteboardItem> pasteboardItems) {
        return new PasteboardItem.VisibilityFilter(designMap.getLayers(), this.parameters.getExtractHiddenLayers()).filterVisible(pasteboardItems);
    }

    private List<PasteboardItem> getInvisiblePasteboardItems(List<PasteboardItem> pasteboardItems, List<PasteboardItem> visiblePasteboardItems) {
        ArrayList<PasteboardItem> invisiblePasteboardItems = new ArrayList<PasteboardItem>(pasteboardItems);
        invisiblePasteboardItems.removeAll(visiblePasteboardItems);
        return invisiblePasteboardItems;
    }

    private Enumeration<? extends ZipEntry> getZipFileEntries(DesignMap designMap, List<String> storyPartNames) throws IOException, XMLStreamException {
        ArrayList<? extends ZipEntry> entryList = Collections.list(this.zipFile.entries());
        Collections.sort(entryList, new ZipEntryComparator(PartNames.getPartNames(designMap, storyPartNames)));
        return Collections.enumeration(entryList);
    }

    private Event getStartDocumentEvent(URI uri, LocaleId sourceLocale, IFilterWriter filterWriter) {
        StartDocument startDoc = new StartDocument(this.startDocumentId);
        startDoc.setName(uri.getPath());
        startDoc.setLocale(sourceLocale);
        startDoc.setMimeType(MIME_TYPE);
        startDoc.setFilterWriter(filterWriter);
        startDoc.setFilterParameters(this.parameters);
        startDoc.setLineBreak("\n");
        startDoc.setEncoding(this.encoding, false);
        ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
        return new Event(EventType.START_DOCUMENT, startDoc, skel);
    }

    boolean hasNextSubDocument() {
        return this.zipFileEntries.hasMoreElements();
    }

    SubDocument nextSubDocument() {
        ZipEntry zipEntry = this.zipFileEntries.nextElement();
        if (!this.isTranslatableSubDocument(zipEntry.getName())) {
            return new NonTranslatableSubDocument(this.zipFile, zipEntry, this.startDocumentId, String.valueOf(++this.currentSubDocumentId));
        }
        return new StorySubDocument(this.zipFile, zipEntry, this.startDocumentId, String.valueOf(++this.currentSubDocumentId), this.parameters, this.inputFactory, this.eventFactory);
    }

    boolean isTranslatableSubDocument(String partName) {
        return !this.nonTranslatableSubDocuments.contains(partName);
    }

    void close() throws IOException {
        this.zipFile.close();
    }

    private static class ZipEntryComparator
    implements Comparator<ZipEntry> {
        private List<String> partNames;

        ZipEntryComparator(List<String> partNames) {
            this.partNames = partNames;
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            int index1 = this.partNames.indexOf(o1.getName());
            int index2 = this.partNames.indexOf(o2.getName());
            if (index1 == -1) {
                index1 = Integer.MAX_VALUE;
            }
            if (index2 == -1) {
                index2 = Integer.MAX_VALUE;
            }
            return Integer.compare(index1, index2);
        }
    }

    private static class PartNames {
        private static final String MIME_TYPE = "mimetype";
        private static final String DESIGN_MAP = "designmap.xml";
        private static final String CONTAINER = "META-INF/container.xml";
        private static final String METADATA = "META-INF/metadata.xml";

        private PartNames() {
        }

        static List<String> getPartNames(DesignMap designMap, List<String> storyPartNames) {
            ArrayList<String> partNames = new ArrayList<String>(Arrays.asList(MIME_TYPE, DESIGN_MAP, CONTAINER, METADATA));
            partNames.add(designMap.getGraphicPartName());
            partNames.add(designMap.getFontsPartName());
            partNames.add(designMap.getStylesPartName());
            partNames.add(designMap.getPreferencesPartName());
            partNames.add(designMap.getTagsPartName());
            partNames.add(designMap.getMappingPartName());
            partNames.addAll(designMap.getMasterSpreadPartNames());
            partNames.addAll(designMap.getSpreadPartNames());
            partNames.add(designMap.getBackingStoryPartName());
            partNames.addAll(storyPartNames);
            return partNames;
        }
    }
}

