/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.Story;
import net.sf.okapi.filters.idml.StoryChildElementsMerger;
import net.sf.okapi.filters.idml.StoryChildElementsParser;

class StoryParser {
    private static final QName WRAPPING_STORY = Namespaces.getIdPackageNamespace().getQName("Story");
    private static final QName STORY = Namespaces.getDefaultNamespace().getQName("Story");
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final XMLEventReader eventReader;

    StoryParser(Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.eventReader = eventReader;
    }

    Story parse() throws XMLStreamException {
        StoryChildElementsMerger storyChildElementsMerger = new StoryChildElementsMerger(this.parameters);
        Story.StoryBuilder storyBuilder = new Story.StoryBuilder();
        storyBuilder.setStartDocumentEvent(this.parseStartDocumentEvent());
        storyBuilder.setWrappingStoryStartElement(this.parseNextStartElement(WRAPPING_STORY));
        storyBuilder.setStoryStartElement(this.parseNextStartElement(STORY));
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && WRAPPING_STORY.equals(event.asEndElement().getName())) {
                storyBuilder.setWrappingStoryEndElement(event.asEndElement());
                break;
            }
            if (event.isEndElement() && STORY.equals(event.asEndElement().getName())) {
                storyBuilder.setStoryEndElement(event.asEndElement());
                continue;
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            storyBuilder.addChildElements(storyChildElementsMerger.merge(new StoryChildElementsParser(event.asStartElement(), this.parameters, this.eventFactory, this.eventReader).parse()));
        }
        storyBuilder.setEndDocumentEvent(this.parseEndDocumentEvent());
        return storyBuilder.build();
    }

    private XMLEvent parseStartDocumentEvent() throws XMLStreamException {
        XMLEvent event = this.eventReader.nextEvent();
        if (!event.isStartDocument()) {
            throw new IllegalStateException("Unexpected structure");
        }
        return event;
    }

    private StartElement parseNextStartElement(QName nextStartElementName) throws XMLStreamException {
        XMLEvent event = this.eventReader.nextTag();
        if (!event.isStartElement() || !nextStartElementName.equals(event.asStartElement().getName())) {
            throw new IllegalStateException("Unexpected structure");
        }
        return event.asStartElement();
    }

    private XMLEvent parseEndDocumentEvent() throws XMLStreamException {
        XMLEvent event = this.eventReader.nextEvent();
        if (!event.isEndDocument()) {
            throw new IllegalStateException("Unexpected structure");
        }
        return event;
    }
}

