/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.StyleRange;

class StyleRangeEventsGenerator {
    private static final QName PARAGRAPH_STYLE_RANGE = Namespaces.getDefaultNamespace().getQName("ParagraphStyleRange");
    private static final QName CHARACTER_STYLE_RANGE = Namespaces.getDefaultNamespace().getQName("CharacterStyleRange");
    private final XMLEventFactory eventFactory;

    StyleRangeEventsGenerator(XMLEventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    List<XMLEvent> generateParagraphStyleRangeStart(StyleDefinitions styleDefinitions) {
        return this.generateStyleRangeStart(PARAGRAPH_STYLE_RANGE, styleDefinitions.getParagraphStyleRange());
    }

    List<XMLEvent> generateParagraphStyleRangeEnd() {
        return this.generateStyleRangeEnd(PARAGRAPH_STYLE_RANGE);
    }

    List<XMLEvent> generateCharacterStyleRangeStart(StyleDefinitions styleDefinitions) {
        return this.generateStyleRangeStart(CHARACTER_STYLE_RANGE, styleDefinitions.getCharacterStyleRange());
    }

    List<XMLEvent> generateCharacterStyleRangeEnd() {
        return this.generateStyleRangeEnd(CHARACTER_STYLE_RANGE);
    }

    private List<XMLEvent> generateStyleRangeStart(QName name, StyleRange styleRange) {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.eventFactory.createStartElement(name, styleRange.getAttributes().iterator(), null));
        events.addAll(styleRange.getProperties().getEvents());
        return events;
    }

    private List<XMLEvent> generateStyleRangeEnd(QName name) {
        return Collections.singletonList(this.eventFactory.createEndElement(name, null));
    }
}

