/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;

final class BlockSkippableElements {
    private final StartElementContext startElementContext;
    private final ElementSkipper insertedRunContentElementSkipper;
    private final ElementSkipper deletedRunContentAndProofingErrorElementSkipper;
    private final ElementSkipper bookmarkElementSkipper;

    BlockSkippableElements(StartElementContext startElementContext) {
        this.startElementContext = startElementContext;
        this.insertedRunContentElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(this.startElementContext.getConditionalParameters(), ElementSkipper.RevisionInlineSkippableElement.RUN_INSERTED_CONTENT);
        this.deletedRunContentAndProofingErrorElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(this.startElementContext.getConditionalParameters(), ElementSkipper.RevisionInlineSkippableElement.RUN_DELETED_CONTENT, ElementSkipper.GeneralInlineSkippableElement.PROOFING_ERROR_ANCHOR);
        this.bookmarkElementSkipper = ElementSkipperFactory.createBookmarkElementSkipper(ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_START, ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_END);
    }

    boolean skip(XMLEvent event) throws XMLStreamException {
        if (event.isStartElement() && this.insertedRunContentElementSkipper.canSkip(event.asStartElement(), this.startElementContext.getStartElement())) {
            this.insertedRunContentElementSkipper.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext, ElementSkipper.InlineSkippableElement.class));
            return true;
        }
        if (ElementSkipper.GeneralElementSkipper.isInsertedRunContentEndElement(event)) {
            return true;
        }
        if (event.isStartElement() && this.deletedRunContentAndProofingErrorElementSkipper.canSkip(event.asStartElement(), this.startElementContext.getStartElement())) {
            this.deletedRunContentAndProofingErrorElementSkipper.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext));
            return true;
        }
        if (event.isStartElement() && this.bookmarkElementSkipper.canSkip(event.asStartElement(), null)) {
            this.bookmarkElementSkipper.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), this.startElementContext));
            return true;
        }
        return false;
    }
}

