/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEvents;

public class ExcelWorksheet {
    private static final char COLUMN_INDEX_PART_MINIMUM = 'A';
    private static final char COLUMN_INDEX_PART_MAXIMUM = 'Z';
    private static final Pattern cellCoordinatePattern = Pattern.compile("[A-Z]{1,3}(\\d+)");
    private XMLEventFactory eventFactory;
    private SharedStringMap stringTable;
    private Set<String> excludedColumns;
    private Set<Integer> excludedRows;
    private Set<String> excludedColors;
    private List<MergeArea> mergeAreas;
    private ExcelStyles styles;
    private boolean excludeHiddenRowsAndColumns;
    private boolean isSheetHidden;
    private Relationships worksheetRels;
    private Map<String, Boolean> tableVisibilityMap;
    static final QName ROW = Namespaces.SpreadsheetML.getQName("row");
    static final QName COL = Namespaces.SpreadsheetML.getQName("col");
    static final QName CELL = Namespaces.SpreadsheetML.getQName("c");
    static final QName VALUE = Namespaces.SpreadsheetML.getQName("v");
    static final QName TABLE = Namespaces.SpreadsheetML.getQName("tablePart");
    static final QName MERGE_CELL = Namespaces.SpreadsheetML.getQName("mergeCell");
    static final QName CELL_LOCATION;
    static final QName ROW_NUMBER;
    static final QName CELL_TYPE;
    static final QName CELL_STYLE;
    static final QName HIDDEN;
    static final QName MIN;
    static final QName MAX;
    static final QName REF;

    public ExcelWorksheet(XMLEventFactory eventFactory, SharedStringMap stringTable, ExcelStyles styles, Relationships worksheetRels, Map<String, Boolean> tableVisibilityMap, boolean isSheetHidden, Set<String> excludedColumns, Set<String> excludedColors, boolean excludeHiddenRowsAndColumns) {
        this.eventFactory = eventFactory;
        this.stringTable = stringTable;
        this.styles = styles;
        this.worksheetRels = worksheetRels;
        this.tableVisibilityMap = tableVisibilityMap;
        this.isSheetHidden = isSheetHidden;
        this.excludedColumns = new HashSet<String>(excludedColumns);
        this.excludedRows = new HashSet<Integer>();
        this.mergeAreas = new ArrayList<MergeArea>();
        this.excludedColors = excludedColors;
        this.excludeHiddenRowsAndColumns = excludeHiddenRowsAndColumns;
    }

    void parse(XMLEventReader reader, XMLEventWriter writer) throws IOException, XMLStreamException {
        boolean excluded = false;
        boolean inValue = false;
        boolean isSharedString = false;
        XmlEventCollector collector = this.collectMergeHiddenData(reader);
        for (XMLEvent e : collector.getEvents()) {
            if (e.isStartElement()) {
                StartElement el = e.asStartElement();
                if (el.getName().equals(CELL)) {
                    Attribute typeAttr = el.getAttributeByName(CELL_TYPE);
                    if (typeAttr != null && typeAttr.getValue().equals("s")) {
                        excluded = this.isCellHidden(el.getAttributeByName(CELL_LOCATION).getValue());
                        isSharedString = true;
                        Attribute styleAttr = el.getAttributeByName(CELL_STYLE);
                        if (styleAttr != null) {
                            int styleIndex = Integer.parseInt(styleAttr.getValue());
                            ExcelStyles.CellStyle style = this.styles.getCellStyle(styleIndex);
                            for (String excludedColor : this.excludedColors) {
                                if (!style.fill.matchesColor(excludedColor)) continue;
                                excluded = true;
                                break;
                            }
                        }
                    }
                } else if (el.getName().equals(VALUE)) {
                    inValue = true;
                } else if (el.getName().equals(TABLE)) {
                    String relId = XMLEventHelpers.getAttributeValue(el, Relationships.ATTR_REL_ID);
                    Relationships.Rel tableRel = this.worksheetRels.getRelById(relId);
                    this.tableVisibilityMap.put(tableRel.target, !this.isSheetHidden);
                }
            } else if (e.isEndElement()) {
                EndElement el = e.asEndElement();
                if (el.getName().equals(CELL)) {
                    excluded = false;
                    isSharedString = false;
                } else if (el.getName().equals(VALUE)) {
                    inValue = false;
                }
            } else if (e.isCharacters() && inValue && isSharedString) {
                int origIndex = ExcelWorksheet.getSharedStringIndex(e.asCharacters().getData());
                int newIndex = this.stringTable.createEntryForString(origIndex, excluded).getNewIndex();
                e = this.eventFactory.createCharacters(String.valueOf(newIndex));
            }
            writer.add(e);
        }
    }

    private XmlEventCollector collectMergeHiddenData(XMLEventReader xmlEventReader) throws XMLStreamException {
        XmlEventCollector collector = new XmlEventCollector();
        while (xmlEventReader.hasNext()) {
            XMLEvent e = xmlEventReader.nextEvent();
            collector.addEvent(e);
            if (!e.isStartElement()) continue;
            StartElement el = e.asStartElement();
            if (e.isStartElement() && e.asStartElement().getName().equals(MERGE_CELL)) {
                this.mergeAreas.add(new MergeArea(e.asStartElement().getAttributeByName(REF).getValue()));
                continue;
            }
            if (el.getName().equals(ROW)) {
                if (!this.isHidden(el)) continue;
                Integer numberOfHiddenRow = Integer.parseInt(el.getAttributeByName(ROW_NUMBER).getValue());
                this.excludedRows.add(numberOfHiddenRow);
                continue;
            }
            if (!el.getName().equals(COL) || !this.isHidden(el)) continue;
            this.excludedColumns.addAll(this.extractColumnNames(el));
        }
        return collector;
    }

    private boolean isHidden(StartElement el) {
        return this.excludeHiddenRowsAndColumns && (this.isSheetHidden || this.parseOptionalBooleanAttribute(el, HIDDEN, false));
    }

    private boolean parseOptionalBooleanAttribute(StartElement el, QName attrName, boolean defaultValue) {
        Attribute a = el.getAttributeByName(attrName);
        if (a == null) {
            return defaultValue;
        }
        String v = a.getValue();
        if ("true".equals(v) || "1".equals(v)) {
            return true;
        }
        if ("false".equals(v) || "0".equals(v)) {
            return false;
        }
        return defaultValue;
    }

    List<String> extractColumnNames(StartElement el) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            int min = Integer.parseInt(el.getAttributeByName(MIN).getValue());
            int max = Integer.parseInt(el.getAttributeByName(MAX).getValue());
            for (int i = min; i <= max; ++i) {
                names.add(ExcelWorksheet.indexToColumnName(i));
            }
            return names;
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new OkapiBadFilterInputException("Invalid <col> element", e);
        }
    }

    static String indexToColumnName(int index) {
        StringBuilder sb = new StringBuilder();
        while (index > 0) {
            int modulo = (index - 1) % 26;
            sb.insert(0, (char)(65 + modulo));
            index = (index - modulo) / 26;
        }
        return sb.toString();
    }

    private static int getSharedStringIndex(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Unexpected shared string index '" + value + "'");
        }
    }

    private static String getColumn(String location) {
        char[] buf = location.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (!Character.isDigit(buf[i])) continue;
            return location.substring(0, i);
        }
        throw new IllegalStateException("Unexpected worksheet cell location '" + location + "'");
    }

    private String getRow(String location) {
        Matcher matcher = cellCoordinatePattern.matcher(location);
        matcher.find();
        return matcher.group(1);
    }

    private boolean isCellHidden(String location) {
        boolean excluded;
        String currentColumn = ExcelWorksheet.getColumn(location);
        String currentRow = this.getRow(location);
        boolean bl = excluded = this.excludedColumns.contains(currentColumn) || this.excludedRows.contains(Integer.parseInt(currentRow));
        if (!excluded) {
            return false;
        }
        MergeArea mergedArea = this.getMergedArea(currentRow, currentColumn);
        if (mergedArea == null) {
            return true;
        }
        Intersection intersection = this.getIntersectionWithHiddenArea(mergedArea);
        return Intersection.PARTIAL != intersection;
    }

    private Intersection getIntersectionWithHiddenArea(MergeArea mergedArea) {
        List<String> columnsRange = this.getColumnsRange(mergedArea.getLeftColumn(), mergedArea.getRightColumn());
        Iterator<String> columnIterator = columnsRange.iterator();
        int mergedColumnNumber = 0;
        int intersectedWithHiddenColumns = 0;
        while (columnIterator.hasNext()) {
            ++mergedColumnNumber;
            if (!this.excludedColumns.contains(columnIterator.next())) continue;
            ++intersectedWithHiddenColumns;
        }
        if (mergedColumnNumber == intersectedWithHiddenColumns) {
            return Intersection.FULL;
        }
        int mergedRowNumber = 0;
        int intersectedWithHiddenRows = 0;
        int topRow = Integer.parseInt(mergedArea.getTopRow());
        int bottomRow = Integer.parseInt(mergedArea.getBottomRow());
        for (int i = topRow; i <= bottomRow; ++i) {
            ++mergedRowNumber;
            if (!this.excludedRows.contains(i)) continue;
            ++intersectedWithHiddenRows;
        }
        if (mergedRowNumber == intersectedWithHiddenRows) {
            return Intersection.FULL;
        }
        if (mergedColumnNumber > intersectedWithHiddenColumns && mergedRowNumber > intersectedWithHiddenRows) {
            return Intersection.PARTIAL;
        }
        if (mergedColumnNumber != 0 && intersectedWithHiddenColumns == 0 && mergedRowNumber != 0 && intersectedWithHiddenRows == 0) {
            return Intersection.NONE;
        }
        throw new OkapiException("The merge area has a wrong configuration");
    }

    private List<String> getColumnsRange(String startColumnIndex, String endColumnIndex) {
        ArrayList<String> columns = new ArrayList<String>();
        String columnIndex = startColumnIndex;
        columns.add(columnIndex);
        while (!columnIndex.equals(endColumnIndex)) {
            columnIndex = this.incrementColumnIndex(columnIndex);
            columns.add(columnIndex);
        }
        return columns;
    }

    private String incrementColumnIndex(String columnIndex) {
        return this.incrementColumnIndexPart(columnIndex.toCharArray(), columnIndex.length() - 1);
    }

    private String incrementColumnIndexPart(char[] columnIndexParts, int partPosition) {
        if (0 > partPosition) {
            return 'A' + new String(columnIndexParts);
        }
        char part = columnIndexParts[partPosition];
        if ('Z' == part) {
            columnIndexParts[partPosition] = 65;
            return this.incrementColumnIndexPart(columnIndexParts, --partPosition);
        }
        columnIndexParts[partPosition] = part = (char)(part + '\u0001');
        return new String(columnIndexParts);
    }

    private MergeArea getMergedArea(String currentRow, String currentColumn) {
        for (MergeArea area : this.mergeAreas) {
            if (this.compareColumns(area.getLeftColumn(), currentColumn) > 0 || this.compareColumns(currentColumn, area.getRightColumn()) > 0 || Integer.parseInt(area.getTopRow()) > Integer.parseInt(currentRow) || Integer.parseInt(currentRow) > Integer.parseInt(area.getBottomRow())) continue;
            return area;
        }
        return null;
    }

    private int compareColumns(String column1, String column2) {
        if (column1.compareTo(column2) == 0) {
            return 0;
        }
        if (column1.length() < column2.length()) {
            return -1;
        }
        if (column1.length() == column2.length()) {
            return column1.compareTo(column2);
        }
        if (column1.length() > column2.length()) {
            return 1;
        }
        throw new OkapiException("Matching columns have a wrong format");
    }

    static {
        ROW_NUMBER = CELL_LOCATION = new QName("r");
        CELL_TYPE = new QName("t");
        CELL_STYLE = new QName("s");
        HIDDEN = new QName("hidden");
        MIN = new QName("min");
        MAX = new QName("max");
        REF = new QName("ref");
    }

    private class MergeArea {
        private String leftColumn;
        private String rightColumn;
        private String topRow;
        private String bottomRow;

        MergeArea(String area) {
            String[] cornerCoordinates = area.split(":");
            if (cornerCoordinates.length != 2) {
                return;
            }
            this.topRow = ExcelWorksheet.this.getRow(cornerCoordinates[0]);
            this.leftColumn = ExcelWorksheet.getColumn(cornerCoordinates[0]);
            this.bottomRow = ExcelWorksheet.this.getRow(cornerCoordinates[1]);
            this.rightColumn = ExcelWorksheet.getColumn(cornerCoordinates[1]);
        }

        public String getLeftColumn() {
            return this.leftColumn;
        }

        public String getRightColumn() {
            return this.rightColumn;
        }

        public String getTopRow() {
            return this.topRow;
        }

        public String getBottomRow() {
            return this.bottomRow;
        }
    }

    static class XmlEventCollector
    implements XMLEvents {
        private List<XMLEvent> xmlEvents = new ArrayList<XMLEvent>();

        XmlEventCollector() {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.xmlEvents;
        }

        public void addEvent(XMLEvent event) {
            this.xmlEvents.add(event);
        }
    }

    private static enum Intersection {
        FULL,
        PARTIAL,
        NONE;

    }
}

