/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelDocument;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;

class OpenXMLZipFileProxy
extends OpenXMLZipFile {
    private final IFilter subfilter;
    private final Map<String, String> sharedStrings;
    private final EncoderManager encoderManager;

    OpenXMLZipFileProxy(ZipFile zipFile, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String encoding, EncoderManager encoderManager, IFilter subfilter, Map<String, String> sharedStrings) {
        super(zipFile, inputFactory, outputFactory, eventFactory, encoding);
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStrings = sharedStrings;
    }

    @Override
    public DocumentType createDocument(ConditionalParameters params) throws XMLStreamException, IOException {
        DocumentType doc;
        this.initializeContentTypes();
        this.mainDocumentTarget = this.getRelationshipTarget();
        switch (this.contentTypes.getContentType(this.mainDocumentTarget)) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
                doc = new ExcelDocument(this, params, this.encoderManager, this.subfilter, this.sharedStrings);
                break;
            }
            default: {
                doc = super.createDocument(params);
            }
        }
        doc.initialize();
        return doc;
    }
}

