/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsDenormalizer;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemParser;
import net.sf.okapi.filters.openxml.StringItemTextUnitMapper;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class SharedStringsPartHandler
extends GenericPartHandler {
    private final StyleDefinitions styleDefinitions;
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final SharedStringMap sharedStringMap;
    private IdGenerator textUnitId;
    private IdGenerator nestedBlockId;
    private XMLEventReader xmlReader;
    private Iterator<Event> filterEventIterator;
    private String docId;
    private String subDocId;
    private LocaleId sourceLocale;
    private File rewrittenStringsTable;
    private int sharedStringIndex = 0;

    SharedStringsPartHandler(ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry, StyleDefinitions styleDefinitions, EncoderManager encoderManager, IFilter subfilter, SharedStringMap sharedStringMap) {
        super(cparams, entry.getName());
        this.zipFile = zipFile;
        this.entry = entry;
        this.styleDefinitions = styleDefinitions;
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStringMap = sharedStringMap;
        this.textUnitId = new IdGenerator(this.partName, "tu");
        this.nestedBlockId = new IdGenerator(null);
        this.markup = new Block.BlockMarkup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event open(String docId, String subDocId, LocaleId sourceLocale) throws IOException, XMLStreamException {
        this.docId = docId;
        this.subDocId = subDocId;
        this.sourceLocale = sourceLocale;
        SharedStringsDenormalizer deno = new SharedStringsDenormalizer(this.zipFile.getEventFactory(), this.sharedStringMap);
        XMLEventReader reader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8));
        this.rewrittenStringsTable = File.createTempFile("sharedStrings", ".xml");
        XMLEventWriter writer = this.zipFile.getOutputFactory().createXMLEventWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.rewrittenStringsTable), StandardCharsets.UTF_8));
        deno.process(reader, writer);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.rewrittenStringsTable));
        this.xmlReader = XMLInputFactory.newInstance().createXMLEventReader(is);
        try {
            this.process();
        }
        finally {
            if (this.xmlReader != null) {
                this.xmlReader.close();
            }
            this.rewrittenStringsTable.delete();
        }
        return this.createStartSubDocumentEvent(docId, subDocId);
    }

    private void process() throws XMLStreamException {
        XMLEvent e = null;
        while (this.xmlReader.hasNext()) {
            e = this.xmlReader.nextEvent();
            if (XMLEventHelpers.isStringItemStartEvent(e) && this.sharedStringMap.isStringVisible(this.sharedStringIndex++)) {
                this.flushDocumentPart();
                StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.xmlReader, this.zipFile.getEventFactory(), this.params);
                StringItem stringItem = new StringItemParser(startElementContext, this.nestedBlockId, this.styleDefinitions).parse();
                List<ITextUnit> textUnits = new StringItemTextUnitMapper(stringItem, this.textUnitId).map();
                if (textUnits.isEmpty()) {
                    this.addBlockChunksToDocumentPart(stringItem.getChunks());
                    continue;
                }
                if (this.subfilter != null && !stringItem.isStyled()) {
                    this.addSubfilteredEvents(textUnits);
                    continue;
                }
                this.addTextUnitEvents(textUnits);
                continue;
            }
            this.addEventToDocumentPart(e);
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private void addTextUnitEvents(List<ITextUnit> textUnits) {
        for (ITextUnit tu : textUnits) {
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
        }
    }

    private void addSubfilteredEvents(List<ITextUnit> textUnits) {
        int subfilterIndex = 0;
        for (ITextUnit tu : textUnits) {
            SubFilter sf = new SubFilter(this.subfilter, this.encoderManager.getEncoder(), ++subfilterIndex, tu.getId(), tu.getName());
            Throwable throwable = null;
            try {
                this.filterEvents.addAll(sf.getEvents(new RawDocument(tu.getSource().getFirstContent().getText(), this.sourceLocale)));
                this.filterEvents.add(sf.createRefEvent(tu));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sf == null) continue;
                if (throwable != null) {
                    try {
                        sf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sf.close();
            }
        }
    }

    private void addMarkupComponentToDocumentPart(MarkupComponent markupComponent) {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList();
        }
        this.markup.addComponent(markupComponent);
    }

    private void addBlockChunksToDocumentPart(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk instanceof Markup) {
                for (MarkupComponent markupComponent : ((Markup)chunk).getComponents()) {
                    this.addMarkupComponentToDocumentPart(markupComponent);
                }
                continue;
            }
            this.documentPartEvents.addAll(chunk.getEvents());
        }
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

