/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.layerprovider.ILayerProvider;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openxml.BidirectionalityClarifier;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.BlockTextUnitWriter;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.TextUnitProperties;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class StyledTextSkeletonWriter
implements ISkeletonWriter {
    private final GenericSkeletonWriter genericSkeletonWriter;
    private final XMLEventFactory eventFactory;
    private final String partName;
    private final ConditionalParameters cparams;
    private LocaleId targetLocale;
    private IdGenerator nestedBlockIds = new IdGenerator(null);
    private Map<String, String> processedReferents = new HashMap<String, String>();
    private Deque<Referring> referrings = new ArrayDeque<Referring>();

    StyledTextSkeletonWriter(GenericSkeletonWriter genericSkeletonWriter, XMLEventFactory eventFactory, String partName, ConditionalParameters cparams) {
        this.genericSkeletonWriter = genericSkeletonWriter;
        this.eventFactory = eventFactory;
        this.partName = partName;
        this.cparams = cparams;
    }

    void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public void close() {
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        this.targetLocale = outputLocale;
        this.genericSkeletonWriter.setOutputLoc(outputLocale);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    @Override
    public String processEndDocument(Ending resource) {
        return "";
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    @Override
    public String processEndSubDocument(Ending resource) {
        return "";
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        return "";
    }

    @Override
    public String processEndGroup(Ending resource) {
        return "";
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        String serialized;
        if (!"".equals(this.cparams.getSubfilter()) && null == tu.getSkeleton() || tu.getSkeleton() instanceof GenericSkeleton) {
            return this.genericSkeletonWriter.processTextUnit(tu);
        }
        TextContainer target = this.getTargetForOutput(tu);
        List<Chunk> chunks = null;
        XMLEventSerializer xmlWriter = new XMLEventSerializer();
        if (tu.getSkeleton() != null) {
            if (!(tu.getSkeleton() instanceof BlockSkeleton)) {
                throw new IllegalArgumentException("TextUnit " + tu.getId() + " has no associated block content");
            }
            BlockSkeleton skel = (BlockSkeleton)tu.getSkeleton();
            Block block = skel.block();
            chunks = block.getChunks();
            Nameable nameableMarkupComponent = ((Markup)chunks.get(0)).getNameableMarkupComponent();
            BidirectionalityClarifier bidirectionalityClarifier = new BidirectionalityClarifier(new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI()), new ClarificationParameters(LocaleId.isBidirectional(this.targetLocale), LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale), this.targetLocale.toString()));
            bidirectionalityClarifier.clarifyMarkup((Markup)chunks.get(0));
            xmlWriter.add(chunks.get(0));
            new BlockTextUnitWriter(this.eventFactory, block.getRunName(), block.getTextName(), skel.hiddenCodes(), skel.visibleCodes(), xmlWriter, bidirectionalityClarifier, this.cparams).write(target);
            xmlWriter.add(chunks.get(chunks.size() - 1));
            serialized = xmlWriter.toString();
        } else {
            serialized = xmlWriter.getAttributeEncoder().encode(target.toString(), EncoderContext.INLINE);
        }
        return this.processReferences(tu, serialized);
    }

    private String processReferences(ITextUnit tu, String serialized) {
        String output;
        if (tu.isReferent()) {
            if (TextUnitProperties.integer(tu, "references") != 0) {
                this.referrings.push(new Referring(serialized, TextUnitProperties.integer(tu, "references")));
                output = "";
            } else {
                this.processedReferents.put(this.nestedBlockIds.createId(), serialized);
                this.referrings.peek().foundReferents++;
                if (this.referrings.peek().isLastFoundReferent()) {
                    String resolved = this.resolveReferences(this.referrings.pop().serialized);
                    output = !this.referrings.isEmpty() ? this.processReferences(tu, resolved) : resolved;
                } else {
                    output = "";
                }
            }
        } else if (TextUnitProperties.integer(tu, "references") == 0) {
            output = serialized;
        } else {
            this.referrings.push(new Referring(serialized, TextUnitProperties.integer(tu, "references")));
            output = "";
        }
        return output;
    }

    private String resolveReferences(String original) {
        StringBuilder sb = new StringBuilder(original);
        Object[] markerInfo = TextFragment.getRefMarker(sb);
        while (markerInfo != null) {
            String processedReferent = this.processedReferents.get(markerInfo[0]);
            sb.replace((Integer)markerInfo[1], (Integer)markerInfo[2], processedReferent);
            markerInfo = TextFragment.getRefMarker(sb);
        }
        return sb.toString();
    }

    private TextContainer getTargetForOutput(ITextUnit tu) {
        if (this.targetLocale == null) {
            return tu.getSource();
        }
        TextContainer trgCont = tu.getTarget(this.targetLocale);
        if (trgCont == null || trgCont.isEmpty()) {
            return tu.getSource();
        }
        return trgCont;
    }

    @Override
    public String processDocumentPart(DocumentPart documentPart) {
        if (documentPart.getSkeleton() instanceof GenericSkeleton) {
            return this.genericSkeletonWriter.processDocumentPart(documentPart);
        }
        MarkupSkeleton markupSkeleton = (MarkupSkeleton)documentPart.getSkeleton();
        Markup markup = markupSkeleton.getMarkup();
        Nameable nameableMarkupComponent = markup.getNameableMarkupComponent();
        if (null != nameableMarkupComponent) {
            BidirectionalityClarifier bidirectionalityClarifier = new BidirectionalityClarifier(new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI()), new ClarificationParameters(LocaleId.isBidirectional(this.targetLocale), LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale), this.targetLocale.toString()));
            bidirectionalityClarifier.clarifyMarkup(markup);
        }
        return XMLEventSerializer.serialize(markup);
    }

    @Override
    public String processStartSubfilter(StartSubfilter resource) {
        return this.genericSkeletonWriter.processStartSubfilter(resource);
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        return this.genericSkeletonWriter.processEndSubfilter(resource);
    }

    private static final class Referring {
        private final String serialized;
        private final int references;
        private int foundReferents;

        Referring(String serialized, int references) {
            this.serialized = serialized;
            this.references = references;
        }

        boolean isLastFoundReferent() {
            return this.references == this.foundReferents;
        }
    }
}

