/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Base64;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Manifest
implements IAnnotation {
    public static final String EXTRACTIONTYPE_NONE = "none";
    public static final String EXTRACTIONTYPE_XLIFF = "xliff";
    public static final String EXTRACTIONTYPE_XLIFF2 = "xliff2";
    public static final String EXTRACTIONTYPE_PO = "po";
    public static final String EXTRACTIONTYPE_RTF = "rtf";
    public static final String EXTRACTIONTYPE_VERSIFIED_RTF = "versified+rtf";
    public static final String EXTRACTIONTYPE_VERSIFIED = "versified";
    public static final String EXTRACTIONTYPE_XLIFFRTF = "xliff+rtf";
    public static final String EXTRACTIONTYPE_OMEGAT = "omegat";
    public static final String EXTRACTIONTYPE_TRANSIFEX = "transifex";
    public static final String EXTRACTIONTYPE_ONTRAM = "ontram";
    public static final String EXTRACTIONTYPE_TABLE = "table";
    public static final String VERSION = "2";
    public static final String MANIFEST_FILENAME = "manifest";
    public static final String MANIFEST_EXTENSION = ".rkm";
    private static final String TIP_VERSION = "1.3";
    private LinkedHashMap<Integer, MergingInfo> docs = new LinkedHashMap();
    private String tempPackageRoot = "";
    private String packageRoot = "";
    private String packageId;
    private String projectId;
    private LocaleId sourceLoc;
    private LocaleId targetLoc;
    private String inputRoot;
    private String originalSubDir = "";
    private String sourceSubDir = "";
    private String targetSubDir = "";
    private String tmSubDir = "";
    private String mergeSubDir = "";
    private String skelSubDir = "";
    private String originalDir;
    private String tempOriginalDir;
    private String tempSkelDir;
    private String tempSourceDir;
    private String tempTargetDir;
    private String mergeDir;
    private String skelDir;
    private String tempTmDir;
    private String creatorParams;
    private boolean useApprovedOnly;
    private boolean updateApprovedFlag;
    private String date;
    private boolean generateTIPManifest = false;
    private String libVersion = "";

    public Manifest() {
        this.updateFullDirectories();
        this.useApprovedOnly = false;
        this.updateApprovedFlag = false;
    }

    public Map<Integer, MergingInfo> getItems() {
        return this.docs;
    }

    public MergingInfo getItem(int docID) {
        return this.docs.get(docID);
    }

    public String getLibVersion() {
        return this.libVersion;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLoc;
    }

    public LocaleId getTargetLocale() {
        return this.targetLoc;
    }

    public String getCreatorParameters() {
        return this.creatorParams;
    }

    public boolean getUseApprovedOnly() {
        return this.useApprovedOnly;
    }

    public void setUseApprovedOnly(boolean value) {
        this.useApprovedOnly = value;
    }

    public boolean getUpdateApprovedFlag() {
        return this.updateApprovedFlag;
    }

    public void setUpdateApprovedFlag(boolean value) {
        this.updateApprovedFlag = value;
    }

    public boolean getGenerateTIPManifest() {
        return this.generateTIPManifest;
    }

    public void setGenerateTIPManifest(boolean generateTIPManifest) {
        this.generateTIPManifest = generateTIPManifest;
    }

    public String getInputRoot() {
        return this.inputRoot;
    }

    public String getPackageRoot() {
        return this.packageRoot;
    }

    public String getTempPackageRoot() {
        return this.tempPackageRoot;
    }

    public void setSubDirectories(String originalSubDir, String sourceSubDir, String targetSubDir, String mergeSubDir, String tmSubDir, String skelSubDir, boolean overwrite) {
        if (originalSubDir != null && (overwrite || Util.isEmpty(this.originalSubDir))) {
            this.originalSubDir = originalSubDir;
        }
        if (sourceSubDir != null && (overwrite || Util.isEmpty(this.sourceSubDir))) {
            this.sourceSubDir = sourceSubDir;
        }
        if (targetSubDir != null && (overwrite || Util.isEmpty(this.targetSubDir))) {
            this.targetSubDir = targetSubDir;
        }
        if (mergeSubDir != null && (overwrite || Util.isEmpty(this.mergeSubDir))) {
            this.mergeSubDir = mergeSubDir;
        }
        if (tmSubDir != null && (overwrite || Util.isEmpty(this.tmSubDir))) {
            this.tmSubDir = tmSubDir;
        }
        if (skelSubDir != null && (overwrite || Util.isEmpty(this.skelSubDir))) {
            this.skelSubDir = skelSubDir;
        }
        this.updateFullDirectories();
    }

    public String getTempOriginalDirectory() {
        return this.tempOriginalDir;
    }

    public String getTempSkelDirectory() {
        return this.tempSkelDir;
    }

    public String getTempSourceDirectory() {
        return this.tempSourceDir;
    }

    public String getTempTargetDirectory() {
        return this.tempTargetDir;
    }

    public String getOriginalDirectory() {
        return this.originalDir;
    }

    public String getSkeletonDirectory() {
        return this.skelDir;
    }

    public String getMergeDirectory() {
        return this.mergeDir;
    }

    public String getTempTmDirectory() {
        return this.tempTmDir;
    }

    public String getDate() {
        return this.date;
    }

    public void setInformation(String packageRoot, LocaleId srcLoc, LocaleId trgLoc, String inputRoot, String packageId, String projectId, String creatorParams, String tempPackageRoot) {
        this.sourceLoc = srcLoc;
        this.targetLoc = trgLoc;
        this.inputRoot = Util.ensureSeparator(inputRoot, false);
        this.packageRoot = Util.ensureSeparator(packageRoot, false);
        this.tempPackageRoot = Util.ensureSeparator(tempPackageRoot, false);
        this.packageId = packageId;
        this.projectId = projectId;
        this.updateFullDirectories();
        this.creatorParams = creatorParams;
    }

    public void addDocument(int docId, String extractionType, String relativeInputPath, String filterId, String filterParameters, String inputEncoding, String relativeTargetPath, String targetEncoding) {
        this.docs.put(docId, new MergingInfo(docId, extractionType, relativeInputPath, filterId, filterParameters, inputEncoding, relativeTargetPath, targetEncoding));
    }

    public String getPath() {
        return this.packageRoot + MANIFEST_FILENAME + MANIFEST_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String dir) {
        if (this.generateTIPManifest) {
            return;
        }
        try (XMLWriter writer = null;){
            String outputPath = this.getPath();
            if (dir != null) {
                outputPath = Util.ensureSeparator(dir, false) + MANIFEST_FILENAME + MANIFEST_EXTENSION;
            }
            writer = new XMLWriter(outputPath);
            writer.writeStartDocument();
            writer.writeComment("=================================================================", true);
            writer.writeComment("PLEASE, DO NOT RENAME, MOVE, MODIFY OR ALTER IN ANY WAY THIS FILE", true);
            writer.writeComment("=================================================================", true);
            writer.writeStartElement(MANIFEST_FILENAME);
            writer.writeAttributeString("version", VERSION);
            writer.writeAttributeString("libVersion", this.getClass().getPackage().getImplementationVersion());
            writer.writeAttributeString("projectId", this.projectId);
            writer.writeAttributeString("packageId", this.packageId);
            writer.writeAttributeString("source", this.sourceLoc.toString());
            writer.writeAttributeString("target", this.targetLoc.toString());
            writer.writeAttributeString("originalSubDir", this.originalSubDir.replace('\\', '/'));
            if (this.skelSubDir != null) {
                writer.writeAttributeString("skeletonSubDir", this.skelSubDir.replace('\\', '/'));
            }
            writer.writeAttributeString("sourceSubDir", this.sourceSubDir.replace('\\', '/'));
            writer.writeAttributeString("targetSubDir", this.targetSubDir.replace('\\', '/'));
            writer.writeAttributeString("mergeSubDir", this.mergeSubDir.replace('\\', '/'));
            writer.writeAttributeString("tmSubDir", this.tmSubDir.replace('\\', '/'));
            SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            this.date = DF.format(new Date());
            writer.writeAttributeString("date", this.date);
            writer.writeAttributeString("useApprovedOnly", this.useApprovedOnly ? "1" : "0");
            writer.writeAttributeString("updateApprovedFlag", this.updateApprovedFlag ? "1" : "0");
            writer.writeLineBreak();
            writer.writeStartElement("creatorParameters");
            writer.writeString(Base64.encodeString(this.creatorParams.toString()));
            writer.writeEndElementLineBreak();
            for (MergingInfo item : this.docs.values()) {
                writer.writeRawXML(item.writeToXML("doc", true));
                writer.writeLineBreak();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTIPManifest(String dir, List<String> tms) {
        try (XMLWriter writer = null;){
            String tippManifestPath = this.getPath();
            tippManifestPath = dir != null ? Util.ensureSeparator(dir, false) + MANIFEST_FILENAME + ".xml" : tippManifestPath.replace(MANIFEST_EXTENSION, ".xml");
            writer = new XMLWriter(tippManifestPath);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            String outputDate = df.format(new Date());
            writer.writeStartDocument();
            writer.writeComment("EXPERIMENTAL OUTPUT ONLY!", true);
            writer.writeStartElement("TIPManifest");
            writer.writeAttributeString("version", TIP_VERSION);
            writer.writeStartElement("GlobalDescriptor");
            writer.writeElementString("UniquePackageID", this.packageId);
            writer.writeStartElement("PackageCreator");
            writer.writeElementString("CreatorName", "unspecified");
            writer.writeLineBreak();
            writer.writeElementString("CreatorID", "urn:unspecified");
            writer.writeLineBreak();
            writer.writeElementString("CreatorUpdate", outputDate);
            writer.writeLineBreak();
            writer.writeStartElement("ContributorTool");
            writer.writeElementString("ToolName", this.getClass().getName());
            writer.writeLineBreak();
            writer.writeElementString("ToolID", "urn:" + this.getClass().getName().replace('.', ':'));
            writer.writeLineBreak();
            writer.writeElementString("ToolVersion", "1.0");
            writer.writeLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeElementString("Communication", "FTP");
            writer.writeLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeStartElement("OrderAction");
            writer.writeStartElement("OrderTask");
            writer.writeElementString("TaskType", "Translate");
            writer.writeLineBreak();
            writer.writeElementString("SourceLanguage", this.getSourceLocale().toString());
            writer.writeLineBreak();
            writer.writeElementString("TargetLanguage", this.getTargetLocale().toString());
            writer.writeLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeStartElement("PackageObjects");
            writer.writeStartElement("PackageObjectSection");
            writer.writeAttributeString("sectionname", "input");
            int seq = 1;
            for (MergingInfo item : this.docs.values()) {
                writer.writeStartElement("ObjectFile");
                writer.writeAttributeString("localizable", "no");
                writer.writeAttributeString("sequence", String.valueOf(seq));
                writer.writeElementString("Type", item.getFilterId());
                writer.writeElementString("LocationPath", item.getRelativeInputPath().substring(1));
                writer.writeEndElementLineBreak();
                ++seq;
            }
            writer.writeEndElementLineBreak();
            writer.writeStartElement("PackageObjectSection");
            writer.writeAttributeString("sectionname", "bilingual");
            seq = 1;
            for (MergingInfo item : this.docs.values()) {
                if (item.getExtractionType().equals(EXTRACTIONTYPE_NONE)) continue;
                writer.writeStartElement("ObjectFile");
                writer.writeAttributeString("localizable", "yes");
                writer.writeAttributeString("sequence", String.valueOf(seq));
                writer.writeElementString("Type", "XLIFF 2.0");
                writer.writeElementString("LocationPath", item.getRelativeInputPath().substring(1) + ".xlf");
                writer.writeEndElementLineBreak();
                ++seq;
            }
            writer.writeEndElementLineBreak();
            if (!tms.isEmpty()) {
                writer.writeStartElement("PackageObjectSection");
                writer.writeAttributeString("sectionname", "tm");
                seq = 1;
                for (String path : tms) {
                    writer.writeStartElement("ObjectFile");
                    writer.writeAttributeString("localizable", "no");
                    writer.writeAttributeString("sequence", String.valueOf(seq));
                    writer.writeElementString("Type", "TMX");
                    writer.writeElementString("LocationPath", path);
                    writer.writeEndElementLineBreak();
                    ++seq;
                }
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElementLineBreak();
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }

    public void load(File inputFile) {
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            Document doc = docFac.newDocumentBuilder().parse(inputFile);
            NodeList NL = doc.getElementsByTagName(MANIFEST_FILENAME);
            if (NL == null) {
                throw new OkapiException("Invalid manifest file.");
            }
            Element elem = (Element)NL.item(0);
            if (elem == null) {
                throw new OkapiException("Invalid manifest file.");
            }
            String tmp = elem.getAttribute("version");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing version attribute.");
            }
            this.libVersion = elem.getAttribute("libVersion");
            tmp = elem.getAttribute("projectId");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing projectId attribute.");
            }
            this.projectId = tmp;
            tmp = elem.getAttribute("packageId");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing packageId attribute.");
            }
            this.packageId = tmp;
            tmp = elem.getAttribute("source");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing source attribute.");
            }
            this.sourceLoc = LocaleId.fromString(tmp);
            tmp = elem.getAttribute("target");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing target attribute.");
            }
            this.targetLoc = LocaleId.fromString(tmp);
            this.date = elem.getAttribute("date");
            if (Util.isEmpty(tmp)) {
                this.date = "Unknown";
            }
            if (Util.isEmpty(tmp = elem.getAttribute("originalSubDir"))) {
                throw new OkapiException("Missing originalSubDir attribute.");
            }
            this.originalSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("skeletonSubDir");
            this.skelSubDir = !Util.isEmpty(tmp) ? tmp.replace('/', File.separatorChar) : null;
            tmp = elem.getAttribute("sourceSubDir");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing sourceSubDir attribute.");
            }
            this.sourceSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("targetSubDir");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing targetSubDir attribute.");
            }
            this.targetSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("mergeSubDir");
            if (Util.isEmpty(tmp)) {
                throw new OkapiException("Missing mergeSubDir attribute.");
            }
            this.mergeSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("tmSubDir");
            this.tmSubDir = Util.isEmpty(tmp) ? "" : tmp.replace('/', File.separatorChar);
            NL = elem.getElementsByTagName("creatorParameters");
            this.creatorParams = NL.getLength() > 0 ? Base64.decodeString(Util.getTextContent(NL.item(0))) : "";
            tmp = elem.getAttribute("useApprovedOnly");
            this.useApprovedOnly = Util.isEmpty(tmp) ? false : !tmp.equals("0");
            tmp = elem.getAttribute("updateApprovedFlag");
            this.updateApprovedFlag = Util.isEmpty(tmp) ? true : !tmp.equals("0");
            this.docs.clear();
            NL = elem.getElementsByTagName("doc");
            for (int i = 0; i < NL.getLength(); ++i) {
                elem = (Element)NL.item(i);
                MergingInfo item = MergingInfo.readFromXML(elem);
                this.docs.put(item.getDocId(), item);
            }
            this.tempPackageRoot = this.packageRoot = Util.ensureSeparator(Util.getDirectoryName(inputFile.getAbsolutePath()), false);
            this.updateFullDirectories();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OkapiException(e);
        }
    }

    private void updateFullDirectories() {
        this.originalDir = Util.ensureSeparator(this.packageRoot + this.originalSubDir, false);
        this.mergeDir = Util.ensureSeparator(this.packageRoot + this.mergeSubDir, false);
        this.skelDir = Util.ensureSeparator(this.packageRoot + this.skelSubDir, false);
        this.tempOriginalDir = Util.ensureSeparator(this.tempPackageRoot + this.originalSubDir, false);
        this.tempSkelDir = Util.ensureSeparator(this.tempPackageRoot + this.skelSubDir, false);
        this.tempSourceDir = Util.ensureSeparator(this.tempPackageRoot + this.sourceSubDir, false);
        this.tempTargetDir = Util.ensureSeparator(this.tempPackageRoot + this.targetSubDir, false);
        this.tempTmDir = Util.ensureSeparator(this.tempPackageRoot + this.tmSubDir, false);
    }

    @Override
    public String toString() {
        return this.projectId + "_" + this.packageId;
    }
}

