/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tex;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.tex.TEXEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEXSkeletonWriter
extends GenericSkeletonWriter
implements ISkeletonWriter {
    private TEXEncoder texencoder;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public TEXSkeletonWriter() {
        this.texencoder = new TEXEncoder();
    }

    @Override
    protected String getContent(ITextUnit tu, LocaleId locToUse, EncoderContext context) {
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(tu.getMimeType());
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = null;
        if (locToUse != null) {
            trgCont = tu.getTarget(locToUse);
            if (trgCont == null || trgCont.isEmpty()) {
                if (this.allowEmptyOutputTarget && this.layer == null) {
                    if (trgCont == null) {
                        trgCont = tu.createTarget(locToUse, false, 0);
                    }
                } else {
                    trgCont = srcCont;
                }
            }
        } else {
            trgCont = srcCont;
        }
        if (!tu.isTranslatable()) {
            context = EncoderContext.TEXT;
        }
        if (srcCont.hasBeenSegmented() || !srcCont.contentIsOneSegment() || trgCont.hasBeenSegmented() || !trgCont.contentIsOneSegment() || trgCont.getAnnotation(AltTranslationsAnnotation.class) != null) {
            return this.getSegmentedText(srcCont, trgCont, locToUse, context, tu.isReferent(), tu.getId());
        }
        TextFragment tf = trgCont.getFirstContent();
        if (this.layer == null) {
            return this.getContent(tf, locToUse, context);
        }
        switch (context) {
            case SKELETON: {
                return this.layer.endCode() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.layer.startCode();
            }
            case INLINE: {
                return this.layer.endInline() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.layer.startInline();
            }
        }
        return this.getContent(tf, locToUse, context);
    }

    private String getSegmentedText(TextContainer srcCont, TextContainer trgCont, LocaleId locToUse, EncoderContext context, boolean isReferent, String tuId) {
        StringBuilder tmp = new StringBuilder();
        AltTranslationsAnnotation atAnn = null;
        for (TextPart part : trgCont) {
            if (part.isSegment()) {
                Segment srcSeg;
                Segment trgSeg = (Segment)part;
                TextFragment trgFrag = trgSeg.text;
                int lev = 0;
                AltTranslation at = null;
                atAnn = trgSeg.getAnnotation(AltTranslationsAnnotation.class);
                if (atAnn != null && (at = atAnn.getFirst()) != null) {
                    lev = at.getCombinedScore();
                }
                if ((srcSeg = srcCont.getSegments().get(trgSeg.id)) == null) {
                    this.logger.warn("No source segment found for target segment seg-id='{}' (TU id='{}'):\n\"{}\".", trgSeg.id, tuId, trgFrag.toText());
                } else if (trgFrag.isEmpty() && !srcSeg.text.isEmpty()) {
                    trgFrag = srcSeg.text;
                    lev = 0;
                }
                if (this.layer == null) {
                    tmp.append(this.texencoder.toNative("placeholder", this.getContent(trgFrag, locToUse, context)));
                    continue;
                }
                switch (context) {
                    case SKELETON: {
                        tmp.append(this.layer.endCode() + this.layer.startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.layer.midSegment(lev) + this.getContent(trgFrag, locToUse, EncoderContext.TEXT) + this.layer.endSegment() + this.layer.startCode());
                        break;
                    }
                    case INLINE: {
                        tmp.append(this.texencoder.toNative("placeholder", this.layer.endInline() + this.layer.startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.layer.midSegment(lev) + this.getContent(trgFrag, locToUse, EncoderContext.TEXT) + this.layer.endSegment() + this.layer.startInline()));
                        break;
                    }
                    default: {
                        tmp.append(this.texencoder.toNative("placeholder", this.layer.startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.layer.midSegment(lev) + this.getContent(trgFrag, locToUse, EncoderContext.TEXT) + this.layer.endSegment()));
                    }
                }
                continue;
            }
            tmp.append(this.getContent(part.text, locToUse, context));
        }
        return tmp.toString();
    }
}

