/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.tmx.Parameters;
import net.sf.okapi.filters.tmx.TmxTu;
import net.sf.okapi.filters.tmx.TmxTuv;
import net.sf.okapi.filters.tmx.TmxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TmxFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean hasNext;
    private XMLStreamReader reader;
    private String docName;
    private int tuId;
    private IdGenerator otherId;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private String encoding;
    private Parameters params;
    private Stack<Boolean> preserveSpaces;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private boolean skipUtWarning;
    private int headerSegType = -1;
    private RawDocument input;
    private StartDocument startDoc;
    private TuvXmlLang tuvTrgType = TuvXmlLang.UNDEFINED;
    private HashMap<String, String> rulesMap = new HashMap();
    private Stack<String> elemStack = new Stack();
    private EncoderManager encoderManager;
    private boolean skipInvalidTu = false;
    public static final int SEGTYPE_SENTENCE = 0;
    public static final int SEGTYPE_PARA = 1;
    public static final int SEGTYPE_OR_SENTENCE = 2;
    public static final int SEGTYPE_OR_PARA = 3;

    public TmxFilter() {
        this.params = new Parameters();
        this.rulesMap.put("<seg>", "<bpt><ept><it><ph><hi><ut>");
        this.rulesMap.put("<sub>", "<bpt><ept><it><ph><hi><ut>");
        this.rulesMap.put("<hi>", "<bpt><ept><it><ph><hi><ut>");
        this.rulesMap.put("<bpt>", "<sub>");
        this.rulesMap.put("<ept>", "<sub>");
        this.rulesMap.put("<it>", "<sub>");
        this.rulesMap.put("<ph>", "<sub>");
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_tmx";
    }

    @Override
    public String getDisplayName() {
        return "TMX Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-tmx+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-tmx+xml", this.getClass().getName(), "TMX", "Configuration for Translation Memory eXchange (TMX) documents.", null, ".tmx;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-tmx+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.input = input;
            this.canceled = false;
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            if (detector.isAutodetected()) {
                input.setEncoding(detector.getEncoding());
                this.reader = fact.createXMLStreamReader(input.getStream(), detector.getEncoding());
            } else {
                this.reader = fact.createXMLStreamReader(input.getStream());
            }
            String realEnc = this.reader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            this.srcLang = input.getSourceLocale();
            if (this.srcLang == null) {
                throw new NullPointerException("Source language not set.");
            }
            this.trgLang = input.getTargetLocale();
            if (this.trgLang == null) {
                throw new NullPointerException("Target language not set.");
            }
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.preserveSpaces = new Stack();
            this.preserveSpaces.push(false);
            this.tuId = 0;
            this.otherId = new IdGenerator(null, "d");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.skipUtWarning = false;
            this.tuvTrgType = TuvXmlLang.UNDEFINED;
            this.startDoc = new StartDocument(this.otherId.createId());
            this.startDoc.setName(this.docName);
            this.startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            this.startDoc.setLocale(this.srcLang);
            this.startDoc.setFilterParameters(this.getParameters());
            this.startDoc.setFilterWriter(this.createFilterWriter());
            this.startDoc.setType("application/x-tmx+xml");
            this.startDoc.setMimeType("application/x-tmx+xml");
            this.startDoc.setMultilingual(true);
            this.startDoc.setLineBreak(this.lineBreak);
            this.skel = new GenericSkeleton();
            this.startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(this.startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>");
            this.startDoc.setSkeleton(this.skel);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private boolean read() throws XMLStreamException {
        this.skel = new GenericSkeleton();
        block12: while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    DocumentPart dp;
                    if (this.reader.getLocalName().equals("tu")) {
                        if (!this.skel.isEmpty(false)) {
                            dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                            this.skel = new GenericSkeleton();
                            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        }
                        return this.processTranslationUnit();
                    }
                    if (this.reader.getLocalName().equals("header")) {
                        PipelineParameters pp = null;
                        String hSegType = this.reader.getAttributeValue(null, "segtype");
                        String hSrcLang = this.reader.getAttributeValue(null, "srclang");
                        if (this.srcLang.equals(LocaleId.EMPTY)) {
                            if (hSrcLang == null) {
                                throw new OkapiBadFilterInputException("Header element is missing the srclang attribute.");
                            }
                            if ("*all*".equals(hSrcLang)) {
                                throw new OkapiBadFilterInputException("TmxFilter does not support \"*all*\". Please define a source locale.");
                            }
                            this.srcLang = LocaleId.fromString(hSrcLang);
                            pp = new PipelineParameters(this.startDoc, this.input, null, null);
                            pp.setSourceLocale(this.srcLang);
                        }
                        this.headerSegType = hSegType != null ? (hSegType.equals("sentence") ? 0 : 1) : -1;
                        this.processHeader();
                        this.queue.add(new Event(EventType.START_DOCUMENT, this.startDoc));
                        if (pp != null) {
                            this.queue.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
                        }
                        if (Util.isEmpty(this.getParameters().getSimplifierRules())) continue block12;
                        Event cs = FilterUtil.createCodeSimplifierEvent(this.getParameters().getSimplifierRules());
                        this.queue.add(cs);
                        break;
                    }
                    this.storeStartElement();
                    if (this.params.getConsolidateDpSkeleton()) break;
                    dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                    this.skel = new GenericSkeleton();
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    break;
                }
                case 2: {
                    this.storeEndElement();
                    if (this.params.getConsolidateDpSkeleton()) break;
                    DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                    this.skel = new GenericSkeleton();
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    break;
                }
                case 6: 
                case 12: {
                    this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                    break;
                }
                case 4: {
                    this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 11: {
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        return false;
    }

    private void storeStartElement() {
        int i;
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.skel.append("<" + this.reader.getLocalName());
        } else {
            this.skel.append("<" + prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            TmxUtils.copyXMLNSToSkeleton(this.skel, this.reader.getNamespacePrefix(i), this.reader.getNamespaceURI(i));
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            TmxUtils.copyAttributeToSkeleton(this.skel, this.reader, i, prefix, this.params.getEscapeGT());
        }
        this.skel.append(">");
    }

    private void storeEndElement() {
        String ns = this.reader.getPrefix();
        if (ns == null || ns.length() == 0) {
            this.skel.append("</" + this.reader.getLocalName() + ">");
        } else {
            this.skel.append("</" + ns + ":" + this.reader.getLocalName() + ">");
        }
    }

    private boolean processTuDocumentPart(TmxTu tmxTu) {
        String propName = "";
        String startElement = this.reader.getLocalName();
        if (this.tuvTrgType == TuvXmlLang.UNDEFINED) {
            propName = tmxTu.parseStartElement(this.reader, startElement, this.params.getEscapeGT());
        } else if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets()) {
            propName = tmxTu.curTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.getProcessAllTargets(), this.params.getEscapeGT(), startElement);
        }
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: {
                        if (this.tuvTrgType == TuvXmlLang.UNDEFINED) {
                            tmxTu.appendToSkel(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                            tmxTu.addProp(new Property(propName, this.reader.getText(), true));
                            break;
                        }
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets()) {
                            tmxTu.curTuv.skelBefore.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                            tmxTu.curTuv.setProperty(new Property(propName, this.reader.getText(), true));
                            break;
                        }
                        if (this.tuvTrgType != TuvXmlLang.OTHER) break;
                        tmxTu.curTuv.skelBefore.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 2: {
                        if (!this.reader.getLocalName().equalsIgnoreCase(startElement)) break;
                        if (this.tuvTrgType == TuvXmlLang.UNDEFINED) {
                            tmxTu.parseEndElement(this.reader, true);
                        } else if (this.tuvTrgType == TuvXmlLang.UNDEFINED || this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets()) {
                            tmxTu.curTuv.parseEndElement(this.reader, true);
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private void processHeader() {
        this.storeStartElement();
        if (!this.params.getConsolidateDpSkeleton()) {
            DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
            this.skel = new GenericSkeleton();
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
        }
        String name = null;
        StringBuilder value = new StringBuilder();
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 5: {
                        this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 3: {
                        this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                        break;
                    }
                    case 6: 
                    case 12: {
                        this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                        break;
                    }
                    case 4: {
                        if (name != null) {
                            value.append(this.reader.getText().replace("\n", this.lineBreak));
                        }
                        this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 1: {
                        String curLocalName = this.reader.getLocalName();
                        if (curLocalName.equalsIgnoreCase("note")) {
                            name = "note";
                        } else if (curLocalName.equalsIgnoreCase("prop")) {
                            name = this.reader.getAttributeValue(null, "type");
                        }
                        this.storeStartElement();
                        if (this.params.getConsolidateDpSkeleton()) break;
                        DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                        this.skel = new GenericSkeleton();
                        this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        break;
                    }
                    case 2: {
                        DocumentPart dp;
                        String curLocalName = this.reader.getLocalName();
                        if (curLocalName.equalsIgnoreCase("note") || curLocalName.equalsIgnoreCase("prop")) {
                            this.startDoc.setProperty(new Property(name, value.toString(), true));
                            name = null;
                            value.setLength(0);
                        }
                        this.storeEndElement();
                        if (!this.params.getConsolidateDpSkeleton()) {
                            dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                            this.skel = new GenericSkeleton();
                            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        }
                        if (!curLocalName.equalsIgnoreCase("header")) break;
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processSeg(TmxTu tmxTu) {
        int id = 0;
        TextFragment tf = this.tuvTrgType == TuvXmlLang.SOURCE ? tmxTu.curTuv.tc.getFirstContent() : (this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets() ? tmxTu.curTuv.tc.getFirstContent() : null);
        tmxTu.curTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.getProcessAllTargets(), this.params.getEscapeGT());
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                if (this.skipInvalidTu) {
                    if (eventType != 2 || !this.reader.getLocalName().equalsIgnoreCase("seg")) continue;
                    return false;
                }
                block1 : switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets()) {
                            tf.append(this.reader.getText());
                            break;
                        }
                        tmxTu.curTuv.appendToSkel(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 1: {
                        String curLocalName = this.reader.getLocalName().toLowerCase();
                        if (!this.isValidElement(this.elemStack.peek(), curLocalName, this.params.getExitOnInvalid())) {
                            this.skipInvalidTu = true;
                            break;
                        }
                        if (curLocalName.equals("ut") && !this.skipUtWarning) {
                            this.logger.warn("<ut> is been deprecated in tmx 1.4.");
                            this.skipUtWarning = true;
                        }
                        this.elemStack.push(curLocalName);
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets()) {
                            switch (curLocalName) {
                                case "hi": 
                                case "ph": 
                                case "it": 
                                case "bpt": 
                                case "ept": 
                                case "ut": {
                                    id = this.generateCodeId(this.getAttribute("x"), this.getAttribute("i"));
                                }
                            }
                            switch (curLocalName) {
                                case "hi": {
                                    String typeAttr = this.getAttribute("type");
                                    String xAttr = this.getAttribute("x");
                                    String type = typeAttr != null ? typeAttr : "hi";
                                    String codeStr = "<hi";
                                    if (xAttr != null) {
                                        codeStr = codeStr + " x=\"" + xAttr + "\"";
                                    }
                                    if (typeAttr != null) {
                                        codeStr = codeStr + " type=\"" + typeAttr + "\"";
                                    }
                                    codeStr = codeStr + ">";
                                    tf.append(TextFragment.TagType.OPENING, "hi", codeStr, id);
                                    break block1;
                                }
                                case "ph": 
                                case "ut": {
                                    this.appendCode(TextFragment.TagType.PLACEHOLDER, id, curLocalName, curLocalName, tf);
                                    break block1;
                                }
                                case "it": {
                                    String pos = this.getAttribute("pos");
                                    if (pos == null) {
                                        this.logger.error("Attribute 'pos' is missing. Will map the <it> code to <ph>.");
                                        this.appendCode(TextFragment.TagType.PLACEHOLDER, id, curLocalName, curLocalName, tf);
                                        break block1;
                                    }
                                    if (pos.equals("begin")) {
                                        this.appendCode(TextFragment.TagType.OPENING, id, curLocalName, curLocalName, tf);
                                        break block1;
                                    }
                                    if (pos.equals("end")) {
                                        this.appendCode(TextFragment.TagType.CLOSING, id, curLocalName, curLocalName, tf);
                                        break block1;
                                    }
                                    this.logger.error("Invalide 'pos' value ('+pos+'). Will map the <it> code to <ph>.");
                                    this.appendCode(TextFragment.TagType.PLACEHOLDER, id, curLocalName, curLocalName, tf);
                                    break block1;
                                }
                                case "bpt": {
                                    this.appendCode(TextFragment.TagType.OPENING, id, curLocalName, "Xpt", tf);
                                    break block1;
                                }
                                case "ept": {
                                    this.appendCode(TextFragment.TagType.CLOSING, id, curLocalName, "Xpt", tf);
                                }
                            }
                            break;
                        }
                        tmxTu.curTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.getProcessAllTargets(), this.params.getEscapeGT());
                        break;
                    }
                    case 2: {
                        String curLocalName = this.reader.getLocalName();
                        this.elemStack.pop();
                        if (curLocalName.equalsIgnoreCase("seg")) {
                            tmxTu.curTuv.finishedSegSection = true;
                            tmxTu.curTuv.parseEndElement(this.reader);
                            return true;
                        }
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.getProcessAllTargets()) {
                            if (!curLocalName.equals("hi")) break;
                            tf.append(TextFragment.TagType.CLOSING, "hi", "</hi>");
                            break;
                        }
                        tmxTu.curTuv.parseEndElement(this.reader, true);
                    }
                }
            }
            List<Code> codes = tf.getCodes();
            if (codes.size() <= 1) {
                return false;
            }
            for (Code c : codes) {
                if (c.getId() != -1) continue;
                this.logger.warn("The id attributes x and i are missing for {}. An id will be auto-generated and may not match the same code in the translated segments.", (Object)c.getOuterData());
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processTranslationUnit() {
        TmxTu tmxTu = new TmxTu(this.srcLang, this.trgLang, this.lineBreak, this.params.getSegType(), this.params.getPropValueSep());
        tmxTu.parseStartElement(this.reader, this.params.getEscapeGT());
        if (tmxTu.segType > 1) {
            Property segTypeProp = tmxTu.getProp("segtype");
            if (segTypeProp != null) {
                tmxTu.segType = segTypeProp.getValue().equals("sentence") ? 0 : 1;
            }
            if (tmxTu.segType > 1 && this.headerSegType != -1) {
                if (this.headerSegType == 0) {
                    tmxTu.segType = 0;
                } else if (this.headerSegType == 1) {
                    tmxTu.segType = 1;
                }
            }
            if (tmxTu.segType == 2) {
                tmxTu.segType = 0;
            } else if (tmxTu.segType == 3) {
                tmxTu.segType = 1;
            }
        }
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                if (this.skipInvalidTu) {
                    if (eventType != 2 || !this.reader.getLocalName().equalsIgnoreCase("tu")) continue;
                    this.tuvTrgType = TuvXmlLang.UNDEFINED;
                    this.skipInvalidTu = false;
                    this.elemStack.clear();
                    Property p = tmxTu.getProp("tuid");
                    if (p != null) {
                        this.logger.warn("Skipping invalid <tu> element with tuid: {}.", (Object)p.getValue());
                    } else {
                        this.logger.warn("Skipping invalid <tu> element.");
                    }
                    return true;
                }
                switch (eventType) {
                    case 5: {
                        tmxTu.smartAppendToSkel(this.tuvTrgType, "<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 4: {
                        tmxTu.smartAppendToSkel(this.tuvTrgType, Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 1: {
                        String curLocalName = this.reader.getLocalName();
                        if (curLocalName.equalsIgnoreCase("note") || curLocalName.equalsIgnoreCase("prop")) {
                            this.processTuDocumentPart(tmxTu);
                            break;
                        }
                        if (this.reader.getLocalName().equals("tuv")) {
                            LocaleId currentLang = this.getXmlLangFromCurTuv();
                            this.tuvTrgType = this.getTuvTrgType(currentLang);
                            TmxTuv tmxTuv = tmxTu.addTmxTuv(currentLang, this.tuvTrgType, this.params.getPropValueSep());
                            tmxTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.getProcessAllTargets(), this.params.getEscapeGT());
                            break;
                        }
                        if (!this.reader.getLocalName().equals("seg")) break;
                        this.elemStack.push("seg");
                        this.processSeg(tmxTu);
                        break;
                    }
                    case 2: {
                        String curLocalName = this.reader.getLocalName();
                        if (curLocalName.equalsIgnoreCase("tu")) {
                            tmxTu.parseEndElement(this.reader);
                            this.tuId = tmxTu.addPrimaryTextUnitEvent(this.tuId, this.params.getProcessAllTargets(), this.queue);
                            this.tuId = tmxTu.addDuplicateTextUnitEvents(this.tuId, this.params.getProcessAllTargets(), this.queue);
                            this.tuvTrgType = TuvXmlLang.UNDEFINED;
                            return true;
                        }
                        if (curLocalName.equals("tuv")) {
                            tmxTu.curTuv.parseEndElement(this.reader);
                            break;
                        }
                        if (this.params.getExitOnInvalid()) {
                            throw new OkapiBadFilterInputException("Only <note>, <prop>, and <tuv> elements are allowed inside <tu>");
                        }
                        this.logger.warn("Only <note>, <prop>, and <tuv> elements are allowed inside <tu>");
                        this.skipInvalidTu = true;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return false;
    }

    private void appendCode(TextFragment.TagType tagType, int id, String tagName, String type, TextFragment fragment) {
        try {
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                TmxUtils.copyAttributeToBuffer(outerCode, this.reader, i, this.lineBreak, this.params.getEscapeGT());
            }
            outerCode.append(">");
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        int i;
                        String localName = this.reader.getLocalName().toLowerCase();
                        if (!this.isValidElement(this.elemStack.peek(), localName, true)) {
                            // empty if block
                        }
                        if (localName.equals("ut") && !this.skipUtWarning) {
                            this.logger.warn("<ut> is been deprecated in tmx 1.4.");
                            this.skipUtWarning = true;
                        }
                        this.elemStack.push(localName);
                        if ("sub".equals(this.reader.getLocalName())) {
                            this.logger.warn("A <sub> element was detected. It will be included in its parent code as <sub> is currently not supported.");
                        }
                        String prefix = this.reader.getPrefix();
                        StringBuilder tmpg = new StringBuilder();
                        if (prefix == null || prefix.length() == 0) {
                            tmpg.append("<" + this.reader.getLocalName());
                        } else {
                            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
                        }
                        count = this.reader.getNamespaceCount();
                        for (i = 0; i < count; ++i) {
                            TmxUtils.copyXMLNSToBuffer(tmpg, this.reader.getNamespacePrefix(i), this.reader.getNamespaceURI(i));
                        }
                        count = this.reader.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            if (!this.reader.isAttributeSpecified(i)) continue;
                            TmxUtils.copyAttributeToBuffer(tmpg, this.reader, i, this.lineBreak, this.params.getEscapeGT());
                        }
                        tmpg.append(">");
                        innerCode.append(tmpg.toString());
                        outerCode.append(tmpg.toString());
                        break;
                    }
                    case 2: {
                        this.elemStack.pop();
                        if (tagName.equals(this.reader.getLocalName()) && (this.elemStack.peek().equals("seg") || this.elemStack.peek().equals("hi"))) {
                            Code code = fragment.append(tagType, type, innerCode.toString(), id);
                            outerCode.append("</" + tagName + ">");
                            code.setOuterData(outerCode.toString());
                            return;
                        }
                        String ns = this.reader.getPrefix();
                        if (ns == null || ns.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + ns + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + ns + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private TuvXmlLang getTuvTrgType(LocaleId lang) {
        if (lang.equals(this.srcLang)) {
            return TuvXmlLang.SOURCE;
        }
        if (lang.equals(this.trgLang)) {
            return TuvXmlLang.TARGET;
        }
        return TuvXmlLang.OTHER;
    }

    private LocaleId getXmlLangFromCurTuv() {
        String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (tmp != null) {
            return LocaleId.fromString(tmp);
        }
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.getAttributeLocalName(i).equals("lang")) continue;
            return LocaleId.fromString(this.reader.getAttributeValue(i));
        }
        throw new OkapiBadFilterInputException("The required xml:lang or lang attribute is missing in <tuv>. The file is not valid TMX.");
    }

    private String getAttribute(String localName) {
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.getAttributeLocalName(i).equals(localName)) continue;
            return this.reader.getAttributeValue(i);
        }
        return null;
    }

    private boolean isValidElement(String curElem, String newElem, boolean throwException) {
        String rules = this.rulesMap.get("<" + curElem + ">");
        if (rules != null && rules.contains("<" + newElem + ">")) {
            return true;
        }
        if (throwException) {
            throw new OkapiBadFilterInputException("<" + newElem + "> not allowed in <" + curElem + ">. Only " + rules + " allowed.");
        }
        this.logger.warn("<{}> not allowed in <{}>. Only {} allowed.", newElem, curElem, rules);
        return false;
    }

    private int generateCodeId(String x, String i) {
        int id = -1;
        if (!Util.isEmpty(x)) {
            try {
                id = Integer.valueOf(x);
            }
            catch (NumberFormatException e) {
                id = x.hashCode();
            }
            return id;
        }
        if (!Util.isEmpty(i)) {
            try {
                id = Integer.valueOf(i);
            }
            catch (NumberFormatException e) {
                id = i.hashCode();
            }
        }
        return id;
    }

    public static enum TuvXmlLang {
        UNDEFINED,
        SOURCE,
        TARGET,
        OTHER;

    }
}

