/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.util.Arrays;
import java.util.Optional;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    public static final int TARGETSTATEMODE_IGNORE = 0;
    public static final int TARGETSTATEMODE_EXTRACT = 1;
    public static final int TARGETSTATEMODE_DONOTEXTRACT = 2;
    public static final String ADDALTTRANS = "addAltTrans";
    public static final String ADDALTTRANSGMODE = "addAltTransGMode";
    public static final String EDITALTTRANS = "editAltTrans";
    private static final String USECUSTOMPARSER = "useCustomParser";
    private static final String FACTORYCLASS = "factoryClass";
    private static final String FALLBACKTOID = "fallbackToID";
    private static final String ADDTARGETLANGUAGE = "addTargetLanguage";
    private static final String OVERRIDETARGETLANGUAGE = "overrideTargetLanguage";
    private static final String ALLOWEMPTYTARGETS = "allowEmptyTargets";
    private static final String OUTPUTSEGMENTATIONTYPE = "outputSegmentationType";
    private static final String IGNOREINPUTSEGMENTATION = "ignoreInputSegmentation";
    private static final String INCLUDEEXTENSIONS = "includeExtensions";
    private static final String TARGETSTATEMODE = "targetStateMode";
    private static final String TARGETSTATEVALUE = "targetStateValue";
    private static final String INCLUDEITS = "includeIts";
    private static final String BALANCECODES = "balanceCodes";
    private static final String ALWAYSUSESEGSOURCE = "alwaysUseSegSource";
    private static final String PRESERVESPACEBYDEFAULT = "preserveSpaceByDefault";
    private static final String USESDLXLIFFWRITER = "useSdlXliffWriter";
    private static final String SDLSEGLOCKEDVALUE = "sdlSegLockedValue";
    private static final String SDLSEGCONFVALUE = "sdlSegConfValue";
    private static final String SDLSEGORIGINVALUE = "sdlSegOriginValue";
    private static final String SKIPNOMRKSEGSOURCE = "skipNoMrkSegSource";
    private static final String USEIWSXLIFFWRITER = "useIwsXliffWriter";
    private static final String IWSBLOCKFINISHED = "iwsBlockFinished";
    private static final String IWSTRANSSTATUSVALUE = "iwsTransStatusValue";
    private static final String IWSTRANSTYPEVALUE = "iwsTransTypeValue";
    private static final String IWSBLOCKLOCKSTATUS = "iwsBlockLockStatus";
    private static final String IWSBLOCKTMSCORE = "iwsBlockTmScore";
    private static final String IWSBLOCKTMSCOREVALUE = "iwsBlockTmScoreValue";
    private static final String IWSBLOCKMULTIPLEEXACT = "iwsBlockMultipleExact";
    private static final String INLINECDATA = "inlineCdata";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private InlineCodeFinder codeFinder;

    public boolean getUseCustomParser() {
        return this.getBoolean(USECUSTOMPARSER);
    }

    public void setUseCustomParser(boolean useCustomParser) {
        this.setBoolean(USECUSTOMPARSER, useCustomParser);
    }

    public String getFactoryClass() {
        return this.getString(FACTORYCLASS);
    }

    public void setFactoryClass(String factoryClass) {
        this.setString(FACTORYCLASS, factoryClass);
    }

    public boolean getEscapeGT() {
        return this.getBoolean("escapeGT");
    }

    public void setEscapeGT(boolean escapeGT) {
        this.setBoolean("escapeGT", escapeGT);
    }

    public boolean getFallbackToID() {
        return this.getBoolean(FALLBACKTOID);
    }

    public void setFallbackToID(boolean fallbackToID) {
        this.setBoolean(FALLBACKTOID, fallbackToID);
    }

    public boolean getAddTargetLanguage() {
        return this.getBoolean(ADDTARGETLANGUAGE);
    }

    public void setAddTargetLanguage(boolean addTargetLanguage) {
        this.setBoolean(ADDTARGETLANGUAGE, addTargetLanguage);
    }

    public boolean getOverrideTargetLanguage() {
        return this.getBoolean(OVERRIDETARGETLANGUAGE);
    }

    public void setOverrideTargetLanguage(boolean overrideTargetLanguage) {
        this.setBoolean(OVERRIDETARGETLANGUAGE, overrideTargetLanguage);
    }

    public SegmentationType getOutputSegmentationType() {
        return SegmentationType.byValue(this.getInteger(OUTPUTSEGMENTATIONTYPE)).orElse(SegmentationType.ORIGINAL);
    }

    public void setOutputSegmentationType(SegmentationType segmentationType) {
        this.setInteger(OUTPUTSEGMENTATIONTYPE, segmentationType.value);
    }

    public boolean getIgnoreInputSegmentation() {
        return this.getBoolean(IGNOREINPUTSEGMENTATION);
    }

    public void setIgnoreInputSegmentation(boolean ignoreInputSegmentation) {
        this.setBoolean(IGNOREINPUTSEGMENTATION, ignoreInputSegmentation);
    }

    public boolean getAddAltTrans() {
        return this.getBoolean(ADDALTTRANS);
    }

    public void setAddAltTrans(boolean addAltTrans) {
        this.setBoolean(ADDALTTRANS, addAltTrans);
    }

    public boolean getAddAltTransGMode() {
        return this.getBoolean(ADDALTTRANSGMODE);
    }

    public void setAddAltTransGMode(boolean addAltTransGMode) {
        this.setBoolean(ADDALTTRANSGMODE, addAltTransGMode);
    }

    public boolean getEditAltTrans() {
        return this.getBoolean(EDITALTTRANS);
    }

    public void setEditAltTrans(boolean editAltTrans) {
        this.setBoolean(EDITALTTRANS, editAltTrans);
    }

    public boolean getIncludeExtensions() {
        return this.getBoolean(INCLUDEEXTENSIONS);
    }

    public void setIncludeExtensions(boolean includeExtensions) {
        this.setBoolean(INCLUDEEXTENSIONS, includeExtensions);
    }

    public boolean getIncludeIts() {
        return this.getBoolean(INCLUDEITS);
    }

    public void setIncludeIts(boolean includeIts) {
        this.setBoolean(INCLUDEITS, includeIts);
    }

    public boolean getBalanceCodes() {
        return this.getBoolean(BALANCECODES);
    }

    public void setBalanceCodes(boolean balanceCodes) {
        this.setBoolean(BALANCECODES, balanceCodes);
    }

    public boolean getAllowEmptyTargets() {
        return this.getBoolean(ALLOWEMPTYTARGETS);
    }

    public void setAllowEmptyTargets(boolean allowEmptyTargets) {
        this.setBoolean(ALLOWEMPTYTARGETS, allowEmptyTargets);
    }

    public int getTargetStateMode() {
        return this.getInteger(TARGETSTATEMODE);
    }

    public void setTargetStateMode(int targetStateMode) {
        this.setInteger(TARGETSTATEMODE, targetStateMode);
    }

    public String getTargetStateValue() {
        return this.getString(TARGETSTATEVALUE);
    }

    public void setTargetStateValue(String targetStateValue) {
        this.setString(TARGETSTATEVALUE, targetStateValue);
    }

    public boolean getQuoteModeDefined() {
        return this.getBoolean("quoteModeDefined");
    }

    public boolean isAlwaysUseSegSource() {
        return this.getBoolean(ALWAYSUSESEGSOURCE);
    }

    public void setAlwaysUseSegSource(boolean alwaysUSeSegSource) {
        this.setBoolean(ALWAYSUSESEGSOURCE, alwaysUSeSegSource);
    }

    public boolean isPreserveSpaceByDefault() {
        return this.getBoolean(PRESERVESPACEBYDEFAULT);
    }

    public void setPreserveSpaceByDefault(boolean preserveSpaceByDefault) {
        this.setBoolean(PRESERVESPACEBYDEFAULT, preserveSpaceByDefault);
    }

    protected void setQuoteModeDefined(boolean defined) {
        this.setBoolean("quoteModeDefined", defined);
    }

    public int getQuoteMode() {
        return this.getInteger("quoteMode");
    }

    protected void setQuoteMode(int quoteMode) {
        this.setInteger("quoteMode", quoteMode);
    }

    public boolean isUseSdlXliffWriter() {
        return this.getBoolean(USESDLXLIFFWRITER);
    }

    public void setUseSdlXliffWriter(boolean useSdlXliffWriter) {
        this.setBoolean(USESDLXLIFFWRITER, useSdlXliffWriter);
    }

    public String getSdlSegLockedValue() {
        return this.getString(SDLSEGLOCKEDVALUE);
    }

    public void setSdlSegLockedValue(String sdlSegLockedvalue) {
        this.setString(SDLSEGLOCKEDVALUE, sdlSegLockedvalue);
    }

    public String getSdlSegConfValue() {
        return this.getString(SDLSEGCONFVALUE);
    }

    public void setSdlSegConfValue(String sdlSegConfvalue) {
        this.setString(SDLSEGCONFVALUE, sdlSegConfvalue);
    }

    public String getSdlSegOriginValue() {
        return this.getString(SDLSEGORIGINVALUE);
    }

    public void setSdlSegOriginValue(String sdlSegOriginvalue) {
        this.setString(SDLSEGORIGINVALUE, sdlSegOriginvalue);
    }

    public boolean isInlineCdata() {
        return this.getBoolean(INLINECDATA);
    }

    public void setInlineCdata(boolean inlineCdata) {
        this.setBoolean(INLINECDATA, inlineCdata);
    }

    public boolean getSkipNoMrkSegSource() {
        return this.getBoolean(SKIPNOMRKSEGSOURCE);
    }

    public void setSkipNoMrkSegSource(boolean skipNoMrkSegSource) {
        this.setBoolean(SKIPNOMRKSEGSOURCE, skipNoMrkSegSource);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    public boolean isUseIwsXliffWriter() {
        return this.getBoolean(USEIWSXLIFFWRITER);
    }

    public void setUseIwsXliffWriter(boolean useIwsXliffWriter) {
        this.setBoolean(USEIWSXLIFFWRITER, useIwsXliffWriter);
    }

    public boolean isIwsBlockFinished() {
        return this.getBoolean(IWSBLOCKFINISHED);
    }

    public void setIwsBlockFinished(boolean iwsBlockFinished) {
        this.setBoolean(IWSBLOCKFINISHED, iwsBlockFinished);
    }

    public String getIwsTransStatusValue() {
        return this.getString(IWSTRANSSTATUSVALUE);
    }

    public void setIwsTransStatusValue(String iwsTransStatusValue) {
        this.setString(IWSTRANSSTATUSVALUE, iwsTransStatusValue);
    }

    public String getIwsTransTypeValue() {
        return this.getString(IWSTRANSTYPEVALUE);
    }

    public void setIwsTransTypeValue(String iwsTransTypeValue) {
        this.setString(IWSTRANSTYPEVALUE, iwsTransTypeValue);
    }

    public void setIwsBlockLockStatus(boolean iwsBlockLockStatus) {
        this.setBoolean(IWSBLOCKLOCKSTATUS, iwsBlockLockStatus);
    }

    public boolean isIwsBlockLockStatus() {
        return this.getBoolean(IWSBLOCKLOCKSTATUS);
    }

    public void setIwsBlockTmScore(boolean iwsBlockTmScore) {
        this.setBoolean(IWSBLOCKTMSCORE, iwsBlockTmScore);
    }

    public boolean isIwsBlockTmScore() {
        return this.getBoolean(IWSBLOCKTMSCORE);
    }

    public void setIwsBlockTmScoreValue(String iwsBlockTmScoreValue) {
        this.setString(IWSBLOCKTMSCOREVALUE, iwsBlockTmScoreValue);
    }

    public String getIwsBlockTmScoreValue() {
        return this.getString(IWSBLOCKTMSCOREVALUE);
    }

    public void setIwsBlockMultipleExact(boolean iwsBlockMultipleExact) {
        this.setBoolean(IWSBLOCKMULTIPLEEXACT, iwsBlockMultipleExact);
    }

    public boolean isIwsBlockMultipleExact() {
        return this.getBoolean(IWSBLOCKMULTIPLEEXACT);
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseCustomParser(true);
        this.setFactoryClass("com.ctc.wstx.stax.WstxInputFactory");
        this.setFallbackToID(false);
        this.setEscapeGT(false);
        this.setAddTargetLanguage(true);
        this.setOverrideTargetLanguage(false);
        this.setOutputSegmentationType(SegmentationType.ORIGINAL);
        this.setIgnoreInputSegmentation(false);
        this.setAddAltTrans(false);
        this.setAddAltTransGMode(true);
        this.setEditAltTrans(false);
        this.setIncludeExtensions(true);
        this.setIncludeIts(true);
        this.setBalanceCodes(true);
        this.setAllowEmptyTargets(false);
        this.setTargetStateMode(0);
        this.setTargetStateValue("needs-translation");
        this.setAlwaysUseSegSource(false);
        this.setQuoteModeDefined(true);
        this.setQuoteMode(0);
        this.setUseSdlXliffWriter(false);
        this.setPreserveSpaceByDefault(false);
        this.setSdlSegLockedValue(null);
        this.setSdlSegConfValue(null);
        this.setSdlSegOriginValue(null);
        this.setUseIwsXliffWriter(false);
        this.setIwsBlockFinished(true);
        this.setIwsTransStatusValue("finished");
        this.setIwsTransTypeValue("manual_translation");
        this.setIwsBlockLockStatus(false);
        this.setIwsBlockTmScore(false);
        this.setIwsBlockTmScoreValue("100.00");
        this.setIwsBlockMultipleExact(false);
        this.setInlineCdata(false);
        this.setSkipNoMrkSegSource(false);
        this.setSimplifierRules(null);
        this.setUseCodeFinder(false);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }

    public static enum SegmentationType {
        ORIGINAL(0),
        SEGMENTED(1),
        NOTSEGMENTED(2),
        ASNEEDED(3);

        private final int value;

        private SegmentationType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Optional<SegmentationType> byValue(int value) {
            return Arrays.stream(SegmentationType.values()).filter(type -> type.value == value).findFirst();
        }
    }
}

