/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import com.ibm.icu.lang.UCharacter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Locale;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.verification.BlackTerm;

public class BlacklistReader
implements Iterator<BlackTerm> {
    private BlackTerm nextEntry;
    private BufferedReader reader;
    private LocaleId locale = new LocaleId(Locale.getDefault());

    public BlacklistReader() {
        this.reset();
    }

    public BlacklistReader(LocaleId loc) {
        this();
        this.locale = loc;
    }

    public void reset() {
        this.nextEntry = null;
        this.reader = null;
    }

    public void open(File file) {
        try {
            this.open(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    public void open(InputStream input) {
        try {
            this.close();
            String encoding = "UTF-8";
            BOMAwareInputStream bis = new BOMAwareInputStream(input, encoding);
            encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
            this.readNext();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    public void close() {
        this.nextEntry = null;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public BlackTerm next() {
        BlackTerm currentEntry = this.nextEntry;
        this.readNext();
        return currentEntry;
    }

    private void readNext() {
        try {
            BlackTerm bterm;
            String[] parts;
            String line;
            this.nextEntry = null;
            do {
                if ((line = this.reader.readLine()) != null) continue;
                return;
            } while ((line = line.trim()).isEmpty() || (parts = line.split("\\t"))[0].isEmpty());
            this.nextEntry = bterm = this.populateBlackTerm(parts);
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    private BlackTerm populateBlackTerm(String[] parts) {
        BlackTerm bterm = new BlackTerm();
        bterm.text = parts[0];
        bterm.suggestion = parts.length == 1 ? "" : parts[1];
        bterm.comment = parts.length < 3 ? "" : parts[2];
        bterm.dispSeverity = parts.length < 4 ? 0 : BlacklistReader.parseBlackTermDispSeverity(parts[3]);
        bterm.searchTerm = UCharacter.toUpperCase(this.locale.toIcuLocale(), bterm.text);
        String suggestionUpperCase = UCharacter.toUpperCase(this.locale.toIcuLocale(), bterm.suggestion);
        if (bterm.searchTerm.equals(suggestionUpperCase)) {
            bterm.doCaseSensitiveMatch = true;
            bterm.searchTerm = bterm.text;
        }
        return bterm;
    }

    private static int parseBlackTermDispSeverity(String string) {
        int value = 0;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == 2) {
            return 2;
        }
        if (value == 1) {
            return 1;
        }
        return 0;
    }
}

